/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.formats.delta;

import com.dataiku.dip.coremodel.SchemaColumn;
import com.dataiku.dip.datasets.Type;
import com.dataiku.dip.formats.delta.DeltaFormat;
import com.dataiku.dip.partitioning.DimensionValue;
import com.dataiku.dip.partitioning.TimeDimension;
import com.dataiku.dip.partitioning.TimeDimensionValue;
import com.dataiku.dip.utils.ErrorContext;
import com.dataiku.dss.shadelib.org.joda.time.Days;
import com.dataiku.dss.shadelib.org.joda.time.LocalDate;
import com.dataiku.dss.shadelib.org.joda.time.ReadablePartial;
import com.dataiku.dss.shadelib.org.joda.time.format.DateTimeFormat;
import com.dataiku.dss.shadelib.org.joda.time.format.DateTimeFormatter;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import io.delta.kernel.expressions.Literal;
import io.delta.kernel.types.ArrayType;
import io.delta.kernel.types.BinaryType;
import io.delta.kernel.types.BooleanType;
import io.delta.kernel.types.ByteType;
import io.delta.kernel.types.DataType;
import io.delta.kernel.types.DateType;
import io.delta.kernel.types.DecimalType;
import io.delta.kernel.types.DoubleType;
import io.delta.kernel.types.FloatType;
import io.delta.kernel.types.IntegerType;
import io.delta.kernel.types.LongType;
import io.delta.kernel.types.MapType;
import io.delta.kernel.types.ShortType;
import io.delta.kernel.types.StringType;
import io.delta.kernel.types.StructField;
import io.delta.kernel.types.StructType;
import io.delta.kernel.types.TimestampNTZType;
import io.delta.kernel.types.TimestampType;
import java.math.BigDecimal;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;

public class DeltaFormatUtils {
    private static final DateTimeFormatter YYYY = DateTimeFormat.forPattern((String)"yyyy");
    private static final DateTimeFormatter YYYY_MM = DateTimeFormat.forPattern((String)"yyyy-MM");
    private static final DateTimeFormatter YYYY_MM_DD = DateTimeFormat.forPattern((String)"yyyy-MM-dd");
    private static final DateTimeFormatter YYYY_MM_DD_HH = DateTimeFormat.forPattern((String)"yyyy-MM-dd HH");
    private static final DateTimeFormatter YYYY_MM_DD_HH_MM_SS = DateTimeFormat.forPattern((String)"yyyy-MM-dd HH:mm:ss");
    private static final DateTimeFormatter YYYY_MM_DD_T_HH_MM_SS_SSS_Z = DateTimeFormat.forPattern((String)"yyyy-MM-dd'T'HH:mm:ss.SSSZ");
    private static final LocalDate EPOCH_DATEONLY = new LocalDate(1970, 1, 1);

    public static List<SchemaColumn> convert(StructType structType, DeltaFormat.Config formatConfig) {
        ArrayList columns = Lists.newArrayList();
        for (StructField field : structType.fields()) {
            columns.add(DeltaFormatUtils.convert(field, formatConfig));
        }
        return columns;
    }

    private static void throwIncompatibility(String msg, String context) {
        throw ErrorContext.iae((String)(msg + " in Delta data at " + StringUtils.defaultIfBlank((String)context, (String)"(root)") + ". Please check dataset schema"));
    }

    public static void checkCompatibility(List<SchemaColumn> columnsActual, List<SchemaColumn> columnsExpected, String context) {
        if (StringUtils.isNotBlank((String)context) && columnsActual.size() != columnsExpected.size() || columnsActual.size() < columnsExpected.size()) {
            DeltaFormatUtils.throwIncompatibility("Invalid number of columns", context);
        }
        Map columnsActualByName = columnsActual.stream().collect(Collectors.toMap(SchemaColumn::getName, Function.identity()));
        Map columnsExpectedByName = columnsExpected.stream().collect(Collectors.toMap(SchemaColumn::getName, Function.identity()));
        if (StringUtils.isNotBlank((String)context) && !Sets.symmetricDifference(columnsActualByName.keySet(), columnsExpectedByName.keySet()).isEmpty() || !Sets.difference(columnsExpectedByName.keySet(), columnsActualByName.keySet()).isEmpty()) {
            DeltaFormatUtils.throwIncompatibility("Difference of columns", context);
        }
        for (String name : columnsActualByName.keySet()) {
            SchemaColumn columnActual = (SchemaColumn)columnsActualByName.get(name);
            SchemaColumn columnExpected = (SchemaColumn)columnsExpectedByName.get(name);
            if (columnExpected != null) {
                DeltaFormatUtils.checkCompatibility(columnActual, columnExpected, StringUtils.defaultIfBlank((String)context, (String)"(root)") + " -> " + name);
                continue;
            }
            if (!StringUtils.isNotBlank((String)context)) continue;
            throw ErrorContext.iae((String)("Column " + name + " should be defined in the schema at " + context));
        }
    }

    public static void checkCompatibility(SchemaColumn columnActual, SchemaColumn columnExpected, String context) {
        Type expectedType = columnExpected.getType();
        Type actualType = columnActual.getType();
        if (expectedType == Type.STRING) {
            return;
        }
        if (expectedType.isPrimitive() != actualType.isPrimitive()) {
            DeltaFormatUtils.throwIncompatibility("Incompatible type of columns", context);
        }
        if (expectedType.isPrimitive()) {
            if (expectedType.isFloatingPoint()) {
                if (!actualType.isNumeric()) {
                    DeltaFormatUtils.throwIncompatibility("Incompatible type of columns", context);
                }
            } else if (expectedType.isInteger()) {
                if (!actualType.isInteger()) {
                    DeltaFormatUtils.throwIncompatibility("Incompatible type of columns", context);
                }
            } else if (expectedType == Type.DATE) {
                if (actualType != Type.DATE && actualType != Type.DATEONLY) {
                    DeltaFormatUtils.throwIncompatibility("Incompatible type of columns", context);
                }
            } else if (expectedType != actualType) {
                DeltaFormatUtils.throwIncompatibility("Incompatible type of columns", context);
            }
        } else {
            if (expectedType != actualType) {
                DeltaFormatUtils.throwIncompatibility("Incompatible type of columns", context);
            }
            if (expectedType == Type.ARRAY) {
                DeltaFormatUtils.checkCompatibility(columnActual.arrayContent, columnExpected.arrayContent, context);
            } else if (expectedType == Type.MAP) {
                DeltaFormatUtils.checkCompatibility(columnActual.mapKeys, columnExpected.mapKeys, context + "(keys)");
                DeltaFormatUtils.checkCompatibility(columnActual.mapValues, columnExpected.mapValues, context + "(values)");
            } else if (expectedType == Type.OBJECT) {
                DeltaFormatUtils.checkCompatibility(columnActual.objectFields, columnExpected.objectFields, context);
            }
        }
    }

    private static SchemaColumn convert(StructField structField, DeltaFormat.Config formatConfig) {
        return DeltaFormatUtils.convert(structField.getName(), structField.getDataType(), formatConfig);
    }

    private static SchemaColumn convert(String name, DataType dataType, DeltaFormat.Config formatConfig) {
        SchemaColumn column = new SchemaColumn(name, Type.STRING);
        column.originalType = dataType.getClass().getSimpleName();
        if (dataType instanceof StringType) {
            column.setType(Type.STRING);
        } else if (dataType instanceof BooleanType) {
            column.setType(Type.BOOLEAN);
        } else if (dataType instanceof ByteType) {
            column.setType(Type.TINYINT);
        } else if (dataType instanceof ShortType) {
            column.setType(Type.SMALLINT);
        } else if (dataType instanceof IntegerType) {
            column.setType(Type.INT);
        } else if (dataType instanceof LongType) {
            column.setType(Type.BIGINT);
        } else if (dataType instanceof FloatType) {
            column.setType(Type.FLOAT);
        } else if (dataType instanceof DoubleType) {
            column.setType(Type.DOUBLE);
        } else if (dataType instanceof DecimalType) {
            column.setType(((DecimalType)dataType).getScale() > 0 ? Type.DOUBLE : Type.BIGINT);
        } else if (dataType instanceof DateType) {
            if (formatConfig.readTemporalMode == DeltaFormat.Config.ReadTemporalMode.AS_DATE) {
                column.setType(Type.DATE);
            } else {
                column.setType(Type.DATEONLY);
            }
        } else if (dataType instanceof TimestampType) {
            column.setType(Type.DATE);
        } else if (dataType instanceof TimestampNTZType) {
            column.setType(Type.DATETIMENOTZ);
        } else if (dataType instanceof BinaryType) {
            column.setType(Type.STRING);
        } else if (dataType instanceof ArrayType) {
            column.setType(Type.ARRAY);
            column.arrayContent = DeltaFormatUtils.convert("contents", ((ArrayType)dataType).getElementType(), formatConfig);
        } else if (dataType instanceof MapType) {
            column.setType(Type.MAP);
            column.mapKeys = DeltaFormatUtils.convert("keys", ((MapType)dataType).getKeyType(), formatConfig);
            column.mapValues = DeltaFormatUtils.convert("values", ((MapType)dataType).getValueType(), formatConfig);
        } else if (dataType instanceof StructType) {
            column.setType(Type.OBJECT);
            column.objectFields = DeltaFormatUtils.convert((StructType)dataType, formatConfig);
        }
        return column;
    }

    public static Literal makeTypedLiteral(Map.Entry<String, DimensionValue> e, StructType dataSchema) {
        DimensionValue dimValue = e.getValue();
        String value = dimValue.id();
        String key = e.getKey();
        int idx = dataSchema.indexOf(key);
        DataType dataType = dataSchema.at(idx).getDataType();
        if (dataType instanceof StringType) {
            return Literal.ofString((String)value);
        }
        if (dataType instanceof BooleanType) {
            return Literal.ofBoolean((boolean)Boolean.parseBoolean(value));
        }
        if (dataType instanceof ByteType) {
            return Literal.ofByte((byte)((byte)Long.parseLong(value)));
        }
        if (dataType instanceof ShortType) {
            return Literal.ofShort((short)((short)Long.parseLong(value)));
        }
        if (dataType instanceof IntegerType) {
            return Literal.ofInt((int)((int)Long.parseLong(value)));
        }
        if (dataType instanceof LongType) {
            return Literal.ofLong((long)Long.parseLong(value));
        }
        if (dataType instanceof FloatType) {
            return Literal.ofFloat((float)((float)Double.parseDouble(value)));
        }
        if (dataType instanceof DoubleType) {
            return Literal.ofDouble((double)Double.parseDouble(value));
        }
        if (dataType instanceof DecimalType) {
            DecimalType decimalType = (DecimalType)dataType;
            return Literal.ofDecimal((BigDecimal)new BigDecimal(value), (int)decimalType.getPrecision(), (int)decimalType.getScale());
        }
        if (dataType instanceof DateType) {
            if (dimValue instanceof TimeDimensionValue) {
                TimeDimensionValue timeValue = (TimeDimensionValue)dimValue;
                return Literal.ofDate((int)((int)timeValue.getLocalDate().toEpochDay()));
            }
            return Literal.ofDate((int)Days.daysBetween((ReadablePartial)YYYY_MM_DD.parseLocalDate(value), (ReadablePartial)EPOCH_DATEONLY).getDays());
        }
        if (dataType instanceof TimestampType) {
            if (dimValue instanceof TimeDimensionValue) {
                TimeDimensionValue timeValue = (TimeDimensionValue)dimValue;
                return Literal.ofTimestamp((long)(timeValue.getUTCCalendar().getTimeInMillis() * 1000L));
            }
            return Literal.ofTimestamp((long)(YYYY_MM_DD_T_HH_MM_SS_SSS_Z.parseMillis(value) * 1000L));
        }
        if (dataType instanceof TimestampNTZType) {
            if (dimValue instanceof TimeDimensionValue) {
                TimeDimensionValue timeValue = (TimeDimensionValue)dimValue;
                return Literal.ofTimestampNtz((long)(timeValue.getUTCCalendar().getTimeInMillis() * 1000L));
            }
            return Literal.ofTimestampNtz((long)(YYYY_MM_DD_HH_MM_SS.parseMillis(value) * 1000L));
        }
        if (dataType instanceof BinaryType) {
            return Literal.ofBinary((byte[])value.getBytes(StandardCharsets.UTF_8));
        }
        throw new IllegalArgumentException("Can't use partitioning on type " + dataType.toString());
    }

    public static Literal makeSimpleTypedLiteral(String key, String value, StructType dataSchema) {
        int idx = dataSchema.indexOf(key);
        DataType dataType = dataSchema.at(idx).getDataType();
        if (dataType instanceof StringType) {
            return Literal.ofString((String)value);
        }
        if (dataType instanceof BooleanType) {
            return Literal.ofBoolean((boolean)Boolean.parseBoolean(value));
        }
        if (dataType instanceof ByteType) {
            return Literal.ofByte((byte)((byte)Long.parseLong(value)));
        }
        if (dataType instanceof ShortType) {
            return Literal.ofShort((short)((short)Long.parseLong(value)));
        }
        if (dataType instanceof IntegerType) {
            return Literal.ofInt((int)((int)Long.parseLong(value)));
        }
        if (dataType instanceof LongType) {
            return Literal.ofLong((long)Long.parseLong(value));
        }
        if (dataType instanceof FloatType) {
            return Literal.ofFloat((float)((float)Double.parseDouble(value)));
        }
        if (dataType instanceof DoubleType) {
            return Literal.ofDouble((double)Double.parseDouble(value));
        }
        if (dataType instanceof DecimalType) {
            DecimalType decimalType = (DecimalType)dataType;
            return Literal.ofDecimal((BigDecimal)new BigDecimal(value), (int)decimalType.getPrecision(), (int)decimalType.getScale());
        }
        if (dataType instanceof DateType) {
            return Literal.ofDate((int)Days.daysBetween((ReadablePartial)YYYY_MM_DD.parseLocalDate(value), (ReadablePartial)EPOCH_DATEONLY).getDays());
        }
        if (dataType instanceof TimestampType) {
            return Literal.ofTimestamp((long)(YYYY_MM_DD_T_HH_MM_SS_SSS_Z.parseMillis(value) * 1000L));
        }
        if (dataType instanceof TimestampNTZType) {
            return Literal.ofTimestampNtz((long)(YYYY_MM_DD_HH_MM_SS.parseMillis(value) * 1000L));
        }
        if (dataType instanceof BinaryType) {
            return Literal.ofBinary((byte[])value.getBytes(StandardCharsets.UTF_8));
        }
        throw new IllegalArgumentException("Can't use partitioning on type " + dataType.toString());
    }

    public static Literal makeSimpleTypedLiteral(DataType dataType, TimeDimensionValue value) {
        if (dataType instanceof StringType) {
            if (value.getDimension().mappedPeriod == TimeDimension.Period.YEAR) {
                return Literal.ofString((String)YYYY.print(value.getUTCCalendar().getTimeInMillis()));
            }
            if (value.getDimension().mappedPeriod == TimeDimension.Period.MONTH) {
                return Literal.ofString((String)YYYY_MM.print(value.getUTCCalendar().getTimeInMillis()));
            }
            if (value.getDimension().mappedPeriod == TimeDimension.Period.DAY) {
                return Literal.ofString((String)YYYY_MM_DD.print(value.getUTCCalendar().getTimeInMillis()));
            }
            if (value.getDimension().mappedPeriod == TimeDimension.Period.HOUR) {
                return Literal.ofString((String)YYYY_MM_DD_HH.print(value.getUTCCalendar().getTimeInMillis()));
            }
            return Literal.ofString((String)YYYY_MM_DD_HH_MM_SS.print(value.getUTCCalendar().getTimeInMillis()));
        }
        if (dataType instanceof BooleanType) {
            throw new IllegalArgumentException("Can't use time dimension with a boolean column");
        }
        if (dataType instanceof ByteType) {
            throw new IllegalArgumentException("Can't use time dimension with a byte column");
        }
        if (dataType instanceof ShortType) {
            if (value.getDimension().mappedPeriod == TimeDimension.Period.YEAR) {
                return Literal.ofShort((short)((short)value.getYear()));
            }
            throw new IllegalArgumentException("Can't use time dimension with a short column");
        }
        if (dataType instanceof IntegerType) {
            if (value.getDimension().mappedPeriod == TimeDimension.Period.YEAR) {
                return Literal.ofInt((int)value.getYear());
            }
            throw new IllegalArgumentException("Can't use time dimension with an int column");
        }
        if (dataType instanceof LongType) {
            if (value.getDimension().mappedPeriod == TimeDimension.Period.YEAR) {
                return Literal.ofLong((long)value.getYear());
            }
            throw new IllegalArgumentException("Can't use time dimension with a long column");
        }
        if (dataType instanceof FloatType) {
            if (value.getDimension().mappedPeriod == TimeDimension.Period.YEAR) {
                return Literal.ofFloat((float)value.getYear());
            }
            throw new IllegalArgumentException("Can't use time dimension with a float column");
        }
        if (dataType instanceof DoubleType) {
            if (value.getDimension().mappedPeriod == TimeDimension.Period.YEAR) {
                return Literal.ofDouble((double)value.getYear());
            }
            throw new IllegalArgumentException("Can't use time dimension with a doublee column");
        }
        if (dataType instanceof DecimalType) {
            DecimalType decimalType = (DecimalType)dataType;
            if (value.getDimension().mappedPeriod == TimeDimension.Period.YEAR) {
                return Literal.ofDecimal((BigDecimal)new BigDecimal(value.getYear()), (int)decimalType.getPrecision(), (int)decimalType.getScale());
            }
            throw new IllegalArgumentException("Can't use time dimension with a short column");
        }
        if (dataType instanceof DateType) {
            return Literal.ofDate((int)((int)value.getLocalDate().toEpochDay()));
        }
        if (dataType instanceof TimestampType) {
            return Literal.ofTimestamp((long)(value.getUTCCalendar().getTimeInMillis() * 1000L));
        }
        if (dataType instanceof TimestampNTZType) {
            return Literal.ofTimestampNtz((long)(value.getUTCCalendar().getTimeInMillis() * 1000L));
        }
        if (dataType instanceof BinaryType) {
            throw new IllegalArgumentException("Can't use time dimension with a binary column");
        }
        throw new IllegalArgumentException("Can't use time dimension on type " + dataType.toString());
    }
}

