/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.formats.delta;

import com.dataiku.dip.datasets.fs.HDFSableDatasetHandler;
import com.dataiku.dip.exceptions.CodedException;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.formats.delta.DeltaReaderClassLoaderLoader;
import com.dataiku.dip.partitioning.Dimension;
import com.dataiku.dip.partitioning.ExactValueDimension;
import com.dataiku.dip.partitioning.PartitioningScheme;
import com.dataiku.dip.partitioning.TimeDimension;
import com.dataiku.dip.utils.DKULogger;
import com.google.common.collect.Lists;
import io.delta.kernel.Scan;
import io.delta.kernel.ScanBuilder;
import io.delta.kernel.Snapshot;
import io.delta.kernel.Table;
import io.delta.kernel.data.FilteredColumnarBatch;
import io.delta.kernel.data.Row;
import io.delta.kernel.defaults.engine.DefaultEngine;
import io.delta.kernel.engine.Engine;
import io.delta.kernel.internal.InternalScanFileUtils;
import io.delta.kernel.internal.data.ScanStateRow;
import io.delta.kernel.types.DateType;
import io.delta.kernel.types.StructField;
import io.delta.kernel.types.StructType;
import io.delta.kernel.types.TimestampNTZType;
import io.delta.kernel.types.TimestampType;
import io.delta.kernel.utils.CloseableIterator;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.hadoop.conf.Configuration;

public class DeltaPartitioning {
    private final HDFSableDatasetHandler datasetHandler;
    private static DKULogger logger = DKULogger.getLogger((String)"dku.delta.partitioning");

    public DeltaPartitioning(HDFSableDatasetHandler datasetHandler) {
        this.datasetHandler = datasetHandler;
    }

    public PartitioningScheme readPartitioningScheme() throws IOException, DKUSecurityException, CodedException, InterruptedException {
        try (DeltaReaderClassLoaderLoader classLoaderLoader = new DeltaReaderClassLoaderLoader();){
            PartitioningScheme partitioningScheme = this.doReadPartitioningScheme();
            return partitioningScheme;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private PartitioningScheme doReadPartitioningScheme() throws IOException, DKUSecurityException, CodedException, InterruptedException {
        String path = this.datasetHandler.getFullyQualifiedRootPath();
        Configuration conf = new Configuration();
        this.datasetHandler.addExtraConf(conf, true);
        DefaultEngine engine = DefaultEngine.create((Configuration)conf);
        Table table = Table.forPath((Engine)engine, (String)path);
        Snapshot snapshot = table.getLatestSnapshot((Engine)engine);
        Map partitionValues = null;
        ScanBuilder scanBuilder = snapshot.getScanBuilder((Engine)engine);
        Scan scan = scanBuilder.build();
        Row scanState = scan.getScanState((Engine)engine);
        StructType physicalReadSchema = ScanStateRow.getPhysicalDataReadSchema((Engine)engine, (Row)scanState);
        try (CloseableIterator filesBatchIter = scan.getScanFiles((Engine)engine);){
            while (filesBatchIter.hasNext()) {
                FilteredColumnarBatch filesBatch = (FilteredColumnarBatch)filesBatchIter.next();
                CloseableIterator filesIter = filesBatch.getRows();
                try {
                    if (!filesIter.hasNext()) continue;
                    Row file = (Row)filesIter.next();
                    partitionValues = InternalScanFileUtils.getPartitionValues((Row)file);
                }
                finally {
                    if (filesIter == null) continue;
                    filesIter.close();
                }
            }
        }
        ArrayList partitionColumns = partitionValues == null ? new ArrayList() : Lists.newArrayList(partitionValues.keySet());
        StructType schema = snapshot.getSchema((Engine)engine);
        PartitioningScheme scheme = new PartitioningScheme();
        if (partitionColumns != null && !partitionColumns.isEmpty()) {
            List partitionColumnTypes = partitionColumns.stream().map(arg_0 -> ((StructType)schema).get(arg_0)).collect(Collectors.toList());
            StructField dateColumn = partitionColumnTypes.stream().filter(c -> c.getDataType() instanceof DateType).findFirst().orElseGet(() -> null);
            StructField timestampColumn = partitionColumnTypes.stream().filter(c -> c.getDataType() instanceof TimestampType || c.getDataType() instanceof TimestampNTZType).findFirst().orElseGet(() -> null);
            StringBuilder sb = new StringBuilder();
            for (StructField partitionColumnType : partitionColumnTypes) {
                sb.append("/");
                sb.append(partitionColumnType.getName());
                sb.append("=");
                if (partitionColumnType == dateColumn) {
                    scheme.addDimension((Dimension)new TimeDimension(partitionColumnType.getName(), TimeDimension.Period.DAY));
                    sb.append("%Y-%0M-%0D");
                    continue;
                }
                if (partitionColumnType == timestampColumn) {
                    scheme.addDimension((Dimension)new TimeDimension(partitionColumnType.getName(), TimeDimension.Period.HOUR));
                    sb.append("%Y-%0M-%0D %0H[^/]*");
                    continue;
                }
                scheme.addDimension((Dimension)new ExactValueDimension(partitionColumnType.getName()));
                sb.append("%{");
                sb.append(partitionColumnType.getName());
                sb.append("}");
            }
            sb.append("/.*");
            scheme.setFilePathPattern(sb.toString());
        }
        return scheme;
    }
}

