/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.hproxy.sandbox.hive.common;

import com.dataiku.dss.shadelib.org.apache.commons.io.FileUtils;
import com.dataiku.hproxy.model.hive.HiveConfEntry;
import com.dataiku.hproxy.sandbox.hive.common.HVKHadoopFlavorUtils;
import com.dataiku.hproxy.server.hive.executor.IHiveLoader;
import com.dataiku.hproxy.server.utils.IdGenerator;
import com.dataiku.hproxy.server.utils.SessionLocalList;
import com.dataiku.hproxy.server.utils.SessionLocalMap;
import com.dataiku.hproxy.utils.HiveEMRUtils;
import com.dataiku.hproxy.utils.Reflector;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.jdo.PersistenceManagerFactory;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.reflect.MethodUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.common.HiveInterruptCallback;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.exec.FunctionInfo;
import org.apache.hadoop.hive.ql.exec.FunctionRegistry;
import org.apache.hadoop.hive.ql.exec.Utilities;
import org.apache.hadoop.hive.ql.metadata.Hive;
import org.apache.hadoop.hive.ql.session.SessionState;
import org.apache.hadoop.util.ReflectionUtils;
import org.apache.log4j.Logger;

public class HiveLoaderImpl
implements IHiveLoader {
    private Reflector reflect;
    private String fakeWarehouseDirectory;
    private File dbDirectory = null;
    private HiveConf conf;
    private String instanceID;
    private FileSystem fs;
    private SessionLocalMap<String, String> killJobMap;
    private SessionLocalList<HiveInterruptCallback> interruptList;
    private static Logger logger = Logger.getLogger(HiveLoaderImpl.class);
    private static final String FETCH_WORK_SERDE_CLASS = "org.apache.hadoop.hive.serde2.lazy.LazySimpleSerDe";
    private SessionLocalList<Object> killJobList013;

    private HiveLoaderImpl() {
    }

    void setDBDirectory(File dbDirectory) {
        this.dbDirectory = dbDirectory;
    }

    public SessionLocalMap<String, String> getInjectedKillJobMap() {
        return this.killJobMap;
    }

    public SessionLocalList<Object> getInjectedKillJobList() {
        return this.killJobList013;
    }

    public SessionLocalList<HiveInterruptCallback> getInterruptionList() {
        return this.interruptList;
    }

    private static String initCleanWarehouse(FileSystem fs, String sessionID) throws IOException {
        Path dir = new Path(fs.getHomeDirectory(), "tmp/hivechk_" + sessionID);
        try {
            fs.delete(dir, true);
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            fs.mkdirs(dir);
        }
        catch (Exception e) {
            logger.info((Object)e.getMessage());
        }
        return dir.toUri().toString();
    }

    public static HiveLoaderImpl initTunedHiveForChecking(FileSystem fs, List<HiveConfEntry> extraConf, boolean useGlobalMetastore) throws Exception {
        if (useGlobalMetastore) {
            logger.info((Object)"Setup Hive with global metastore...");
        } else {
            logger.info((Object)"Setup Hive with fake H2 MS...");
        }
        HiveLoaderImpl hl = new HiveLoaderImpl();
        hl.instanceID = IdGenerator.generate();
        hl.fs = fs;
        hl.reflect = new Reflector(HiveLoaderImpl.class.getClassLoader());
        hl.fakeWarehouseDirectory = HiveLoaderImpl.initCleanWarehouse(fs, hl.instanceID);
        logger.info((Object)("Using warehouse dir: " + hl.fakeWarehouseDirectory));
        hl.conf = new HiveConf();
        hl.conf.set("hive.session.id", hl.instanceID);
        hl.conf.set("hive.security.authorization.enabled", "false");
        hl.conf.set("hive.metastore.warehouse.dir", hl.fakeWarehouseDirectory);
        if (!useGlobalMetastore) {
            hl.conf.set("hive.metastore.uris", "");
            for (String c : HiveEMRUtils.metastoreClientFactoryClassVariants()) {
                hl.conf.set(c, "org.apache.hadoop.hive.ql.metadata.SessionHiveMetaStoreClientFactory");
            }
            Iterator<HiveConfEntry> jdbcUrl = "jdbc:h2:mem:hivechk";
            jdbcUrl = "jdbc:derby:memory:hive_check_metastore";
            if (HVKHadoopFlavorUtils.isHive3()) {
                File subpath = new File(System.getenv("DIP_HOME"), "tmp/hive-validation-metastore");
                subpath.mkdirs();
                File dbDirectory = Files.createTempDirectory(subpath.toPath(), "derby", new FileAttribute[0]).toFile();
                hl.setDBDirectory(dbDirectory);
                jdbcUrl = "jdbc:derby:" + dbDirectory.getAbsolutePath() + "/metastore;create=true";
            }
            hl.conf.set("javax.jdo.option.ConnectionDriverName", "org.apache.derby.jdbc.EmbeddedDriver");
            hl.conf.set("javax.jdo.option.ConnectionURL", (String)((Object)jdbcUrl));
        }
        if (HVKHadoopFlavorUtils.isHive3()) {
            hl.conf.set("datanucleus.connectionPoolingType", "none");
            hl.conf.set("hive.metastore.transactional.event.listeners", "");
            hl.conf.unset("hadoop.security.credential.provider.path");
        }
        hl.conf.set("javax.jdo.option.ConnectionUserName", "");
        hl.conf.set("javax.jdo.option.ConnectionPassword", "");
        hl.conf.set("hive.support.quoted.identifiers", "column");
        hl.conf.setBoolean("hive.support.concurrency", false);
        hl.conf.set("hive.txn.manager", "org.apache.hadoop.hive.ql.lockmgr.DummyTxnManager");
        hl.conf.setBoolean("datanucleus.autoCreateSchema", true);
        hl.conf.setBoolean("datanucleus.fixedDataStore", false);
        hl.conf.setBoolean("datanucleus.schema.autoCreateAll", true);
        hl.conf.setBoolean("hive.metastore.schema.verification", false);
        hl.conf.set("hive.metastore.pre.event.listeners", "");
        hl.conf.set("hive.metastore.init.hooks", "");
        hl.conf.unset("hive.metastore.filter.hooks");
        hl.conf.set("hive.metastore.event.listeners", "");
        hl.conf.setBoolean("hive.optimize.insert.dest.volume", false);
        hl.conf.set("hive.execution.engine", "mr");
        hl.conf.set("hive.hook.proto.base-directory", "");
        hl.conf.set("metastore.metadata.transformer.class", "");
        hl.conf.set("hive.metastore.scheduled.queries.enabled", "false");
        hl.conf.set("hive.stats.autogather", "false");
        for (HiveConfEntry conf : extraConf) {
            hl.conf.set(conf.key, conf.value == null ? "" : conf.value);
        }
        ClassLoader loader = hl.conf.getClassLoader();
        String auxJars = HiveConf.getVar((Configuration)hl.conf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVEAUXJARS);
        if (StringUtils.isNotBlank((String)auxJars)) {
            String[] auxJarsPath = StringUtils.split((String)auxJars, (String)",");
            if (MethodUtils.getMatchingAccessibleMethod(Utilities.class, (String)"addToClassPath", (Class[])new Class[]{String[].class}) != null) {
                try {
                    loader = Utilities.addToClassPath((ClassLoader)loader, (String[])auxJarsPath);
                }
                catch (Exception e) {
                    logger.error((Object)("Failed to add jars to class loader: " + auxJars), (Throwable)e);
                }
            } else {
                try {
                    PrivilegedAction addAction = (PrivilegedAction)hl.reflect.newInstance("org.apache.hadoop.hive.ql.exec.AddToClassPathAction", new Object[]{loader, Arrays.asList(auxJarsPath), true});
                    loader = (ClassLoader)AccessController.doPrivileged(addAction);
                }
                catch (Exception e) {
                    logger.error((Object)("Failed to add jars to class loader: " + auxJars), (Throwable)e);
                }
            }
        }
        hl.conf.setClassLoader(loader);
        hl.injectSessionLocals();
        logger.info((Object)"Hive setup complete!");
        return hl;
    }

    public HiveConf getConf() {
        return this.conf;
    }

    public String getWarehouse() {
        return this.conf.getVar(HiveConf.ConfVars.METASTOREWAREHOUSE);
    }

    public static HiveLoaderImpl initTunedHiveForNotebook(FileSystem fs, boolean forceMR, List<HiveConfEntry> extraConf) throws Exception {
        HiveLoaderImpl hl = new HiveLoaderImpl();
        hl.reflect = new Reflector(HiveLoaderImpl.class.getClassLoader());
        hl.instanceID = IdGenerator.generate();
        logger.info((Object)"Setup Hive with default MS...");
        hl.fs = fs;
        hl.conf = new HiveConf(SessionState.class);
        hl.conf.setVar(HiveConf.ConfVars.HIVEFETCHOUTPUTSERDE, FETCH_WORK_SERDE_CLASS);
        logger.info((Object)("HiveConf is " + String.valueOf(HiveConf.class)));
        logger.info((Object)("HiveConf jar:" + hl.conf.getJar()));
        ClassLoader loader = hl.conf.getClassLoader();
        String auxJars = HiveConf.getVar((Configuration)hl.conf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVEAUXJARS);
        if (StringUtils.isNotBlank((String)auxJars)) {
            try {
                loader = Utilities.addToClassPath((ClassLoader)loader, (String[])StringUtils.split((String)auxJars, (String)","));
            }
            catch (Exception e) {
                logger.error((Object)("Failed to add jars to class loader: " + auxJars), (Throwable)e);
            }
        }
        hl.conf.setClassLoader(loader);
        if (forceMR) {
            hl.conf.set("hive.execution.engine", "mr");
        }
        for (HiveConfEntry conf : extraConf) {
            hl.conf.set(conf.key, conf.value == null ? "" : conf.value);
        }
        hl.injectSessionLocals();
        logger.info((Object)"Hive setup complete!");
        return hl;
    }

    private void injectSessionLocals() {
        this.killJobMap = new SessionLocalMap("HIVE_KILL_JOB_MAP");
        this.killJobList013 = new SessionLocalList("HIVE_KILL_JOB_LIST_013");
        boolean ok = false;
        Exception e1 = null;
        Exception e2 = null;
        Exception e3 = null;
        try {
            this.reflect.setStaticAttribute("org.apache.hadoop.hive.ql.exec.HadoopJobExecHelper", "runningJobKillURIs", this.killJobMap);
            logger.info((Object)"Injected session local job kill map (method 1)");
            ok = true;
        }
        catch (Exception e) {
            e1 = e;
        }
        try {
            this.reflect.setStaticAttribute("org.apache.hadoop.hive.ql.exec.mr.HadoopJobExecHelper", "runningJobKillURIs", this.killJobMap);
            logger.info((Object)"Injected session local job kill map (method 2)");
            ok = true;
        }
        catch (Exception e) {
            e2 = e;
        }
        try {
            this.reflect.setStaticAttribute("org.apache.hadoop.hive.ql.exec.mr.HadoopJobExecHelper", "runningJobs", this.killJobList013);
            logger.info((Object)"Injected session local job kill list (method 3, Hive 0.13+)");
            ok = true;
        }
        catch (Exception e) {
            e3 = e;
        }
        if (!ok) {
            logger.error((Object)"Failed to inject session local job kill map/list");
            if (e1 != null) {
                logger.error((Object)e1);
            }
            if (e2 != null) {
                logger.error((Object)e2);
            }
            if (e3 != null) {
                logger.error((Object)e3);
            }
        }
        this.interruptList = new SessionLocalList("HIVE_INTERRUPTION_LIST");
        try {
            this.reflect.setStaticAttribute("org.apache.hadoop.hive.common.HiveInterruptUtils", "interruptCallbacks", this.interruptList);
        }
        catch (Exception e) {
            logger.error((Object)"Failed to inject session local interruption list", (Throwable)e);
        }
        try {
            Map original_mFunctions = (Map)this.reflect.getStaticAttribute("org.apache.hadoop.hive.ql.exec.FunctionRegistry", "mFunctions");
            Map original_windowFunctions = (Map)this.reflect.getStaticAttribute("org.apache.hadoop.hive.ql.exec.FunctionRegistry", "windowFunctions");
            SessionLocalMap sessionAwareFunctionRegistry_mFunctions = new SessionLocalMap("FUNCTIONREGISTRY_mFunctions", original_mFunctions);
            SessionLocalMap sessionAwareFunctionRegistry_windowFunctions = new SessionLocalMap("FUNCTIONREGISTRY_windowFunctions", original_windowFunctions);
            this.reflect.setStaticAttribute("org.apache.hadoop.hive.ql.exec.FunctionRegistry", "mFunctions", (Object)sessionAwareFunctionRegistry_mFunctions);
            this.reflect.setStaticAttribute("org.apache.hadoop.hive.ql.exec.FunctionRegistry", "windowFunctions", (Object)sessionAwareFunctionRegistry_windowFunctions);
        }
        catch (Exception e) {
            logger.error((Object)"Failed to install session local function registry", (Throwable)e);
        }
    }

    public void close(boolean doNotCleanHDFS) {
        if (!doNotCleanHDFS) {
            try {
                Hive.closeCurrent();
            }
            catch (Exception e) {
                logger.error((Object)"Error when trying to close Hive", (Throwable)e);
            }
            if (this.fakeWarehouseDirectory != null) {
                try {
                    logger.info((Object)"Remove temporary HDFS directory");
                    Path dir = new Path(this.fakeWarehouseDirectory);
                    this.fs.delete(dir, true);
                }
                catch (Exception e) {
                    logger.error((Object)"Error when trying to cleanup HDFS", (Throwable)e);
                }
            }
        }
        try {
            logger.info((Object)"Fix Hadoop memory leaks");
            Method clearCache = ReflectionUtils.class.getDeclaredMethod("clearCache", new Class[0]);
            clearCache.setAccessible(true);
            clearCache.invoke(null, new Object[0]);
        }
        catch (Exception e) {
            logger.error((Object)"Error when trying to clear the ReflectionUtils", (Throwable)e);
        }
        try {
            logger.info((Object)"Fix Hive memory leaks");
            Field mFunctionsField = FunctionRegistry.class.getDeclaredField("mFunctions");
            mFunctionsField.setAccessible(true);
            Map mFunctions = (Map)mFunctionsField.get(null);
            Iterator it = mFunctions.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry fun = it.next();
                if (((FunctionInfo)fun.getValue()).isNative() || ((FunctionInfo)fun.getValue()).getFunctionClass().getName().startsWith("org.apache.hadoop.hive.ql.udf.") || ((FunctionInfo)fun.getValue()).getFunctionClass().getName().startsWith("org.apache.hive.builtins.")) continue;
                logger.info((Object)("Unloaded UDF :" + ((FunctionInfo)fun.getValue()).getDisplayName() + " [" + ((FunctionInfo)fun.getValue()).getFunctionClass().getName() + "]"));
                it.remove();
            }
        }
        catch (Exception e) {
            logger.error((Object)"Error when trying to unregister UDFs", (Throwable)e);
        }
        try {
            logger.info((Object)"Reinitialize the LazyObjectInspectorFactory");
            this.reflect.setStaticAttribute("org.apache.hadoop.hive.serde2.lazy.objectinspector.LazyObjectInspectorFactory", "cachedLazySimpleStructObjectInspector", new ConcurrentHashMap());
            this.reflect.setStaticAttribute("org.apache.hadoop.hive.serde2.lazy.objectinspector.LazyObjectInspectorFactory", "cachedLazySimpleListObjectInspector", new ConcurrentHashMap());
            this.reflect.setStaticAttribute("org.apache.hadoop.hive.serde2.lazy.objectinspector.LazyObjectInspectorFactory", "cachedLazySimpleMapObjectInspector", new ConcurrentHashMap());
            this.reflect.setStaticAttribute("org.apache.hadoop.hive.serde2.lazy.objectinspector.LazyObjectInspectorFactory", "cachedLazyUnionObjectInspector", new ConcurrentHashMap());
        }
        catch (Exception e) {
            logger.error((Object)"Error when trying to clear the LazyObjectInspectorFactory", (Throwable)e);
        }
        logger.info((Object)("Deleting DB directory " + String.valueOf(this.dbDirectory)));
        if (this.dbDirectory != null) {
            try {
                FileUtils.forceDelete((File)this.dbDirectory);
            }
            catch (Exception e) {
                logger.error((Object)"Error while deleting metastore directory", (Throwable)e);
            }
        }
        try {
            logger.info((Object)"Close the PersistenceManagerFactory in ObjectStore");
            PersistenceManagerFactory pmf = (PersistenceManagerFactory)this.reflect.getStaticAttribute("org.apache.hadoop.hive.metastore.ObjectStore", "pmf");
            if (pmf != null) {
                pmf.close();
                this.reflect.setStaticAttribute("org.apache.hadoop.hive.metastore.ObjectStore", "pmf", null);
            }
        }
        catch (Exception e) {
            logger.error((Object)"Error when trying to close the PersistenceManagerFactory", (Throwable)e);
        }
        logger.info((Object)"Hive closed!");
    }

    public ClassLoader getClassLoader() {
        return this.conf.getClassLoader();
    }
}

