/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.fs;

public class Globbing {
    static final char STAR = '*';
    static final char QUESTION = '?';
    static final char OPEN_BRACKET = '[';
    static final char DASH = '-';
    static final char BACK_SLASH = '\\';

    private Globbing() {
    }

    public static boolean match(String pattern, String filename) {
        return Globbing.match(pattern, 0, filename, 0, false);
    }

    public static boolean matchPath(String pathPattern, String pathName, String fileSeparator) {
        String[] pattern = pathPattern.split(fileSeparator);
        String[] path = pathName.split(fileSeparator);
        if (path.length != pattern.length) {
            return false;
        }
        for (int i = 0; i < pattern.length; ++i) {
            if (Globbing.match(pattern[i], path[i])) continue;
            return false;
        }
        return true;
    }

    public static boolean hasGlobbing(String f) {
        return (f = f.replaceAll("\\.", "")).indexOf(42) != -1 || f.indexOf(63) != -1 || f.indexOf(91) != -1;
    }

    private static boolean matchRawBracket(String pattern, char letter) {
        for (int i = 0; i < pattern.length(); ++i) {
            if (i + 2 < pattern.length() && pattern.charAt(i + 1) == '-') {
                if (pattern.charAt(i) <= letter && letter <= pattern.charAt(i + 2)) {
                    return true;
                }
                i += 2;
                continue;
            }
            if (pattern.charAt(i) != letter) continue;
            return true;
        }
        return false;
    }

    private static boolean matchBracket(String pattern, char letter) {
        if (pattern.charAt(0) == '!' || pattern.charAt(0) == '^') {
            return !Globbing.matchRawBracket(pattern.substring(1), letter);
        }
        return Globbing.matchRawBracket(pattern, letter);
    }

    private static boolean match(String pattern, int pidx, String filename, int fidx, boolean escape) {
        if (!escape) {
            if (pattern.length() == pidx && filename.length() == fidx) {
                return true;
            }
            if (pattern.length() == pidx || filename.length() == fidx) {
                if (pidx < pattern.length() && pattern.charAt(pidx) == '*') {
                    return Globbing.match(pattern, pidx + 1, filename, fidx, false);
                }
                return false;
            }
            if (pattern.charAt(pidx) == '?') {
                return Globbing.match(pattern, pidx + 1, filename, fidx + 1, false);
            }
            if (pattern.charAt(pidx) == '[') {
                int idx = pattern.indexOf("]", 2);
                if (idx != -1) {
                    return Globbing.matchBracket(pattern.substring(pidx + 1, idx), filename.charAt(fidx)) && Globbing.match(pattern, idx + 1, filename, fidx + 1, false);
                }
            } else if (pattern.charAt(pidx) == '*') {
                return Globbing.match(pattern, pidx, filename, fidx + 1, false) || Globbing.match(pattern, pidx + 1, filename, fidx, false) || Globbing.match(pattern, pidx + 1, filename, fidx + 1, false);
            }
        }
        if (pattern.charAt(pidx) == '\\') {
            return Globbing.match(pattern, pidx + 1, filename, fidx, true);
        }
        return pattern.charAt(pidx) == filename.charAt(fidx) && Globbing.match(pattern, pidx + 1, filename, fidx + 1, false);
    }
}

