/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.internal.connection;

import com.mongodb.internal.connection.MessageSequences;
import java.util.List;
import org.bson.BsonBinaryWriter;
import org.bson.BsonElement;
import org.bson.FieldNameValidator;

public abstract class DualMessageSequences
extends MessageSequences {
    private final String firstSequenceId;
    private final FieldNameValidator firstFieldNameValidator;
    private final String secondSequenceId;
    private final FieldNameValidator secondFieldNameValidator;

    protected DualMessageSequences(String firstSequenceId, FieldNameValidator firstFieldNameValidator, String secondSequenceId, FieldNameValidator secondFieldNameValidator) {
        this.firstSequenceId = firstSequenceId;
        this.firstFieldNameValidator = firstFieldNameValidator;
        this.secondSequenceId = secondSequenceId;
        this.secondFieldNameValidator = secondFieldNameValidator;
    }

    FieldNameValidator getFirstFieldNameValidator() {
        return this.firstFieldNameValidator;
    }

    FieldNameValidator getSecondFieldNameValidator() {
        return this.secondFieldNameValidator;
    }

    String getFirstSequenceId() {
        return this.firstSequenceId;
    }

    String getSecondSequenceId() {
        return this.secondSequenceId;
    }

    protected abstract EncodeDocumentsResult encodeDocuments(WritersProviderAndLimitsChecker var1);

    public static final class EncodeDocumentsResult {
        private final boolean serverResponseRequired;
        private final List<BsonElement> extraElements;

        public EncodeDocumentsResult(boolean serverResponseRequired, List<BsonElement> extraElements) {
            this.serverResponseRequired = serverResponseRequired;
            this.extraElements = extraElements;
        }

        boolean isServerResponseRequired() {
            return this.serverResponseRequired;
        }

        List<BsonElement> getExtraElements() {
            return this.extraElements;
        }
    }

    public static interface WritersProviderAndLimitsChecker {
        public WriteResult tryWrite(WriteAction var1);

        public static enum WriteResult {
            FAIL_LIMIT_EXCEEDED,
            OK_LIMIT_REACHED,
            OK_LIMIT_NOT_REACHED;

        }

        public static interface WriteAction {
            public int doAndGetBatchCount(BsonBinaryWriter var1, BsonBinaryWriter var2);
        }
    }
}

