/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibdatabricks.com.databricks.sdk.service.files;

import com.dataiku.dss.shadelibdatabricks.com.databricks.sdk.core.ApiClient;
import com.dataiku.dss.shadelibdatabricks.com.databricks.sdk.service.files.CreateDirectoryRequest;
import com.dataiku.dss.shadelibdatabricks.com.databricks.sdk.service.files.DeleteDirectoryRequest;
import com.dataiku.dss.shadelibdatabricks.com.databricks.sdk.service.files.DeleteFileRequest;
import com.dataiku.dss.shadelibdatabricks.com.databricks.sdk.service.files.DirectoryEntry;
import com.dataiku.dss.shadelibdatabricks.com.databricks.sdk.service.files.DownloadRequest;
import com.dataiku.dss.shadelibdatabricks.com.databricks.sdk.service.files.DownloadResponse;
import com.dataiku.dss.shadelibdatabricks.com.databricks.sdk.service.files.FilesImpl;
import com.dataiku.dss.shadelibdatabricks.com.databricks.sdk.service.files.FilesService;
import com.dataiku.dss.shadelibdatabricks.com.databricks.sdk.service.files.GetDirectoryMetadataRequest;
import com.dataiku.dss.shadelibdatabricks.com.databricks.sdk.service.files.GetMetadataRequest;
import com.dataiku.dss.shadelibdatabricks.com.databricks.sdk.service.files.GetMetadataResponse;
import com.dataiku.dss.shadelibdatabricks.com.databricks.sdk.service.files.ListDirectoryContentsRequest;
import com.dataiku.dss.shadelibdatabricks.com.databricks.sdk.service.files.ListDirectoryResponse;
import com.dataiku.dss.shadelibdatabricks.com.databricks.sdk.service.files.UploadRequest;
import com.dataiku.dss.shadelibdatabricks.com.databricks.sdk.support.Generated;
import com.dataiku.dss.shadelibdatabricks.com.databricks.sdk.support.Paginator;
import java.io.InputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Generated
public class FilesAPI {
    private static final Logger LOG = LoggerFactory.getLogger(FilesAPI.class);
    private final FilesService impl;

    public FilesAPI(ApiClient apiClient) {
        this.impl = new FilesImpl(apiClient);
    }

    public FilesAPI(FilesService mock) {
        this.impl = mock;
    }

    public void createDirectory(String directoryPath) {
        this.createDirectory(new CreateDirectoryRequest().setDirectoryPath(directoryPath));
    }

    public void createDirectory(CreateDirectoryRequest request) {
        this.impl.createDirectory(request);
    }

    public void delete(String filePath) {
        this.delete(new DeleteFileRequest().setFilePath(filePath));
    }

    public void delete(DeleteFileRequest request) {
        this.impl.delete(request);
    }

    public void deleteDirectory(String directoryPath) {
        this.deleteDirectory(new DeleteDirectoryRequest().setDirectoryPath(directoryPath));
    }

    public void deleteDirectory(DeleteDirectoryRequest request) {
        this.impl.deleteDirectory(request);
    }

    public DownloadResponse download(String filePath) {
        return this.download(new DownloadRequest().setFilePath(filePath));
    }

    public DownloadResponse download(DownloadRequest request) {
        return this.impl.download(request);
    }

    public void getDirectoryMetadata(String directoryPath) {
        this.getDirectoryMetadata(new GetDirectoryMetadataRequest().setDirectoryPath(directoryPath));
    }

    public void getDirectoryMetadata(GetDirectoryMetadataRequest request) {
        this.impl.getDirectoryMetadata(request);
    }

    public GetMetadataResponse getMetadata(String filePath) {
        return this.getMetadata(new GetMetadataRequest().setFilePath(filePath));
    }

    public GetMetadataResponse getMetadata(GetMetadataRequest request) {
        return this.impl.getMetadata(request);
    }

    public Iterable<DirectoryEntry> listDirectoryContents(String directoryPath) {
        return this.listDirectoryContents(new ListDirectoryContentsRequest().setDirectoryPath(directoryPath));
    }

    public Iterable<DirectoryEntry> listDirectoryContents(ListDirectoryContentsRequest request) {
        return new Paginator(request, this.impl::listDirectoryContents, ListDirectoryResponse::getContents, response -> {
            String token = response.getNextPageToken();
            if (token == null || token.isEmpty()) {
                return null;
            }
            return request.setPageToken(token);
        });
    }

    public void upload(String filePath, InputStream contents) {
        this.upload(new UploadRequest().setFilePath(filePath).setContents(contents));
    }

    public void upload(UploadRequest request) {
        this.impl.upload(request);
    }

    public FilesService impl() {
        return this.impl;
    }
}

