/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelib.org.apache.lucene.internal.vectorization;

import com.dataiku.dss.shadelib.org.apache.lucene.internal.vectorization.PanamaVectorConstants;
import com.dataiku.dss.shadelib.org.apache.lucene.internal.vectorization.PostingDecodingUtil;
import com.dataiku.dss.shadelib.org.apache.lucene.store.IndexInput;
import java.io.IOException;
import java.lang.foreign.MemorySegment;
import java.nio.ByteOrder;
import jdk.incubator.vector.LongVector;
import jdk.incubator.vector.VectorOperators;
import jdk.incubator.vector.VectorSpecies;

final class MemorySegmentPostingDecodingUtil
extends PostingDecodingUtil {
    private static final VectorSpecies<Long> LONG_SPECIES = PanamaVectorConstants.PRERERRED_LONG_SPECIES;
    private final MemorySegment memorySegment;

    MemorySegmentPostingDecodingUtil(IndexInput in, MemorySegment memorySegment) {
        super(in);
        this.memorySegment = memorySegment;
    }

    private static void shift(LongVector vector, int bShift, int dec, int maxIter, long bMask, long[] b, int count, int i) {
        for (int j = 0; j <= maxIter; ++j) {
            vector.lanewise(VectorOperators.LSHR, (long)(bShift - j * dec)).lanewise((VectorOperators.Binary)VectorOperators.AND, bMask).intoArray(b, count * j + i);
        }
    }

    @Override
    public void splitLongs(int count, long[] b, int bShift, int dec, long bMask, long[] c, int cIndex, long cMask) throws IOException {
        LongVector vector;
        if (count < LONG_SPECIES.length()) {
            super.splitLongs(count, b, bShift, dec, bMask, c, cIndex, cMask);
            return;
        }
        int maxIter = (bShift - 1) / dec;
        long offset = this.in.getFilePointer();
        long endOffset = offset + (long)(count * 8);
        int loopBound = LONG_SPECIES.loopBound(count - 1);
        int i = 0;
        while (i < loopBound) {
            vector = LongVector.fromMemorySegment(LONG_SPECIES, (MemorySegment)this.memorySegment, (long)offset, (ByteOrder)ByteOrder.LITTLE_ENDIAN);
            MemorySegmentPostingDecodingUtil.shift(vector, bShift, dec, maxIter, bMask, b, count, i);
            vector.lanewise((VectorOperators.Binary)VectorOperators.AND, cMask).intoArray(c, cIndex + i);
            i += LONG_SPECIES.length();
            offset += (long)(LONG_SPECIES.length() * 8);
        }
        i = count - LONG_SPECIES.length();
        offset = endOffset - (long)(LONG_SPECIES.length() * 8);
        vector = LongVector.fromMemorySegment(LONG_SPECIES, (MemorySegment)this.memorySegment, (long)offset, (ByteOrder)ByteOrder.LITTLE_ENDIAN);
        MemorySegmentPostingDecodingUtil.shift(vector, bShift, dec, maxIter, bMask, b, count, i);
        vector.lanewise((VectorOperators.Binary)VectorOperators.AND, cMask).intoArray(c, cIndex + i);
        this.in.seek(endOffset);
    }
}

