/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelib.org.apache.lucene.analysis.core;

import com.dataiku.dss.shadelib.org.apache.lucene.analysis.TokenFilterFactory;
import com.dataiku.dss.shadelib.org.apache.lucene.analysis.TokenStream;
import com.dataiku.dss.shadelib.org.apache.lucene.analysis.core.TypeTokenFilter;
import com.dataiku.dss.shadelib.org.apache.lucene.util.ResourceLoader;
import com.dataiku.dss.shadelib.org.apache.lucene.util.ResourceLoaderAware;
import java.io.IOException;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class TypeTokenFilterFactory
extends TokenFilterFactory
implements ResourceLoaderAware {
    public static final String NAME = "type";
    private final boolean useWhitelist;
    private final String stopTypesFiles;
    private Set<String> stopTypes;

    public TypeTokenFilterFactory(Map<String, String> args2) {
        super(args2);
        this.stopTypesFiles = this.require(args2, "types");
        this.useWhitelist = this.getBoolean(args2, "useWhitelist", false);
        if (!args2.isEmpty()) {
            throw new IllegalArgumentException("Unknown parameters: " + args2);
        }
    }

    public TypeTokenFilterFactory() {
        throw TypeTokenFilterFactory.defaultCtorException();
    }

    @Override
    public void inform(ResourceLoader loader) throws IOException {
        List<String> files = this.splitFileNames(this.stopTypesFiles);
        if (files.size() > 0) {
            this.stopTypes = new HashSet<String>();
            for (String file : files) {
                List<String> typesLines = this.getLines(loader, file.trim());
                this.stopTypes.addAll(typesLines);
            }
        }
    }

    public Set<String> getStopTypes() {
        return this.stopTypes;
    }

    @Override
    public TokenStream create(TokenStream input) {
        TypeTokenFilter filter = new TypeTokenFilter(input, this.stopTypes, this.useWhitelist);
        return filter;
    }
}

