/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelib.org.apache.lucene.analysis.tr;

import com.dataiku.dss.shadelib.org.apache.lucene.analysis.Analyzer;
import com.dataiku.dss.shadelib.org.apache.lucene.analysis.CharArraySet;
import com.dataiku.dss.shadelib.org.apache.lucene.analysis.StopFilter;
import com.dataiku.dss.shadelib.org.apache.lucene.analysis.StopwordAnalyzerBase;
import com.dataiku.dss.shadelib.org.apache.lucene.analysis.TokenFilter;
import com.dataiku.dss.shadelib.org.apache.lucene.analysis.TokenStream;
import com.dataiku.dss.shadelib.org.apache.lucene.analysis.WordlistLoader;
import com.dataiku.dss.shadelib.org.apache.lucene.analysis.miscellaneous.SetKeywordMarkerFilter;
import com.dataiku.dss.shadelib.org.apache.lucene.analysis.snowball.SnowballFilter;
import com.dataiku.dss.shadelib.org.apache.lucene.analysis.standard.StandardTokenizer;
import com.dataiku.dss.shadelib.org.apache.lucene.analysis.tr.ApostropheFilter;
import com.dataiku.dss.shadelib.org.apache.lucene.analysis.tr.TurkishLowerCaseFilter;
import com.dataiku.dss.shadelib.org.apache.lucene.util.IOUtils;
import com.dataiku.dss.shadelib.org.tartarus.snowball.ext.TurkishStemmer;
import java.io.IOException;
import java.io.UncheckedIOException;

public final class TurkishAnalyzer
extends StopwordAnalyzerBase {
    private final CharArraySet stemExclusionSet;
    public static final String DEFAULT_STOPWORD_FILE = "stopwords.txt";
    private static final String STOPWORDS_COMMENT = "#";

    public static CharArraySet getDefaultStopSet() {
        return DefaultSetHolder.DEFAULT_STOP_SET;
    }

    public TurkishAnalyzer() {
        this(DefaultSetHolder.DEFAULT_STOP_SET);
    }

    public TurkishAnalyzer(CharArraySet stopwords) {
        this(stopwords, CharArraySet.EMPTY_SET);
    }

    public TurkishAnalyzer(CharArraySet stopwords, CharArraySet stemExclusionSet) {
        super(stopwords);
        this.stemExclusionSet = CharArraySet.unmodifiableSet(CharArraySet.copy(stemExclusionSet));
    }

    @Override
    protected Analyzer.TokenStreamComponents createComponents(String fieldName) {
        StandardTokenizer source = new StandardTokenizer();
        TokenFilter result = new ApostropheFilter(source);
        result = new TurkishLowerCaseFilter(result);
        result = new StopFilter(result, this.stopwords);
        if (!this.stemExclusionSet.isEmpty()) {
            result = new SetKeywordMarkerFilter(result, this.stemExclusionSet);
        }
        result = new SnowballFilter((TokenStream)result, new TurkishStemmer());
        return new Analyzer.TokenStreamComponents(source, (TokenStream)result);
    }

    @Override
    protected TokenStream normalize(String fieldName, TokenStream in) {
        return new TurkishLowerCaseFilter(in);
    }

    private static class DefaultSetHolder {
        static final CharArraySet DEFAULT_STOP_SET;

        private DefaultSetHolder() {
        }

        static {
            try {
                DEFAULT_STOP_SET = WordlistLoader.getWordSet(IOUtils.requireResourceNonNull(TurkishAnalyzer.class.getResourceAsStream(TurkishAnalyzer.DEFAULT_STOPWORD_FILE), TurkishAnalyzer.DEFAULT_STOPWORD_FILE), TurkishAnalyzer.STOPWORDS_COMMENT);
            }
            catch (IOException ex) {
                throw new UncheckedIOException("Unable to load default stopword set", ex);
            }
        }
    }
}

