/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelib.org.apache.lucene.facet.taxonomy;

import com.dataiku.dss.shadelib.org.apache.lucene.facet.taxonomy.TaxonomyReader;
import com.dataiku.dss.shadelib.org.apache.lucene.facet.taxonomy.directory.DirectoryTaxonomyReader;
import com.dataiku.dss.shadelib.org.apache.lucene.facet.taxonomy.directory.DirectoryTaxonomyWriter;
import com.dataiku.dss.shadelib.org.apache.lucene.index.DirectoryReader;
import com.dataiku.dss.shadelib.org.apache.lucene.index.IndexReader;
import com.dataiku.dss.shadelib.org.apache.lucene.index.IndexWriter;
import com.dataiku.dss.shadelib.org.apache.lucene.search.IndexSearcher;
import com.dataiku.dss.shadelib.org.apache.lucene.search.ReferenceManager;
import com.dataiku.dss.shadelib.org.apache.lucene.search.SearcherFactory;
import com.dataiku.dss.shadelib.org.apache.lucene.search.SearcherManager;
import com.dataiku.dss.shadelib.org.apache.lucene.store.Directory;
import com.dataiku.dss.shadelib.org.apache.lucene.util.IOUtils;
import java.io.IOException;

public class SearcherTaxonomyManager
extends ReferenceManager<SearcherAndTaxonomy> {
    private final SearcherFactory searcherFactory;
    private final long taxoEpoch;
    private final DirectoryTaxonomyWriter taxoWriter;

    public SearcherTaxonomyManager(IndexWriter writer, SearcherFactory searcherFactory, DirectoryTaxonomyWriter taxoWriter) throws IOException {
        this(writer, true, searcherFactory, taxoWriter);
    }

    public SearcherTaxonomyManager(IndexWriter writer, boolean applyAllDeletes, SearcherFactory searcherFactory, DirectoryTaxonomyWriter taxoWriter) throws IOException {
        if (searcherFactory == null) {
            searcherFactory = new SearcherFactory();
        }
        this.searcherFactory = searcherFactory;
        this.taxoWriter = taxoWriter;
        DirectoryTaxonomyReader taxoReader = new DirectoryTaxonomyReader(taxoWriter);
        this.current = new SearcherAndTaxonomy(SearcherManager.getSearcher(searcherFactory, DirectoryReader.open(writer, applyAllDeletes, false), null), taxoReader);
        this.taxoEpoch = taxoWriter.getTaxonomyEpoch();
    }

    public SearcherTaxonomyManager(Directory indexDir, Directory taxoDir, SearcherFactory searcherFactory) throws IOException {
        if (searcherFactory == null) {
            searcherFactory = new SearcherFactory();
        }
        this.searcherFactory = searcherFactory;
        DirectoryTaxonomyReader taxoReader = new DirectoryTaxonomyReader(taxoDir);
        this.current = new SearcherAndTaxonomy(SearcherManager.getSearcher(searcherFactory, DirectoryReader.open(indexDir), null), taxoReader);
        this.taxoWriter = null;
        this.taxoEpoch = -1L;
    }

    public SearcherTaxonomyManager(IndexReader reader, DirectoryTaxonomyReader taxoReader, SearcherFactory searcherFactory) throws IOException {
        if (searcherFactory == null) {
            searcherFactory = new SearcherFactory();
        }
        this.searcherFactory = searcherFactory;
        this.current = new SearcherAndTaxonomy(SearcherManager.getSearcher(searcherFactory, reader, null), taxoReader);
        this.taxoWriter = null;
        this.taxoEpoch = -1L;
    }

    @Override
    protected void decRef(SearcherAndTaxonomy ref) throws IOException {
        ref.searcher.getIndexReader().decRef();
        ref.taxonomyReader.decRef();
    }

    @Override
    protected boolean tryIncRef(SearcherAndTaxonomy ref) throws IOException {
        if (ref.searcher.getIndexReader().tryIncRef()) {
            if (ref.taxonomyReader.tryIncRef()) {
                return true;
            }
            ref.searcher.getIndexReader().decRef();
        }
        return false;
    }

    @Override
    protected SearcherAndTaxonomy refreshIfNeeded(SearcherAndTaxonomy ref) throws IOException {
        DirectoryTaxonomyReader tr;
        IndexReader r = ref.searcher.getIndexReader();
        DirectoryReader newReader = DirectoryReader.openIfChanged((DirectoryReader)r);
        if (newReader == null) {
            return null;
        }
        try {
            tr = TaxonomyReader.openIfChanged(ref.taxonomyReader);
        }
        catch (Throwable t1) {
            try {
                IOUtils.close(newReader);
            }
            catch (Throwable t2) {
                t2.addSuppressed(t2);
            }
            throw t1;
        }
        if (tr == null) {
            ref.taxonomyReader.incRef();
            tr = ref.taxonomyReader;
        } else if (this.taxoWriter != null && this.taxoWriter.getTaxonomyEpoch() != this.taxoEpoch) {
            IOUtils.close(newReader, tr);
            throw new IllegalStateException("DirectoryTaxonomyWriter.replaceTaxonomy was called, which is not allowed when using SearcherTaxonomyManager");
        }
        return new SearcherAndTaxonomy(SearcherManager.getSearcher(this.searcherFactory, newReader, r), tr);
    }

    @Override
    protected int getRefCount(SearcherAndTaxonomy reference) {
        return reference.searcher.getIndexReader().getRefCount();
    }

    public static class SearcherAndTaxonomy {
        public final IndexSearcher searcher;
        public final DirectoryTaxonomyReader taxonomyReader;

        public SearcherAndTaxonomy(IndexSearcher searcher, DirectoryTaxonomyReader taxonomyReader) {
            this.searcher = searcher;
            this.taxonomyReader = taxonomyReader;
        }
    }
}

