/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelib.org.apache.lucene.queries.intervals;

import com.dataiku.dss.shadelib.org.apache.lucene.queries.intervals.IntervalIterator;
import com.dataiku.dss.shadelib.org.apache.lucene.search.ConjunctionUtils;
import com.dataiku.dss.shadelib.org.apache.lucene.search.DocIdSetIterator;
import java.io.IOException;
import java.util.List;

abstract class ConjunctionIntervalIterator
extends IntervalIterator {
    final DocIdSetIterator approximation;
    final List<IntervalIterator> subIterators;
    final float cost;

    ConjunctionIntervalIterator(List<IntervalIterator> subIterators) {
        this.approximation = ConjunctionUtils.intersectIterators(subIterators);
        this.subIterators = subIterators;
        float costsum = 0.0f;
        for (IntervalIterator it : subIterators) {
            costsum += it.matchCost();
        }
        this.cost = costsum;
    }

    @Override
    public int docID() {
        return this.approximation.docID();
    }

    @Override
    public int nextDoc() throws IOException {
        int doc = this.approximation.nextDoc();
        if (doc != Integer.MAX_VALUE) {
            this.reset();
        }
        return doc;
    }

    @Override
    public int advance(int target) throws IOException {
        int doc = this.approximation.advance(target);
        if (doc != Integer.MAX_VALUE) {
            this.reset();
        }
        return doc;
    }

    protected abstract void reset() throws IOException;

    @Override
    public long cost() {
        return this.approximation.cost();
    }

    @Override
    public final float matchCost() {
        return this.cost;
    }
}

