/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelib.org.apache.lucene.queries.spans;

import com.dataiku.dss.shadelib.org.apache.lucene.index.IndexReaderContext;
import com.dataiku.dss.shadelib.org.apache.lucene.index.LeafReaderContext;
import com.dataiku.dss.shadelib.org.apache.lucene.index.PostingsEnum;
import com.dataiku.dss.shadelib.org.apache.lucene.index.ReaderUtil;
import com.dataiku.dss.shadelib.org.apache.lucene.index.Term;
import com.dataiku.dss.shadelib.org.apache.lucene.index.TermState;
import com.dataiku.dss.shadelib.org.apache.lucene.index.TermStates;
import com.dataiku.dss.shadelib.org.apache.lucene.index.Terms;
import com.dataiku.dss.shadelib.org.apache.lucene.index.TermsEnum;
import com.dataiku.dss.shadelib.org.apache.lucene.queries.spans.SpanQuery;
import com.dataiku.dss.shadelib.org.apache.lucene.queries.spans.SpanWeight;
import com.dataiku.dss.shadelib.org.apache.lucene.queries.spans.Spans;
import com.dataiku.dss.shadelib.org.apache.lucene.queries.spans.TermSpans;
import com.dataiku.dss.shadelib.org.apache.lucene.search.IndexSearcher;
import com.dataiku.dss.shadelib.org.apache.lucene.search.QueryVisitor;
import com.dataiku.dss.shadelib.org.apache.lucene.search.ScoreMode;
import java.io.IOException;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;

public class SpanTermQuery
extends SpanQuery {
    protected final Term term;
    protected final TermStates termStates;
    private static final float PHRASE_TO_SPAN_TERM_POSITIONS_COST = 4.0f;
    private static final int TERM_POSNS_SEEK_OPS_PER_DOC = 128;
    private static final int TERM_OPS_PER_POS = 7;

    public SpanTermQuery(Term term) {
        this.term = Objects.requireNonNull(term);
        this.termStates = null;
    }

    public SpanTermQuery(Term term, TermStates termStates) {
        this.term = Objects.requireNonNull(term);
        this.termStates = termStates;
    }

    public Term getTerm() {
        return this.term;
    }

    public TermStates getTermStates() {
        return this.termStates;
    }

    @Override
    public String getField() {
        return this.term.field();
    }

    @Override
    public SpanWeight createWeight(IndexSearcher searcher, ScoreMode scoreMode, float boost) throws IOException {
        IndexReaderContext topContext = searcher.getTopReaderContext();
        TermStates context = this.termStates == null || !this.termStates.wasBuiltFor(topContext) ? TermStates.build(searcher, this.term, scoreMode.needsScores()) : this.termStates;
        return new SpanTermWeight(context, searcher, scoreMode.needsScores() ? Collections.singletonMap(this.term, context) : null, boost);
    }

    @Override
    public void visit(QueryVisitor visitor) {
        if (visitor.acceptField(this.term.field())) {
            visitor.consumeTerms(this, this.term);
        }
    }

    static float termPositionsCost(TermsEnum termsEnum) throws IOException {
        int docFreq = termsEnum.docFreq();
        assert (docFreq > 0);
        long totalTermFreq = termsEnum.totalTermFreq();
        assert (totalTermFreq > 0L);
        float expOccurrencesInMatchingDoc = (float)totalTermFreq / (float)docFreq;
        return 128.0f + expOccurrencesInMatchingDoc * 7.0f;
    }

    @Override
    public String toString(String field) {
        StringBuilder buffer = new StringBuilder();
        if (this.term.field().equals(field)) {
            buffer.append(this.term.text());
        } else {
            buffer.append(this.term.toString());
        }
        return buffer.toString();
    }

    @Override
    public int hashCode() {
        return this.classHash() ^ this.term.hashCode();
    }

    @Override
    public boolean equals(Object other) {
        return this.sameClassAs(other) && this.term.equals(((SpanTermQuery)other).term);
    }

    public class SpanTermWeight
    extends SpanWeight {
        final TermStates termStates;

        public SpanTermWeight(TermStates termStates, IndexSearcher searcher, Map<Term, TermStates> terms, float boost) throws IOException {
            super(SpanTermQuery.this, searcher, terms, boost);
            this.termStates = termStates;
            assert (termStates != null) : "TermStates must not be null";
        }

        @Override
        public boolean isCacheable(LeafReaderContext ctx) {
            return true;
        }

        @Override
        public void extractTermStates(Map<Term, TermStates> contexts) {
            contexts.put(SpanTermQuery.this.term, this.termStates);
        }

        @Override
        public Spans getSpans(LeafReaderContext context, SpanWeight.Postings requiredPostings) throws IOException {
            assert (this.termStates.wasBuiltFor(ReaderUtil.getTopLevelContext(context))) : "The top-reader used to create Weight is not the same as the current reader's top-reader (" + ReaderUtil.getTopLevelContext(context);
            TermState state = this.termStates.get(context);
            if (state == null) {
                assert (context.reader().docFreq(SpanTermQuery.this.term) == 0) : "no termstate found but term exists in reader term=" + SpanTermQuery.this.term;
                return null;
            }
            Terms terms = context.reader().terms(SpanTermQuery.this.term.field());
            if (terms == null) {
                return null;
            }
            if (!terms.hasPositions()) {
                throw new IllegalStateException("field \"" + SpanTermQuery.this.term.field() + "\" was indexed without position data; cannot run SpanTermQuery (term=" + SpanTermQuery.this.term.text() + ")");
            }
            TermsEnum termsEnum = terms.iterator();
            termsEnum.seekExact(SpanTermQuery.this.term.bytes(), state);
            PostingsEnum postings = termsEnum.postings(null, requiredPostings.getRequiredPostings());
            float positionsCost = SpanTermQuery.termPositionsCost(termsEnum) * 4.0f;
            return new TermSpans(this.getSimScorer(context), postings, SpanTermQuery.this.term, positionsCost);
        }
    }
}

