/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelib.org.apache.lucene.queryparser.flexible.standard.processors;

import com.dataiku.dss.shadelib.org.apache.lucene.analysis.Analyzer;
import com.dataiku.dss.shadelib.org.apache.lucene.queryparser.flexible.core.QueryNodeException;
import com.dataiku.dss.shadelib.org.apache.lucene.queryparser.flexible.core.config.QueryConfigHandler;
import com.dataiku.dss.shadelib.org.apache.lucene.queryparser.flexible.core.nodes.FuzzyQueryNode;
import com.dataiku.dss.shadelib.org.apache.lucene.queryparser.flexible.core.nodes.QueryNode;
import com.dataiku.dss.shadelib.org.apache.lucene.queryparser.flexible.core.processors.QueryNodeProcessorImpl;
import com.dataiku.dss.shadelib.org.apache.lucene.queryparser.flexible.standard.config.FuzzyConfig;
import com.dataiku.dss.shadelib.org.apache.lucene.queryparser.flexible.standard.config.StandardQueryConfigHandler;
import java.util.List;

public class FuzzyQueryNodeProcessor
extends QueryNodeProcessorImpl {
    @Override
    protected QueryNode postProcessNode(QueryNode node) throws QueryNodeException {
        return node;
    }

    @Override
    protected QueryNode preProcessNode(QueryNode node) throws QueryNodeException {
        if (node instanceof FuzzyQueryNode) {
            FuzzyQueryNode fuzzyNode = (FuzzyQueryNode)node;
            QueryConfigHandler config = this.getQueryConfigHandler();
            Analyzer analyzer = this.getQueryConfigHandler().get(StandardQueryConfigHandler.ConfigurationKeys.ANALYZER);
            if (analyzer != null) {
                String text = fuzzyNode.getTextAsString();
                text = analyzer.normalize(fuzzyNode.getFieldAsString(), text).utf8ToString();
                fuzzyNode.setText(text);
            }
            FuzzyConfig fuzzyConfig = null;
            fuzzyConfig = config.get(StandardQueryConfigHandler.ConfigurationKeys.FUZZY_CONFIG);
            if (fuzzyConfig != null) {
                fuzzyNode.setPrefixLength(fuzzyConfig.getPrefixLength());
                if (fuzzyNode.getSimilarity() < 0.0f) {
                    fuzzyNode.setSimilarity(fuzzyConfig.getMinSimilarity());
                }
            } else if (fuzzyNode.getSimilarity() < 0.0f) {
                throw new IllegalArgumentException("No FUZZY_CONFIG set in the config");
            }
        }
        return node;
    }

    @Override
    protected List<QueryNode> setChildrenOrder(List<QueryNode> children) throws QueryNodeException {
        return children;
    }
}

