/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelib.org.apache.lucene.search;

import com.dataiku.dss.shadelib.org.apache.lucene.index.LeafReaderContext;
import com.dataiku.dss.shadelib.org.apache.lucene.index.PostingsEnum;
import com.dataiku.dss.shadelib.org.apache.lucene.index.Term;
import com.dataiku.dss.shadelib.org.apache.lucene.index.TermStates;
import com.dataiku.dss.shadelib.org.apache.lucene.index.Terms;
import com.dataiku.dss.shadelib.org.apache.lucene.index.TermsEnum;
import com.dataiku.dss.shadelib.org.apache.lucene.search.AbstractMultiTermQueryConstantScoreWrapper;
import com.dataiku.dss.shadelib.org.apache.lucene.search.ConstantScoreQuery;
import com.dataiku.dss.shadelib.org.apache.lucene.search.ConstantScoreScorer;
import com.dataiku.dss.shadelib.org.apache.lucene.search.DisiPriorityQueue;
import com.dataiku.dss.shadelib.org.apache.lucene.search.DisiWrapper;
import com.dataiku.dss.shadelib.org.apache.lucene.search.DisjunctionDISIApproximation;
import com.dataiku.dss.shadelib.org.apache.lucene.search.DocIdSetIterator;
import com.dataiku.dss.shadelib.org.apache.lucene.search.IndexSearcher;
import com.dataiku.dss.shadelib.org.apache.lucene.search.MultiTermQuery;
import com.dataiku.dss.shadelib.org.apache.lucene.search.ScoreMode;
import com.dataiku.dss.shadelib.org.apache.lucene.search.Scorer;
import com.dataiku.dss.shadelib.org.apache.lucene.search.TermQuery;
import com.dataiku.dss.shadelib.org.apache.lucene.search.Weight;
import com.dataiku.dss.shadelib.org.apache.lucene.util.DocIdSetBuilder;
import com.dataiku.dss.shadelib.org.apache.lucene.util.PriorityQueue;
import java.io.IOException;
import java.util.List;

final class MultiTermQueryConstantScoreBlendedWrapper<Q extends MultiTermQuery>
extends AbstractMultiTermQueryConstantScoreWrapper<Q> {
    private static final int POSTINGS_PRE_PROCESS_THRESHOLD = 512;

    MultiTermQueryConstantScoreBlendedWrapper(Q query) {
        super(query);
    }

    @Override
    public Weight createWeight(final IndexSearcher searcher, final ScoreMode scoreMode, float boost) throws IOException {
        return new AbstractMultiTermQueryConstantScoreWrapper.RewritingWeight(this.query, boost, scoreMode, searcher){

            @Override
            protected AbstractMultiTermQueryConstantScoreWrapper.WeightOrDocIdSetIterator rewriteInner(LeafReaderContext context, int fieldDocCount, Terms terms, TermsEnum termsEnum, List<AbstractMultiTermQueryConstantScoreWrapper.TermAndState> collectedTerms) throws IOException {
                DocIdSetBuilder otherTerms = new DocIdSetBuilder(context.reader().maxDoc(), terms);
                PriorityQueue<PostingsEnum> highFrequencyTerms = new PriorityQueue<PostingsEnum>(collectedTerms.size()){

                    @Override
                    protected boolean lessThan(PostingsEnum a, PostingsEnum b) {
                        return a.cost() < b.cost();
                    }
                };
                PostingsEnum reuse = null;
                if (!collectedTerms.isEmpty()) {
                    TermsEnum termsEnum2 = terms.iterator();
                    for (AbstractMultiTermQueryConstantScoreWrapper.TermAndState termAndState : collectedTerms) {
                        termsEnum2.seekExact(termAndState.term, termAndState.state);
                        reuse = termsEnum2.postings(reuse, 0);
                        if (termAndState.docFreq <= 512) {
                            otherTerms.add(reuse);
                            continue;
                        }
                        highFrequencyTerms.add(reuse);
                        reuse = null;
                    }
                }
                do {
                    reuse = termsEnum.postings(reuse, 0);
                    int docFreq = termsEnum.docFreq();
                    if (fieldDocCount == docFreq) {
                        TermStates termStates = new TermStates(searcher.getTopReaderContext());
                        termStates.register(termsEnum.termState(), context.ord, docFreq, termsEnum.totalTermFreq());
                        ConstantScoreQuery constantScoreQuery = new ConstantScoreQuery(new TermQuery(new Term(MultiTermQueryConstantScoreBlendedWrapper.this.query.field, termsEnum.term()), termStates));
                        Weight weight = searcher.rewrite(constantScoreQuery).createWeight(searcher, scoreMode, this.score());
                        return new AbstractMultiTermQueryConstantScoreWrapper.WeightOrDocIdSetIterator(weight);
                    }
                    if (docFreq <= 512) {
                        otherTerms.add(reuse);
                        continue;
                    }
                    PostingsEnum dropped = highFrequencyTerms.insertWithOverflow(reuse);
                    if (dropped != null) {
                        otherTerms.add(dropped);
                    }
                    reuse = dropped;
                } while (termsEnum.next() != null);
                DisiPriorityQueue subs = new DisiPriorityQueue(highFrequencyTerms.size() + 1);
                for (DocIdSetIterator docIdSetIterator : highFrequencyTerms) {
                    Scorer s2 = MultiTermQueryConstantScoreBlendedWrapper.wrapWithDummyScorer(this, docIdSetIterator);
                    subs.add(new DisiWrapper(s2));
                }
                Scorer s3 = MultiTermQueryConstantScoreBlendedWrapper.wrapWithDummyScorer(this, otherTerms.build().iterator());
                subs.add(new DisiWrapper(s3));
                return new AbstractMultiTermQueryConstantScoreWrapper.WeightOrDocIdSetIterator(new DisjunctionDISIApproximation(subs));
            }
        };
    }

    private static Scorer wrapWithDummyScorer(Weight weight, DocIdSetIterator disi) {
        return new ConstantScoreScorer(weight, 1.0f, ScoreMode.COMPLETE_NO_SCORES, disi);
    }
}

