/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelib.org.apache.lucene.search.matchhighlight;

import com.dataiku.dss.shadelib.org.apache.lucene.analysis.Analyzer;
import com.dataiku.dss.shadelib.org.apache.lucene.analysis.TokenStream;
import com.dataiku.dss.shadelib.org.apache.lucene.analysis.tokenattributes.OffsetAttribute;
import com.dataiku.dss.shadelib.org.apache.lucene.analysis.tokenattributes.TermToBytesRefAttribute;
import com.dataiku.dss.shadelib.org.apache.lucene.index.Term;
import com.dataiku.dss.shadelib.org.apache.lucene.search.MatchesIterator;
import com.dataiku.dss.shadelib.org.apache.lucene.search.Query;
import com.dataiku.dss.shadelib.org.apache.lucene.search.QueryVisitor;
import com.dataiku.dss.shadelib.org.apache.lucene.search.matchhighlight.MatchRegionRetriever;
import com.dataiku.dss.shadelib.org.apache.lucene.search.matchhighlight.OffsetRange;
import com.dataiku.dss.shadelib.org.apache.lucene.search.matchhighlight.OffsetsRetrievalStrategy;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;

public final class OffsetsFromTokens
implements OffsetsRetrievalStrategy {
    private final String field;
    private final Analyzer analyzer;

    public OffsetsFromTokens(String field, Analyzer analyzer) {
        this.field = field;
        this.analyzer = analyzer;
    }

    @Override
    public List<OffsetRange> get(MatchesIterator matchesIterator, MatchRegionRetriever.FieldValueProvider doc) throws IOException {
        List<CharSequence> values2 = doc.getValues(this.field);
        final HashSet matchTerms = new HashSet();
        while (matchesIterator.next()) {
            Query q = matchesIterator.getQuery();
            q.visit(new QueryVisitor(){

                @Override
                public void consumeTerms(Query query, Term ... terms) {
                    for (Term t2 : terms) {
                        if (!OffsetsFromTokens.this.field.equals(t2.field())) continue;
                        matchTerms.add(t2.bytes());
                    }
                }
            });
        }
        ArrayList<OffsetRange> ranges = new ArrayList<OffsetRange>();
        int valueOffset = 0;
        int max = values2.size();
        for (int valueIndex = 0; valueIndex < max; ++valueIndex) {
            String value = values2.get(valueIndex).toString();
            TokenStream ts = this.analyzer.tokenStream(this.field, value);
            OffsetAttribute offsetAttr = ts.getAttribute(OffsetAttribute.class);
            TermToBytesRefAttribute termAttr = ts.getAttribute(TermToBytesRefAttribute.class);
            ts.reset();
            while (ts.incrementToken()) {
                if (!matchTerms.contains(termAttr.getBytesRef())) continue;
                int startOffset = valueOffset + offsetAttr.startOffset();
                int endOffset = valueOffset + offsetAttr.endOffset();
                ranges.add(new OffsetRange(startOffset, endOffset));
            }
            ts.end();
            valueOffset += offsetAttr.endOffset() + this.analyzer.getOffsetGap(this.field);
            ts.close();
        }
        return ranges;
    }
}

