/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelib.org.apache.lucene.search.uhighlight;

import com.dataiku.dss.shadelib.org.apache.lucene.index.LeafReader;
import com.dataiku.dss.shadelib.org.apache.lucene.index.Terms;
import com.dataiku.dss.shadelib.org.apache.lucene.search.highlight.TermVectorLeafReader;
import com.dataiku.dss.shadelib.org.apache.lucene.search.uhighlight.FieldOffsetStrategy;
import com.dataiku.dss.shadelib.org.apache.lucene.search.uhighlight.OffsetsEnum;
import com.dataiku.dss.shadelib.org.apache.lucene.search.uhighlight.OverlaySingleDocTermsLeafReader;
import com.dataiku.dss.shadelib.org.apache.lucene.search.uhighlight.UHComponents;
import com.dataiku.dss.shadelib.org.apache.lucene.search.uhighlight.UnifiedHighlighter;
import java.io.IOException;

public class TermVectorOffsetStrategy
extends FieldOffsetStrategy {
    public TermVectorOffsetStrategy(UHComponents components) {
        super(components);
    }

    @Override
    public UnifiedHighlighter.OffsetSource getOffsetSource() {
        return UnifiedHighlighter.OffsetSource.TERM_VECTORS;
    }

    @Override
    public OffsetsEnum getOffsetsEnum(LeafReader reader, int docId, String content) throws IOException {
        Terms tvTerms = reader.termVectors().get(docId, this.getField());
        if (tvTerms == null) {
            return OffsetsEnum.EMPTY;
        }
        TermVectorLeafReader singleDocReader = new TermVectorLeafReader(this.getField(), tvTerms);
        return this.createOffsetsEnumFromReader(new OverlaySingleDocTermsLeafReader(reader, singleDocReader, this.getField(), docId), docId);
    }
}

