/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelib.org.eclipse.jetty.ee10.annotations;

import com.dataiku.dss.shadelib.org.eclipse.jetty.ee10.annotations.AnnotationIntrospector;
import com.dataiku.dss.shadelib.org.eclipse.jetty.ee10.webapp.MetaData;
import com.dataiku.dss.shadelib.org.eclipse.jetty.ee10.webapp.Origin;
import com.dataiku.dss.shadelib.org.eclipse.jetty.ee10.webapp.WebAppContext;
import com.dataiku.dss.shadelib.org.eclipse.jetty.plus.annotation.LifeCycleCallbackCollection;
import com.dataiku.dss.shadelib.org.eclipse.jetty.plus.annotation.PreDestroyCallback;
import jakarta.annotation.PreDestroy;
import jakarta.servlet.AsyncListener;
import jakarta.servlet.Filter;
import jakarta.servlet.Servlet;
import jakarta.servlet.ServletContextAttributeListener;
import jakarta.servlet.ServletContextListener;
import jakarta.servlet.ServletRequestAttributeListener;
import jakarta.servlet.ServletRequestListener;
import jakarta.servlet.http.HttpSessionAttributeListener;
import jakarta.servlet.http.HttpSessionIdListener;
import jakarta.servlet.http.HttpSessionListener;
import jakarta.servlet.http.HttpUpgradeHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;

public class PreDestroyAnnotationHandler
extends AnnotationIntrospector.AbstractIntrospectableAnnotationHandler {
    public PreDestroyAnnotationHandler(WebAppContext wac) {
        super(true, wac);
    }

    public void doHandle(Class clazz) {
        if (this.supportsPreDestroy(clazz)) {
            Method[] methods = clazz.getDeclaredMethods();
            for (int i = 0; i < methods.length; ++i) {
                Method m4 = methods[i];
                if (!m4.isAnnotationPresent(PreDestroy.class)) continue;
                if (m4.getParameterCount() != 0) {
                    throw new IllegalStateException(String.valueOf(m4) + " has parameters");
                }
                if (m4.getReturnType() != Void.TYPE) {
                    throw new IllegalStateException(String.valueOf(m4) + " is not void");
                }
                if (m4.getExceptionTypes().length != 0) {
                    throw new IllegalStateException(String.valueOf(m4) + " throws checked exceptions");
                }
                if (Modifier.isStatic(m4.getModifiers())) {
                    throw new IllegalStateException(String.valueOf(m4) + " is static");
                }
                MetaData metaData = this._context.getMetaData();
                Origin origin = metaData.getOrigin("pre-destroy");
                if (origin != null && (origin == Origin.WebXml || origin == Origin.WebDefaults || origin == Origin.WebOverride)) {
                    return;
                }
                PreDestroyCallback callback = new PreDestroyCallback(clazz, m4.getName());
                LifeCycleCallbackCollection lifecycles = (LifeCycleCallbackCollection)this._context.getAttribute("com.dataiku.dss.shadelib.org.eclipse.jetty.lifecyleCallbackCollection");
                if (lifecycles == null) {
                    lifecycles = new LifeCycleCallbackCollection();
                    this._context.setAttribute("com.dataiku.dss.shadelib.org.eclipse.jetty.lifecyleCallbackCollection", lifecycles);
                }
                lifecycles.add(callback);
            }
        }
    }

    public boolean supportsPreDestroy(Class c) {
        return Servlet.class.isAssignableFrom(c) || Filter.class.isAssignableFrom(c) || ServletContextListener.class.isAssignableFrom(c) || ServletContextAttributeListener.class.isAssignableFrom(c) || ServletRequestListener.class.isAssignableFrom(c) || ServletRequestAttributeListener.class.isAssignableFrom(c) || HttpSessionListener.class.isAssignableFrom(c) || HttpSessionAttributeListener.class.isAssignableFrom(c) || HttpSessionIdListener.class.isAssignableFrom(c) || AsyncListener.class.isAssignableFrom(c) || HttpUpgradeHandler.class.isAssignableFrom(c);
    }
}

