/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelib.org.eclipse.jetty.util.thread;

import com.dataiku.dss.shadelib.org.eclipse.jetty.util.annotation.ManagedAttribute;
import com.dataiku.dss.shadelib.org.eclipse.jetty.util.annotation.ManagedObject;
import com.dataiku.dss.shadelib.org.eclipse.jetty.util.component.Dumpable;
import java.io.IOException;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;

@ManagedObject(value="Tracking Executor wrapper")
public class TrackingExecutor
implements Executor,
Dumpable {
    private final Executor _threadFactoryExecutor;
    private final Set<Thread> _threads = ConcurrentHashMap.newKeySet();
    private boolean _detailed;

    public TrackingExecutor(Executor executor, boolean detailed) {
        this._threadFactoryExecutor = executor;
        this._detailed = detailed;
    }

    @Override
    public void execute(Runnable task) {
        this._threadFactoryExecutor.execute(() -> {
            Thread thread2 = Thread.currentThread();
            try {
                this._threads.add(thread2);
                task.run();
            }
            finally {
                this._threads.remove(thread2);
            }
        });
    }

    @Override
    public void dump(Appendable out, String indent) throws IOException {
        Object[] threads = this._threads.stream().map(x$0 -> new DumpableThread((Thread)x$0)).toArray();
        Dumpable.dumpObjects(out, indent, this._threadFactoryExecutor.toString() + " size=" + threads.length, threads);
    }

    public void setDetailedDump(boolean detailedDump) {
        this._detailed = detailedDump;
    }

    @ManagedAttribute(value="reports additional details in the dump")
    public boolean isDetailedDump() {
        return this._detailed;
    }

    public int size() {
        return this._threads.size();
    }

    private class DumpableThread
    implements Dumpable {
        private final Thread _thread;

        private DumpableThread(Thread thread2) {
            this._thread = thread2;
        }

        @Override
        public void dump(Appendable out, String indent) throws IOException {
            if (TrackingExecutor.this._detailed) {
                Object[] stack = this._thread.getStackTrace();
                Dumpable.dumpObjects(out, indent, this._thread.toString(), stack);
            } else {
                Dumpable.dumpObject(out, this._thread);
            }
        }
    }
}

