/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.server.controllers;

import com.dataiku.common.audit.AuditContextBase;
import com.dataiku.dip.exceptions.NotAuthenticatedException;
import com.dataiku.dip.exceptions.UnauthorizedException;
import com.dataiku.dip.logging.LoggableAPIResource;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.UrlRedactionUtils;
import com.dataiku.dip.security.audit.AuditObj;
import com.dataiku.dip.security.audit.AuditTrailService;
import com.dataiku.dip.utils.DKULogger;
import jakarta.servlet.http.HttpServletRequest;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.MDC;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.reflect.MethodSignature;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;

public class CallTracingAspectBase {
    @Autowired
    protected AuditTrailService auditTrailService;
    public static final Pattern SENSITIVE_FIELD = Pattern.compile("password|apikey|secret|apiticket", 2);
    public static final Pattern SENSITIVE_URL_FIELDS = Pattern.compile("url|repository|gitReference", 2);
    static final Set<String> ignoredForLogging = new HashSet<String>();
    private static DKULogger logger;

    protected static String getMapping(Method method) {
        Object mapping = method.getAnnotation(RequestMapping.class).value()[0];
        RequestMapping classRequestMapping = method.getDeclaringClass().getAnnotation(RequestMapping.class);
        if (classRequestMapping != null) {
            mapping = classRequestMapping.value()[0] + (String)mapping;
        }
        return mapping;
    }

    protected AllCallsLoggingContext buildAllCallsLoggingContext(ProceedingJoinPoint joinpoint, MethodSignature signature) {
        AllCallsLoggingContext ret = new AllCallsLoggingContext();
        ret.shortParams = new ArrayList<String>();
        ret.parameterNames = signature.getParameterNames();
        ret.parameterValues = joinpoint.getArgs();
        if (ret.parameterNames != null && ret.parameterValues != null) {
            for (int i = 0; i < ret.parameterNames.length; ++i) {
                Object parameterValue = ret.parameterValues[i];
                if (SENSITIVE_FIELD.matcher(ret.parameterNames[i]).find()) {
                    ret.obj.with(ret.parameterNames[i], "***");
                    ret.shortParams.add(ret.parameterNames[i] + "=***");
                    continue;
                }
                if (parameterValue == null) continue;
                String pv = null;
                if (parameterValue instanceof String) {
                    pv = (String)parameterValue;
                } else if (parameterValue instanceof LoggableAPIResource) {
                    pv = ((LoggableAPIResource)parameterValue).getFormattedLoggableIdentifier();
                } else if (parameterValue instanceof Boolean || parameterValue instanceof Integer || parameterValue instanceof Long || parameterValue instanceof Double || parameterValue instanceof Float || parameterValue instanceof Character || parameterValue instanceof Byte || parameterValue instanceof Short) {
                    pv = String.valueOf(parameterValue);
                }
                if (pv != null && SENSITIVE_URL_FIELDS.matcher(ret.parameterNames[i]).find()) {
                    pv = UrlRedactionUtils.sanitizeHttpUrls(pv);
                }
                if (pv == null || pv.length() >= 100) continue;
                ret.obj.with(ret.parameterNames[i], pv);
                ret.shortParams.add(ret.parameterNames[i] + "=" + pv);
            }
        }
        return ret;
    }

    protected void setAuditContext(String mapping) {
        MDC.clear();
        if (AuditContextBase.getAuthContext() != null) {
            logger.error((Object)"Leak of auth context at start of call");
        }
        AuditContextBase.reset();
        AuditContextBase.setPath(mapping);
    }

    protected void reportPossibleAuthenticationFailure(Throwable thrown, String auditRoutingKey) {
        if (thrown != null) {
            if (thrown instanceof NotAuthenticatedException) {
                this.auditTrailService.auditNotAuthenticatedException((NotAuthenticatedException)((Object)thrown), auditRoutingKey);
            } else if (thrown instanceof UnauthorizedException) {
                this.auditTrailService.auditUnauthorizedException((UnauthorizedException)((Object)thrown), auditRoutingKey);
            }
        }
    }

    static {
        ignoredForLogging.add("/dip/api/futures/get-update");
        ignoredForLogging.add("/dip/api/exports/list");
        logger = DKULogger.getLogger((String)"dku.tracing");
    }

    protected class AllCallsLoggingContext {
        AuditObj obj = new AuditObj("apicall");
        String[] parameterNames;
        Object[] parameterValues;
        List<String> shortParams;

        protected AllCallsLoggingContext() {
        }

        public void logStart(String mapping, String displayedUserStr, AuthCtx authCtx, HttpServletRequest request) {
            String httpMethod;
            String string = httpMethod = request == null ? "" : " [" + request.getMethod() + "]";
            if (logger.isDebugEnabled() && !ignoredForLogging.contains(mapping)) {
                logger.debug((Object)("Start call: " + mapping + httpMethod + " user=" + (displayedUserStr == null ? "none" : displayedUserStr) + (String)(authCtx != null && authCtx.getVia().size() > 0 ? " auth=" + authCtx.toString() : "") + (String)(this.shortParams.size() > 0 ? " [" + StringUtils.join(this.shortParams, (String)" ") + "]" : "")));
            }
        }

        public void logDone(String mapping, String displayedUserStr, AuthCtx authCtx, long executeTime, Throwable thrown, HttpServletRequest request) {
            String httpMethod;
            String string = httpMethod = request == null ? "" : " [" + request.getMethod() + "]";
            if (logger.isDebugEnabled() && !ignoredForLogging.contains(mapping)) {
                logger.debug((Object)("Done call: " + mapping + httpMethod + " time=" + executeTime + "ms user=" + (displayedUserStr == null ? "none" : displayedUserStr) + (String)(authCtx != null && authCtx.getVia().size() > 0 ? " auth=" + authCtx.toString() : "") + (String)(this.shortParams.size() > 0 ? " [" + StringUtils.join(this.shortParams, (String)" ") + "]" : "") + (String)(thrown == null ? "" : " thrown=" + thrown.getClass().getSimpleName())));
            }
        }

        public void emitAudit(long executeTime) {
            this.obj.with("time", executeTime);
            CallTracingAspectBase.this.auditTrailService.emit(this.obj);
        }
    }
}

