/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.utils;

import com.codahale.metrics.Gauge;
import com.codahale.metrics.Metric;
import com.codahale.metrics.MetricSet;
import com.google.common.cache.Cache;
import java.util.HashMap;
import java.util.Map;

public class GuavaCacheMetrics
implements MetricSet {
    public static final String CACHES_CONFIG_ROOT = "dku.caches";
    private Map<String, Metric> map = new HashMap<String, Metric>();

    public static final String metricNameFor(String cacheName, String statName) {
        return "dku.caches." + cacheName + "." + statName;
    }

    public static MetricSet cacheMetricsSet(String cacheName, final Cache<?, ?> cache) {
        GuavaCacheMetrics metrics = new GuavaCacheMetrics();
        metrics.map.put(GuavaCacheMetrics.metricNameFor(cacheName, "size"), (Metric)new Gauge<Long>(){

            public Long getValue() {
                return cache.size();
            }
        });
        metrics.map.put(GuavaCacheMetrics.metricNameFor(cacheName, "hitRate"), (Metric)new Gauge<Double>(){

            public Double getValue() {
                return cache.stats().hitRate();
            }
        });
        metrics.map.put(GuavaCacheMetrics.metricNameFor(cacheName, "hitCount"), (Metric)new Gauge<Long>(){

            public Long getValue() {
                return cache.stats().hitCount();
            }
        });
        metrics.map.put(GuavaCacheMetrics.metricNameFor(cacheName, "missCount"), (Metric)new Gauge<Long>(){

            public Long getValue() {
                return cache.stats().missCount();
            }
        });
        metrics.map.put(GuavaCacheMetrics.metricNameFor(cacheName, "loadCount"), (Metric)new Gauge<Long>(){

            public Long getValue() {
                return cache.stats().loadCount();
            }
        });
        metrics.map.put(GuavaCacheMetrics.metricNameFor(cacheName, "loadExceptionCount"), (Metric)new Gauge<Long>(){

            public Long getValue() {
                return cache.stats().loadExceptionCount();
            }
        });
        metrics.map.put(GuavaCacheMetrics.metricNameFor(cacheName, "evictionCount"), (Metric)new Gauge<Long>(){

            public Long getValue() {
                return cache.stats().evictionCount();
            }
        });
        metrics.map.put(GuavaCacheMetrics.metricNameFor(cacheName, "totalLoadTime"), (Metric)new Gauge<Long>(){

            public Long getValue() {
                return cache.stats().totalLoadTime();
            }
        });
        return metrics;
    }

    public Map<String, Metric> getMetrics() {
        return this.map;
    }
}

