/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.scoring.builders;

import com.dataiku.scoring.builders.ProcessorBuilder;
import com.dataiku.scoring.pipelines.Processor;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;

enum Processors {
    DROP_ROW(new ProcessorBuilder.DropRowBuilder()),
    IMPUTER(new ProcessorBuilder.ImputeBuilder()),
    BINARIZER(new ProcessorBuilder.BinarizerBuilder()),
    FLAGGER(new ProcessorBuilder.FlaggerBuilder()),
    DUMMIFIER(new ProcessorBuilder.DummifierBuilder()),
    DATETIME_CYCLICAL(new ProcessorBuilder.DatetimeCyclicalEncodingBuilder()),
    RESCALER(new ProcessorBuilder.RescalerBuilder()),
    DERIVATIVES(new ProcessorBuilder.DerivativesBuilder()),
    DERIVATIVES_RESCALER(new ProcessorBuilder.DerivativesRescalerBuilder()),
    COUNT_VECTORIZER(new ProcessorBuilder.CountVectorizerBuilder()),
    TFIDF_VECTORIZER(new ProcessorBuilder.TfidfVectorizerBuilder()),
    HASHING_VECTORIZER(new ProcessorBuilder.HashingVectorizerBuilder()),
    UNFOLD_VECTORS(new ProcessorBuilder.UnfoldVectorsBuilder()),
    CATEGORICAL_ENCODER(new ProcessorBuilder.CategoricalEncodingBuilder()),
    INTERACTIONS(new ProcessorBuilder.InteractionBuilder()),
    SELECTION(new ProcessorBuilder.SelectionBuilder());

    public final ProcessorBuilder<? extends Processor> importer;

    private Processors(ProcessorBuilder<? extends Processor> importer) {
        this.importer = importer;
    }

    static List<Processor> importAllFrom(URL f) {
        ArrayList<Processor> stages = new ArrayList<Processor>();
        for (Processors p : Processors.values()) {
            try {
                stages.add(p.importer.buildFrom(f));
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return stages;
    }
}

