/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.gh.cli.internalcmd;

import com.dataiku.dip.security.ConfigFileSymmetricKeyBasedPasswordEncryptionProvider;
import com.dataiku.dip.security.RegularPasswordEncryptionService;
import com.dataiku.dip.security.audit.model.Log4JTargetSettings;
import com.dataiku.dip.server.SharedSecretUtils;
import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.transactions.ifaces.RWTransaction;
import com.dataiku.dip.utils.DKUFileUtils;
import com.dataiku.gh.ApplicationConfigurator;
import com.dataiku.gh.GHSpring;
import com.dataiku.gh.cli.CLICommand;
import com.dataiku.gh.cli.DKU;
import com.dataiku.gh.dao.GeneralSettingsDAO;
import com.dataiku.gh.dao.UsersDAO;
import com.dataiku.gh.dao.impl.FilesBasedUsersDAO;
import com.dataiku.gh.security.model.AbstractGlobalScopePublicAPIKey;
import java.io.File;
import org.apache.commons.cli.Options;

public class InitialSetupHome
extends CLICommand {
    @Override
    public String usageString() {
        return "__initial-setup-home";
    }

    @Override
    public String description() {
        return "populate a default DIP_HOME repository";
    }

    @Override
    public Options opts() {
        Options options = new Options();
        DKU.addGlobalOptions(options);
        return options;
    }

    @Override
    public int execute(String[] args) throws Exception {
        String[] subdirs;
        this.parseAndMiniSetup(args, "__initial-setup-home", false);
        ApplicationConfigurator.autoconfigure();
        GHSpring.doCLISetup();
        for (String s : subdirs = new String[]{"caches", "lib", "privtmp", "run", "tmp", "config"}) {
            File f = ApplicationConfigurator.getFile((String)s);
            DKUFileUtils.mkdirs((File)f);
        }
        TransactionService ts = (TransactionService)SpringUtils.getBean(TransactionService.class);
        try (RWTransaction t = ts.beginWriteAsDSS();){
            GeneralSettingsDAO.GeneralSettings gs = new GeneralSettingsDAO.GeneralSettings();
            Log4JTargetSettings l4t = new Log4JTargetSettings();
            l4t.appendTopicToLogger = true;
            gs.auditTrailSettings.targets.add(l4t);
            t.writeObject("general-settings.json", (Object)gs);
            t.writeObject("public-apikeys.json", (Object)new AbstractGlobalScopePublicAPIKey.KeyList());
            ConfigFileSymmetricKeyBasedPasswordEncryptionProvider.generateDefaultKey();
            RegularPasswordEncryptionService symetricCryptoService = (RegularPasswordEncryptionService)SpringUtils.getBean(RegularPasswordEncryptionService.class);
            symetricCryptoService.reinit();
            FilesBasedUsersDAO ud = new FilesBasedUsersDAO();
            UsersDAO.Group administrators = ud.getDefaultAdminGroup(true);
            String defaultProfile = System.getenv("DKU_INITIAL_SETUP_USER_PROFILE");
            if (defaultProfile == null) {
                defaultProfile = "DATA_SCIENTIST";
            }
            UsersDAO.User adminUser = ud.addUser("admin", "admin");
            adminUser.displayName = "Administrator";
            adminUser.userProfile = defaultProfile;
            adminUser.groups.add(administrators.name);
            ud.saveUser(adminUser);
            GeneralSettingsDAO gsd = (GeneralSettingsDAO)SpringUtils.getBean(GeneralSettingsDAO.class);
            gs = gsd.read();
            gs.nodeName = "Dataiku Govern";
            gsd.save(gs);
            t.commit("Welcome to Dataiku Govern!");
            SharedSecretUtils.getSharedSecret((boolean)true);
            int n = 0;
            return n;
        }
    }
}

