/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.gh.core.controllers;

import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.audit.AuditTrailService;
import com.dataiku.dip.server.controllers.AuditInline;
import com.dataiku.dip.server.controllers.DIPInternalControllerBase;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.dataiku.gh.core.models.blueprints.BlueprintVersionId;
import com.dataiku.gh.core.models.ui.UIBlueprintVersion;
import com.dataiku.gh.core.services.blueprints.IBlueprintsService;
import com.dataiku.gh.security.auth.UIAuthService;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

@Controller
public class BlueprintVersionsController
extends DIPInternalControllerBase {
    @Autowired
    private AuditTrailService auditTrailService;
    @Autowired
    private TransactionService transactionService;
    @Autowired
    private UIAuthService authService;
    @Autowired
    private IBlueprintsService blueprintsService;

    @AuditInline
    @RequestMapping(value={"/api/blueprint-versions/get"}, method={RequestMethod.GET})
    public void get(HttpServletRequest req, HttpServletResponse resp, @RequestParam BlueprintVersionId blueprintVersionId) throws Exception {
        try {
            AuthCtx authCtx;
            try (Transaction t = this.transactionService.beginRead();){
                authCtx = this.authService.getMandatoryUser(req);
            }
            UIBlueprintVersion uiBlueprintVersion = this.blueprintsService.getBlueprintVersion(authCtx, blueprintVersionId);
            this.auditTrailService.generic("blueprint-version-get").with("blueprintId", uiBlueprintVersion.blueprintVersion.id.blueprintId).with("versionId", uiBlueprintVersion.blueprintVersion.id.versionId).emit();
            BlueprintVersionsController.writeJSON((HttpServletResponse)resp, (Object)uiBlueprintVersion);
        }
        catch (Exception e) {
            this.auditTrailService.failure("blueprint-version-get", (Throwable)e).emit();
            throw e;
        }
    }

    @AuditInline
    @RequestMapping(value={"/api/blueprint-versions/list"}, method={RequestMethod.GET})
    public void list(HttpServletRequest req, HttpServletResponse resp, @RequestParam(required=false) String blueprintId) throws Exception {
        try {
            List<UIBlueprintVersion> uiBlueprintVersions;
            AuthCtx authCtx;
            try (Transaction t = this.transactionService.beginRead();){
                authCtx = this.authService.getMandatoryUser(req);
            }
            AuditTrailService.EmittableAuditObj obj = this.auditTrailService.generic("blueprint-versions-list");
            if (StringUtils.isNotBlank((CharSequence)blueprintId)) {
                obj.with("blueprintId", blueprintId);
                uiBlueprintVersions = this.blueprintsService.listBlueprintVersionsByBlueprint(authCtx, blueprintId);
            } else {
                uiBlueprintVersions = this.blueprintsService.listBlueprintVersions(authCtx);
            }
            obj.emit();
            BlueprintVersionsController.writeJSON((HttpServletResponse)resp, uiBlueprintVersions);
        }
        catch (Exception e) {
            this.auditTrailService.failure("blueprint-versions-list", (Throwable)e).emit();
            throw e;
        }
    }
}

