/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.gh.core.controllers.admin;

import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.audit.AuditTrailService;
import com.dataiku.dip.server.controllers.AuditInline;
import com.dataiku.dip.server.controllers.AuditedCall;
import com.dataiku.dip.server.controllers.DIPInternalControllerBase;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.dataiku.gh.core.context.GovernAction;
import com.dataiku.gh.core.models.history.ActionType;
import com.dataiku.gh.core.models.roles.permissions.BlueprintPermissions;
import com.dataiku.gh.core.services.roles_and_permissions.permissions.IAdminBlueprintPermissionsService;
import com.dataiku.gh.security.auth.UIAuthService;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

@Controller
public class AdminBlueprintPermissionsController
extends DIPInternalControllerBase {
    @Autowired
    private AuditTrailService auditTrailService;
    @Autowired
    private TransactionService transactionService;
    @Autowired
    private UIAuthService authService;
    @Autowired
    private IAdminBlueprintPermissionsService adminBlueprintPermissionsService;

    @AuditedCall(value={"msgType", "blueprint-permissions-get", "blueprintId", "${blueprintId}"})
    @RequestMapping(value={"/api/admin/blueprint-permissions/get"}, method={RequestMethod.GET})
    public void get(HttpServletRequest req, HttpServletResponse resp, @RequestParam String blueprintId) throws Exception {
        AuthCtx authCtx;
        try (Transaction t = this.transactionService.beginRead();){
            authCtx = this.authService.getMandatoryUser(req);
        }
        AdminBlueprintPermissionsController.writeJSON((HttpServletResponse)resp, (Object)this.adminBlueprintPermissionsService.getBlueprintPermissions(authCtx, blueprintId));
    }

    @AuditedCall(value={"msgType", "blueprint-permissions-get-or-null", "blueprintId", "${blueprintId}"})
    @RequestMapping(value={"/api/admin/blueprint-permissions/get-or-null"}, method={RequestMethod.GET})
    public void getOrNull(HttpServletRequest req, HttpServletResponse resp, @RequestParam String blueprintId) throws Exception {
        AuthCtx authCtx;
        try (Transaction t = this.transactionService.beginRead();){
            authCtx = this.authService.getMandatoryUser(req);
        }
        BlueprintPermissions blueprintPermissions = this.adminBlueprintPermissionsService.getBlueprintPermissionsOrNull(authCtx, blueprintId);
        if (blueprintPermissions != null) {
            AdminBlueprintPermissionsController.writeJSON((HttpServletResponse)resp, (Object)blueprintPermissions);
        }
    }

    @AuditedCall(value={"msgType", "blueprint-permissions-list"})
    @RequestMapping(value={"/api/admin/blueprint-permissions/list"}, method={RequestMethod.GET})
    public void list(HttpServletRequest req, HttpServletResponse resp) throws Exception {
        AuthCtx authCtx;
        try (Transaction t = this.transactionService.beginRead();){
            authCtx = this.authService.getMandatoryUser(req);
        }
        AdminBlueprintPermissionsController.writeJSON((HttpServletResponse)resp, this.adminBlueprintPermissionsService.listBlueprintPermissions(authCtx));
    }

    @AuditInline
    @RequestMapping(value={"/api/admin/blueprint-permissions/create"}, method={RequestMethod.POST})
    @GovernAction(value=ActionType.BLUEPRINT_PERMISSIONS_CREATE)
    public void create(HttpServletRequest req, HttpServletResponse resp, @RequestParam BlueprintPermissions blueprintPermissions) throws Exception {
        try {
            AuthCtx authCtx;
            try (Transaction t = this.transactionService.beginRead();){
                authCtx = this.authService.getMandatoryUser(req);
            }
            BlueprintPermissions createdBlueprintPermissions = this.adminBlueprintPermissionsService.createBlueprintPermissions(authCtx, blueprintPermissions);
            this.auditTrailService.generic("blueprint-permissions-create").with("blueprintId", createdBlueprintPermissions.blueprintId).emit();
            AdminBlueprintPermissionsController.writeJSON((HttpServletResponse)resp, (Object)createdBlueprintPermissions);
        }
        catch (Exception e) {
            this.auditTrailService.failure("blueprint-permissions-create", (Throwable)e).emit();
            throw e;
        }
    }

    @AuditInline
    @RequestMapping(value={"/api/admin/blueprint-permissions/save"}, method={RequestMethod.PUT})
    @GovernAction(value=ActionType.BLUEPRINT_PERMISSIONS_SAVE)
    public void save(HttpServletRequest req, HttpServletResponse resp, @RequestParam BlueprintPermissions blueprintPermissions) throws Exception {
        try {
            AuthCtx authCtx;
            try (Transaction t = this.transactionService.beginRead();){
                authCtx = this.authService.getMandatoryUser(req);
            }
            BlueprintPermissions savedBlueprintPermissions = this.adminBlueprintPermissionsService.saveBlueprintPermissions(authCtx, blueprintPermissions);
            this.auditTrailService.generic("blueprint-permissions-save").with("blueprintId", savedBlueprintPermissions.blueprintId).emit();
            AdminBlueprintPermissionsController.writeJSON((HttpServletResponse)resp, (Object)savedBlueprintPermissions);
        }
        catch (Exception e) {
            this.auditTrailService.failure("blueprint-permissions-save", (Throwable)e).emit();
            throw e;
        }
    }

    @AuditedCall(value={"msgType", "blueprint-permissions-delete", "blueprintId", "${blueprintId}"})
    @RequestMapping(value={"/api/admin/blueprint-permissions/delete"}, method={RequestMethod.DELETE})
    @GovernAction(value=ActionType.BLUEPRINT_PERMISSIONS_DELETE)
    public void delete(HttpServletRequest req, HttpServletResponse resp, @RequestParam String blueprintId) throws Exception {
        AuthCtx authCtx;
        try (Transaction t = this.transactionService.beginRead();){
            authCtx = this.authService.getMandatoryUser(req);
        }
        this.adminBlueprintPermissionsService.deleteBlueprintPermissions(authCtx, blueprintId);
        AdminBlueprintPermissionsController.writeEmptyJSONObj((HttpServletResponse)resp);
    }

    @AuditInline
    @RequestMapping(value={"/api/admin/blueprint-permissions/default"}, method={RequestMethod.GET})
    public void getDefault(HttpServletRequest req, HttpServletResponse resp) throws Exception {
        try {
            AuthCtx authCtx;
            try (Transaction t = this.transactionService.beginRead();){
                authCtx = this.authService.getMandatoryUser(req);
            }
            AdminBlueprintPermissionsController.writeJSON((HttpServletResponse)resp, (Object)this.adminBlueprintPermissionsService.getDefaultBlueprintPermissions(authCtx));
            this.auditTrailService.generic("blueprint-permissions-default-get").emit();
        }
        catch (Exception e) {
            this.auditTrailService.failure("blueprint-permissions-default-get", (Throwable)e).emit();
            throw e;
        }
    }

    @AuditInline
    @RequestMapping(value={"/api/admin/blueprint-permissions/default"}, method={RequestMethod.PUT})
    @GovernAction(value=ActionType.BLUEPRINT_PERMISSIONS_DEFAULT_SAVE)
    public void saveDefault(HttpServletRequest req, HttpServletResponse resp, @RequestParam BlueprintPermissions blueprintPermissions) throws Exception {
        try {
            AuthCtx authCtx;
            try (Transaction t = this.transactionService.beginRead();){
                authCtx = this.authService.getMandatoryUser(req);
            }
            this.adminBlueprintPermissionsService.saveDefaultBlueprintPermissions(authCtx, blueprintPermissions);
            this.auditTrailService.generic("blueprint-permissions-default-save").emit();
            AdminBlueprintPermissionsController.writeEmptyJSONObj((HttpServletResponse)resp);
        }
        catch (Exception e) {
            this.auditTrailService.failure("blueprint-permissions-default-save", (Throwable)e).emit();
            throw e;
        }
    }
}

