/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.gh.core.models.notifications.common;

import com.dataiku.dip.utils.DKULogger;
import com.dataiku.gh.core.models.enriched.EnrichedArtifact;
import com.dataiku.gh.core.models.fields.definitions.FieldDefinition;
import com.dataiku.gh.core.models.notifications.NotificationContextUtils;
import com.dataiku.gh.core.models.notifications.PermissionProtectedTemplateContext;
import com.dataiku.gh.core.models.roles.permissions.EffectivePermissionsItem;
import com.dataiku.gh.core.models.roles.permissions.FieldPermissionsItem;
import freemarker.template.ObjectWrapper;
import freemarker.template.SimpleHash;
import freemarker.template.SimpleNumber;
import freemarker.template.SimpleScalar;
import freemarker.template.SimpleSequence;
import freemarker.template.TemplateBooleanModel;
import freemarker.template.TemplateHashModel;
import freemarker.template.TemplateModel;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;

public class ArtifactTemplateContext
extends PermissionProtectedTemplateContext {
    List<ArtifactTemplateContext> breadcrumbContexts;
    private static final DKULogger logger = DKULogger.getLogger((String)"gh.notifications.artifact-template-context");

    public ArtifactTemplateContext(EnrichedArtifact enrichedArtifact) {
        super(enrichedArtifact);
    }

    public List<ArtifactTemplateContext> getChildren() {
        return this.breadcrumbContexts != null ? this.breadcrumbContexts : Collections.emptyList();
    }

    public void setBreadcrumb(List<EnrichedArtifact> breadcrumb) {
        this.breadcrumbContexts = breadcrumb.stream().map(ArtifactTemplateContext::new).collect(Collectors.toList());
    }

    public SimpleHash buildTemplateModel() {
        SimpleHash data = new SimpleHash((ObjectWrapper)WRAPPER_BUILDER.build());
        data.put("id", (Object)this.enrichedArtifact.artifact.id);
        EffectivePermissionsItem permissionsForUser = this.getPermissionsForUser(this.userLogin);
        if (this.userCanSeeContext()) {
            data.put("name", (Object)this.enrichedArtifact.artifact.name);
            data.put("blueprintName", (Object)((String)StringUtils.defaultIfBlank((CharSequence)this.enrichedArtifact.blueprint.name, (CharSequence)"Unnamed") + " (" + this.enrichedArtifact.blueprint.id + ")"));
            String blueprintVersionStr = StringUtils.equals((CharSequence)"bv.system.default", (CharSequence)this.enrichedArtifact.blueprintVersion.id.versionId) ? "Dataiku Standard" : (String)StringUtils.defaultIfBlank((CharSequence)this.enrichedArtifact.blueprintVersion.name, (CharSequence)"Unnamed");
            data.put("blueprintVersionName", (Object)blueprintVersionStr);
            FieldsTemplateHashModel fieldsLookup = new FieldsTemplateHashModel(permissionsForUser);
            data.put("fields", (Object)fieldsLookup);
            String parentFieldId = this.enrichedArtifact.blueprintVersion.hierarchicalParentFieldId;
            if (StringUtils.isNotBlank((CharSequence)parentFieldId)) {
                data.put("parent", (Object)fieldsLookup.get(parentFieldId));
            }
        }
        if (this.breadcrumbContexts != null) {
            data.put("breadcrumb", this.breadcrumbContexts.stream().map(ArtifactTemplateContext::buildTemplateModel).collect(Collectors.toList()));
        }
        return data;
    }

    private class FieldsTemplateHashModel
    implements TemplateHashModel {
        private final EffectivePermissionsItem permissionsForUser;

        protected FieldsTemplateHashModel(EffectivePermissionsItem permissionsForUser) {
            this.permissionsForUser = permissionsForUser;
        }

        public TemplateModel get(String fieldId) {
            if (!(((ArtifactTemplateContext)ArtifactTemplateContext.this).enrichedArtifact.blueprintVersion.fieldDefinitions.containsKey(fieldId) && ((ArtifactTemplateContext)ArtifactTemplateContext.this).enrichedArtifact.artifact.fields.containsKey(fieldId) && this.permissionsForUser.fieldPermissionsItems.get(fieldId).hasReadPermission())) {
                return null;
            }
            Object value = ((ArtifactTemplateContext)ArtifactTemplateContext.this).enrichedArtifact.artifact.fields.get(fieldId);
            if (value == null) {
                return null;
            }
            FieldDefinition fieldDefinition = ((ArtifactTemplateContext)ArtifactTemplateContext.this).enrichedArtifact.blueprintVersion.fieldDefinitions.get(fieldId);
            if (fieldDefinition.listConfig != null) {
                if (value instanceof List) {
                    return new SimpleSequence((Collection)((List)value).stream().map(e -> this.handleValue(e, fieldDefinition)).collect(Collectors.toList()), (ObjectWrapper)WRAPPER_BUILDER.build());
                }
                return null;
            }
            return this.handleValue(value, fieldDefinition);
        }

        private TemplateModel handleValue(Object value, FieldDefinition fieldDefinition) {
            switch (fieldDefinition.fieldType) {
                case NUMBER: {
                    return new SimpleNumber((Number)value);
                }
                case DATE: {
                    return NotificationContextUtils.parseDate((String)value);
                }
                case BOOLEAN: {
                    return (Boolean)value != false ? TemplateBooleanModel.TRUE : TemplateBooleanModel.FALSE;
                }
                case TEXT: 
                case CATEGORY: 
                case REFERENCE: {
                    return new SimpleScalar((String)value);
                }
            }
            logger.error((Object)String.format("Email templating does not support field type %s.", new Object[]{fieldDefinition.fieldType}));
            return null;
        }

        public boolean isEmpty() {
            return ((ArtifactTemplateContext)ArtifactTemplateContext.this).enrichedArtifact.blueprintVersion.fieldDefinitions.keySet().stream().map(this.permissionsForUser.fieldPermissionsItems::get).noneMatch(FieldPermissionsItem::hasReadPermission);
        }
    }
}

