/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.gh.core.publicapi;

import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.audit.AuditTrailService;
import com.dataiku.dip.server.api.PublicAPIControllerBase;
import com.dataiku.dip.server.controllers.AuditedCall;
import com.dataiku.gh.core.models.ui.UIBlueprint;
import com.dataiku.gh.core.services.blueprints.IBlueprintsService;
import com.dataiku.gh.security.auth.MetaAuthService;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

@Controller
public class PublicAPIBlueprintsController
extends PublicAPIControllerBase {
    @Autowired
    private AuditTrailService auditTrailService;
    @Autowired
    private MetaAuthService authService;
    @Autowired
    private IBlueprintsService blueprintsService;

    @AuditedCall(value={"msgType", "blueprints-list"})
    @RequestMapping(value={"/publicapi/blueprints"}, method={RequestMethod.GET})
    public void list(HttpServletRequest req, HttpServletResponse resp) throws Exception {
        AuthCtx authCtx = this.authService.getTicketOrKey_NT(req);
        PublicAPIBlueprintsController.writeJSON((HttpServletResponse)resp, this.blueprintsService.listBlueprints(authCtx));
    }

    @AuditedCall(value={"msgType", "blueprint-get", "blueprintId", "${blueprintId}"})
    @RequestMapping(value={"/publicapi/blueprint/{blueprintId}"}, method={RequestMethod.GET})
    public void get(HttpServletRequest req, HttpServletResponse resp, @PathVariable String blueprintId) throws Exception {
        AuthCtx authCtx = this.authService.getTicketOrKey_NT(req);
        UIBlueprint uiBlueprint = this.blueprintsService.getBlueprint(authCtx, blueprintId);
        PublicAPIBlueprintsController.writeJSON((HttpServletResponse)resp, (Object)uiBlueprint);
    }
}

