/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.gh.core.publicapi.admin;

import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.server.api.PublicAPIControllerBase;
import com.dataiku.dip.server.controllers.AuditedCall;
import com.dataiku.gh.core.context.GovernAction;
import com.dataiku.gh.core.models.history.ActionType;
import com.dataiku.gh.core.services.security.mappings.IUsersMappingsService;
import com.dataiku.gh.security.IPermissionsService;
import com.dataiku.gh.security.auth.MetaAuthService;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

@Controller
public class PublicAPIAdminUsersMappingsController
extends PublicAPIControllerBase {
    @Autowired
    private MetaAuthService authService;
    @Autowired
    private IUsersMappingsService usersMappingsService;
    @Autowired
    private IPermissionsService permissionsService;

    @AuditedCall(value={"msgType", "users-mappings-sync"})
    @RequestMapping(value={"/publicapi/admin/users-mappings/sync"}, method={RequestMethod.POST})
    @GovernAction(value=ActionType.USERS_MAPPING_SYNC)
    public void get(HttpServletRequest req, HttpServletResponse resp) throws Exception {
        AuthCtx authCtx = this.authService.getTicketOrKey_NT(req);
        this.permissionsService.checkAdmin(authCtx);
        this.usersMappingsService.syncAll();
        PublicAPIAdminUsersMappingsController.writeEmptyJSONObj((HttpServletResponse)resp);
    }
}

