/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.gh.core.services.dss.sync;

import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dss_gh.api.models.identifiers.DSSDeployerDeploymentIdentifier;
import com.dataiku.dss_gh.api.models.identifiers.DSSDeployerInfraIdentifier;
import com.dataiku.dss_gh.api.models.identifiers.DSSProjectIdentifier;
import com.dataiku.dss_gh.api.models.metrics.DSSSavedModelVersionEvaluationMetricDatapoints;
import com.dataiku.dss_gh.api.models.sync.DSSAPIDeployerDeployment;
import com.dataiku.dss_gh.api.models.sync.DSSAPIDeployerInfra;
import com.dataiku.dss_gh.api.models.sync.DSSAgentSavedModelVersion;
import com.dataiku.dss_gh.api.models.sync.DSSAugmentedSavedModelVersion;
import com.dataiku.dss_gh.api.models.sync.DSSBundle;
import com.dataiku.dss_gh.api.models.sync.DSSClusteringSavedModelVersion;
import com.dataiku.dss_gh.api.models.sync.DSSDataset;
import com.dataiku.dss_gh.api.models.sync.DSSDeployerItems;
import com.dataiku.dss_gh.api.models.sync.DSSFineTuningSavedModelVersion;
import com.dataiku.dss_gh.api.models.sync.DSSPredictionSavedModelVersion;
import com.dataiku.dss_gh.api.models.sync.DSSProject;
import com.dataiku.dss_gh.api.models.sync.DSSProjectDeployerDeployment;
import com.dataiku.dss_gh.api.models.sync.DSSProjectDeployerInfra;
import com.dataiku.dss_gh.api.models.sync.DSSRetrievableKnowledge;
import com.dataiku.dss_gh.api.models.sync.DSSSavedModel;
import com.dataiku.dss_gh.api.models.sync.DSSSavedModelVersion;
import com.dataiku.dss_gh.api.models.sync.IDSSSavedModelVersionVisitor;
import com.dataiku.gh.core.models.artifacts.Artifact;
import com.dataiku.gh.core.models.blueprints.BlueprintVersionId;
import com.dataiku.gh.core.models.dss.DSSArtifactContainer;
import com.dataiku.gh.core.models.dss.DSSDeployerArtifactsContainer;
import com.dataiku.gh.core.models.dss.DSSProjectArtifactsContainer;
import com.dataiku.gh.core.models.enriched.EnrichedBlueprintVersion;
import com.dataiku.gh.core.services.dss.sync.IDSSObjectsToArtifactMapperService;
import com.dataiku.gh.core.services.system.ISystemProvidedBlueprintVersionsCacheService;
import com.dataiku.gh.core.services.system.SystemProvidedConstants;
import com.dataiku.gh.core.services.validation.errors.ValidationException;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class DSSObjectsToArtifactMapperService
implements IDSSObjectsToArtifactMapperService {
    @Autowired
    private ISystemProvidedBlueprintVersionsCacheService systemProvidedCacheService;
    private static DKULogger logger = DKULogger.getLogger((String)"dku.dss-item-mapper");

    @Override
    public DSSProjectArtifactsContainer mapDSSProjectItemsToArtifacts(DSSProject dssProject) throws IOException {
        try {
            this.validateDSSProject(dssProject);
            DSSProjectArtifactsContainer container = new DSSProjectArtifactsContainer();
            container.setProject(this.mapProject_UncheckedIOException(dssProject));
            dssProject.bundles.stream().map(bundle -> this.mapBundle_UncheckedIOException(dssProject, (DSSBundle)bundle)).forEach(container::addBundle);
            dssProject.datasets.stream().map(dataset -> this.mapDataset_UncheckedIOException(dssProject, (DSSDataset)dataset)).forEach(container::addDataset);
            dssProject.savedModels.stream().map(savedModel -> {
                savedModel.savedModelVersions.stream().map(savedModelVersion -> this.mapSavedModelVersion_UncheckedIOException(dssProject, (DSSSavedModel)savedModel, (DSSSavedModelVersion)savedModelVersion)).forEach(container::addSavedModelVersion);
                return this.mapSavedModel_UncheckedIOException(dssProject, (DSSSavedModel)savedModel);
            }).forEach(container::addSavedModel);
            dssProject.retrievableKnowledges.stream().map(retrievableKnowledge -> this.mapRetrievableKnowledge_UncheckedIOException(dssProject, (DSSRetrievableKnowledge)retrievableKnowledge)).forEach(container::addRetrievableKnowledge);
            return container;
        }
        catch (UncheckedIOException uncheckedIOException) {
            throw uncheckedIOException.getCause();
        }
    }

    @Override
    public DSSDeployerArtifactsContainer mapDSSDeployerItemsToArtifacts(DSSDeployerItems deployerItems) throws IOException {
        try {
            this.validateDeployerItems(deployerItems);
            DSSDeployerArtifactsContainer container = new DSSDeployerArtifactsContainer();
            deployerItems.apiInfras.stream().map(this::mapAPIInfra_UncheckedIOException).forEach(container::addAPIInfra);
            deployerItems.projectInfras.stream().map(this::mapProjectInfra_UncheckedIOException).forEach(container::addProjectInfra);
            deployerItems.apiDeployments.stream().map(this::mapAPIDeployment_UncheckedIOException).forEach(container::addAPIDeployment);
            deployerItems.projectDeployments.stream().map(this::mapProjectDeployment_UncheckedIOException).forEach(container::addProjectDeployment);
            return container;
        }
        catch (UncheckedIOException uncheckedIOException) {
            throw uncheckedIOException.getCause();
        }
    }

    private DSSArtifactContainer.DSSProjectArtifactContainer mapProject_UncheckedIOException(DSSProject dssProject) {
        EnrichedBlueprintVersion enrichedBlueprintVersion = this.getSystemDefaultBlueprintVersion_UncheckedIOException(SystemProvidedConstants.DATAIKU_PROJECT.getSingleDefaultBlueprintVersionId());
        Artifact artifact = new Artifact();
        artifact.blueprintVersionId = enrichedBlueprintVersion.blueprintVersion.id;
        artifact.name = dssProject.name;
        this.addDetailsFields(artifact, enrichedBlueprintVersion, dssProject.details);
        this.addBaseFieldsToArtifact(artifact, dssProject);
        this.setNotMandatoryField(artifact, "creation_date", dssProject.projectCreationDate);
        artifact.fields.put("hidden_in_governable_items_table", false);
        return DSSArtifactContainer.buildProject(artifact);
    }

    private DSSArtifactContainer.DSSBundleArtifactContainer mapBundle_UncheckedIOException(DSSProject dssProject, DSSBundle dssBundle) {
        EnrichedBlueprintVersion enrichedBlueprintVersion = this.getSystemDefaultBlueprintVersion_UncheckedIOException(SystemProvidedConstants.DATAIKU_BUNDLE.getSingleDefaultBlueprintVersionId());
        Artifact artifact = new Artifact();
        artifact.blueprintVersionId = enrichedBlueprintVersion.blueprintVersion.id;
        artifact.name = dssBundle.bundleId;
        this.addDetailsFields(artifact, enrichedBlueprintVersion, dssBundle.details);
        this.addBaseFieldsToArtifact(artifact, dssProject);
        this.setMandatoryField(artifact, "bundle_id", dssBundle.bundleId);
        this.setNotMandatoryField(artifact, "creation_date", dssBundle.bundleCreationDate);
        return DSSArtifactContainer.buildBundle(artifact);
    }

    private DSSArtifactContainer.DSSDatasetArtifactContainer mapDataset_UncheckedIOException(DSSProject dssProject, DSSDataset dssDataset) {
        EnrichedBlueprintVersion enrichedBlueprintVersion = this.getSystemDefaultBlueprintVersion_UncheckedIOException(SystemProvidedConstants.DATAIKU_DATASET.getSingleDefaultBlueprintVersionId());
        Artifact artifact = new Artifact();
        artifact.blueprintVersionId = enrichedBlueprintVersion.blueprintVersion.id;
        artifact.name = dssDataset.datasetName;
        this.addDetailsFields(artifact, enrichedBlueprintVersion, dssDataset.details);
        this.addBaseFieldsToArtifact(artifact, dssProject);
        this.setMandatoryField(artifact, "dataset_name", dssDataset.datasetName);
        this.setNotMandatoryField(artifact, "creation_date", dssDataset.datasetCreationDate);
        return DSSArtifactContainer.buildDataset(artifact);
    }

    private DSSArtifactContainer.DSSSavedModelArtifactContainer mapSavedModel_UncheckedIOException(DSSProject dssProject, DSSSavedModel dssSavedModel) {
        EnrichedBlueprintVersion enrichedBlueprintVersion = this.getSystemDefaultBlueprintVersion_UncheckedIOException(SystemProvidedConstants.DATAIKU_SAVED_MODEL.getSingleDefaultBlueprintVersionId());
        Artifact artifact = new Artifact();
        artifact.blueprintVersionId = enrichedBlueprintVersion.blueprintVersion.id;
        artifact.name = dssSavedModel.name;
        this.addDetailsFields(artifact, enrichedBlueprintVersion, dssSavedModel.details);
        this.addBaseFieldsToArtifact(artifact, dssProject);
        this.setMandatoryField(artifact, "saved_model_id", dssSavedModel.savedModelId);
        this.setNotMandatoryField(artifact, "creation_date", dssSavedModel.savedModelCreationDate);
        artifact.fields.put("hidden_in_governable_items_table", false);
        return DSSArtifactContainer.buildSavedModel(artifact);
    }

    private DSSArtifactContainer.DSSRetrievableKnowledgeArtifactContainer mapRetrievableKnowledge_UncheckedIOException(DSSProject dssProject, DSSRetrievableKnowledge dssRetrievableKnowledge) {
        EnrichedBlueprintVersion enrichedBlueprintVersion = this.getSystemDefaultBlueprintVersion_UncheckedIOException(SystemProvidedConstants.DATAIKU_RETRIEVABLE_KNOWLEDGE.getSingleDefaultBlueprintVersionId());
        Artifact artifact = new Artifact();
        artifact.blueprintVersionId = enrichedBlueprintVersion.blueprintVersion.id;
        artifact.name = dssRetrievableKnowledge.name;
        this.addDetailsFields(artifact, enrichedBlueprintVersion, dssRetrievableKnowledge.details);
        this.addBaseFieldsToArtifact(artifact, dssProject);
        this.setMandatoryField(artifact, "retrievable_knowledge_id", dssRetrievableKnowledge.retrievableKnowledgeId);
        this.setNotMandatoryField(artifact, "creation_date", dssRetrievableKnowledge.retrievableKnowledgeCreationDate);
        return DSSArtifactContainer.buildRetrievableKnowledge(artifact);
    }

    private DSSArtifactContainer.DSSSavedModelVersionArtifactContainer mapSavedModelVersion_UncheckedIOException(DSSProject dssProject, DSSSavedModel dssSavedModel, DSSSavedModelVersion dssSavedModelVersion) {
        SavedModelVersionMapper savedModelVersionMapper = new SavedModelVersionMapper();
        dssSavedModelVersion.accept((IDSSSavedModelVersionVisitor)savedModelVersionMapper);
        EnrichedBlueprintVersion enrichedBlueprintVersion = this.getSystemDefaultBlueprintVersion_UncheckedIOException(savedModelVersionMapper.blueprintVersionId);
        Artifact artifact = new Artifact();
        artifact.blueprintVersionId = enrichedBlueprintVersion.blueprintVersion.id;
        artifact.name = dssSavedModelVersion.name;
        this.addDetailsFields(artifact, enrichedBlueprintVersion, dssSavedModelVersion.details);
        savedModelVersionMapper.specificFieldsConsumer.accept(artifact);
        this.addBaseFieldsToArtifact(artifact, dssProject);
        this.setMandatoryField(artifact, "saved_model_id", dssSavedModel.savedModelId);
        this.setMandatoryField(artifact, "full_model_version_id", dssSavedModelVersion.fullModelVersionId);
        this.setNotMandatoryField(artifact, "creation_date", dssSavedModelVersion.savedModelVersionCreationDate);
        return DSSArtifactContainer.buildSavedModelVersion(artifact, savedModelVersionMapper.evaluationMetricDatapoints);
    }

    private void validateDSSProject(DSSProject dssProject) {
        if (dssProject == null) {
            throw new ValidationException("dssProject can't be null");
        }
        if (dssProject.dssProjectIdentifier == null) {
            throw new ValidationException("dssProject.dssProjectIdentifier can't be null");
        }
        if (StringUtils.isBlank((CharSequence)dssProject.dssProjectIdentifier.nodeId)) {
            throw new ValidationException("dssProject.dssProjectIdentifier.nodeId must be set");
        }
        if (StringUtils.isBlank((CharSequence)dssProject.dssProjectIdentifier.projectKey)) {
            throw new ValidationException("dssProject.dssProjectIdentifier.projectKey must be set");
        }
    }

    private void addDetailsFields(Artifact artifact, EnrichedBlueprintVersion enrichedBlueprintVersion, Map<String, Object> details) {
        for (Map.Entry<String, Object> entry : details.entrySet()) {
            if (enrichedBlueprintVersion.blueprintVersion.fieldDefinitions.containsKey(entry.getKey())) {
                artifact.fields.put(entry.getKey(), entry.getValue());
                continue;
            }
            String blueprintVersionName = StringUtils.isBlank((CharSequence)enrichedBlueprintVersion.blueprintVersion.name) ? "" : " (" + enrichedBlueprintVersion.blueprintVersion.name + ")";
            logger.warn((Object)("Cannot set fieldId " + entry.getKey() + " for " + artifact.name + " of type " + enrichedBlueprintVersion.blueprint.name + blueprintVersionName));
        }
    }

    private void addBaseFieldsToArtifact(Artifact artifact, DSSProject dssProject) {
        artifact.fields.put("node_id", dssProject.dssProjectIdentifier.nodeId);
        artifact.fields.put("project_key", dssProject.dssProjectIdentifier.projectKey);
    }

    private void setMandatoryField(Artifact artifact, String fieldId, String value) {
        if (StringUtils.isBlank((CharSequence)value)) {
            throw new ValidationException(fieldId + " must be set");
        }
        artifact.fields.put(fieldId, value);
    }

    private void setNotMandatoryField(Artifact artifact, String fieldId, String value) {
        if (StringUtils.isBlank((CharSequence)value)) {
            logger.warn((Object)(fieldId + " should be set"));
        }
        artifact.fields.put(fieldId, value);
    }

    public static DSSProjectIdentifier getProjectIdentifierFromDataikuProjectItemArtifact(Artifact dssArtifact) {
        DSSProjectIdentifier identifier = new DSSProjectIdentifier();
        identifier.nodeId = (String)dssArtifact.fields.get("node_id");
        identifier.projectKey = (String)dssArtifact.fields.get("project_key");
        return identifier;
    }

    private void validateDeployerItems(DSSDeployerItems deployerItems) {
        if (deployerItems.nodeId == null) {
            throw new ValidationException("The node Id of the deployer items must be set");
        }
        for (DSSProjectDeployerInfra deployerInfra : deployerItems.projectInfras) {
            if (deployerInfra == null) {
                throw new ValidationException("Project deployer infrastructure can't be null");
            }
            this.validateDSSDeployerInfraIdentifier((DSSDeployerInfraIdentifier)deployerInfra.dssProjectDeployerInfraIdentifier);
        }
        for (DSSAPIDeployerInfra apiInfra : deployerItems.apiInfras) {
            if (apiInfra == null) {
                throw new ValidationException("API deployer infrastructure can't be null");
            }
            this.validateDSSDeployerInfraIdentifier((DSSDeployerInfraIdentifier)apiInfra.dssAPIDeployerInfraIdentifier);
        }
        for (DSSProjectDeployerDeployment deployerDeployment : deployerItems.projectDeployments) {
            if (deployerDeployment == null) {
                throw new ValidationException("Project deployer deployment can't be null");
            }
            this.validateDSSDeployerDeploymentIdentifier((DSSDeployerDeploymentIdentifier)deployerDeployment.dssProjectDeployerDeploymentIdentifier);
            this.validateDSSDeployerInfraIdentifier((DSSDeployerInfraIdentifier)deployerDeployment.dssProjectDeployerInfraIdentifier);
        }
        for (DSSAPIDeployerDeployment apiDeployment : deployerItems.apiDeployments) {
            if (apiDeployment == null) {
                throw new ValidationException("API deployer deployment can't be null");
            }
            this.validateDSSDeployerDeploymentIdentifier((DSSDeployerDeploymentIdentifier)apiDeployment.dssAPIDeployerDeploymentIdentifier);
            this.validateDSSDeployerInfraIdentifier((DSSDeployerInfraIdentifier)apiDeployment.dssAPIDeployerInfraIdentifier);
        }
    }

    private void validateDSSDeployerInfraIdentifier(DSSDeployerInfraIdentifier dssDeployerInfraIdentifier) {
        if (dssDeployerInfraIdentifier == null) {
            throw new ValidationException("dssDeployerInfraIdentifier can't be null");
        }
        if (StringUtils.isBlank((CharSequence)dssDeployerInfraIdentifier.nodeId)) {
            throw new ValidationException("dssDeployerInfraIdentifier.nodeId must be set");
        }
        if (StringUtils.isBlank((CharSequence)dssDeployerInfraIdentifier.infraId)) {
            throw new ValidationException("dssDeployerInfraIdentifier.infraId must be set");
        }
    }

    private void validateDSSDeployerDeploymentIdentifier(DSSDeployerDeploymentIdentifier dssDeployerDeploymentIdentifier) {
        if (dssDeployerDeploymentIdentifier == null) {
            throw new ValidationException("dssDeployerDeploymentIdentifier can't be null");
        }
        if (StringUtils.isBlank((CharSequence)dssDeployerDeploymentIdentifier.nodeId)) {
            throw new ValidationException("dssDeployerDeploymentIdentifier.nodeId must be set");
        }
        if (StringUtils.isBlank((CharSequence)dssDeployerDeploymentIdentifier.deploymentId)) {
            throw new ValidationException("dssDeployerDeploymentIdentifier.deploymentId must be set");
        }
    }

    private DSSArtifactContainer.DSSProjectDeployerInfraArtifactContainer mapProjectInfra_UncheckedIOException(DSSProjectDeployerInfra dssProjectDeployerInfra) {
        Artifact artifact = new Artifact();
        artifact.blueprintVersionId = SystemProvidedConstants.PROJECT_DEPLOYER_INFRA.getSingleDefaultBlueprintVersionId();
        EnrichedBlueprintVersion enrichedBlueprintVersion = this.getSystemDefaultBlueprintVersion_UncheckedIOException(SystemProvidedConstants.PROJECT_DEPLOYER_INFRA.getSingleDefaultBlueprintVersionId());
        artifact.name = dssProjectDeployerInfra.dssProjectDeployerInfraIdentifier.infraId;
        this.setMandatoryField(artifact, "infrastructure_id", dssProjectDeployerInfra.dssProjectDeployerInfraIdentifier.infraId);
        this.setMandatoryField(artifact, "node_id", dssProjectDeployerInfra.dssProjectDeployerInfraIdentifier.nodeId);
        this.addDetailsFields(artifact, enrichedBlueprintVersion, dssProjectDeployerInfra.details);
        return DSSArtifactContainer.buildProjectDeployerInfra(artifact);
    }

    private DSSArtifactContainer.DSSProjectDeployerDeploymentArtifactContainer mapProjectDeployment_UncheckedIOException(DSSProjectDeployerDeployment dssProjectDeployerDeployment) {
        Artifact artifact = new Artifact();
        artifact.blueprintVersionId = SystemProvidedConstants.PROJECT_DEPLOYER_DEPLOYMENT.getSingleDefaultBlueprintVersionId();
        EnrichedBlueprintVersion enrichedBlueprintVersion = this.getSystemDefaultBlueprintVersion_UncheckedIOException(SystemProvidedConstants.PROJECT_DEPLOYER_DEPLOYMENT.getSingleDefaultBlueprintVersionId());
        artifact.name = dssProjectDeployerDeployment.dssProjectDeployerDeploymentIdentifier.deploymentId;
        this.setMandatoryField(artifact, "deployment_id", dssProjectDeployerDeployment.dssProjectDeployerDeploymentIdentifier.deploymentId);
        this.setMandatoryField(artifact, "node_id", dssProjectDeployerDeployment.dssProjectDeployerDeploymentIdentifier.nodeId);
        this.setMandatoryField(artifact, "infrastructure_id", dssProjectDeployerDeployment.dssProjectDeployerInfraIdentifier.infraId);
        this.addDetailsFields(artifact, enrichedBlueprintVersion, dssProjectDeployerDeployment.details);
        return DSSArtifactContainer.buildProjectDeployerDeployment(artifact);
    }

    private DSSArtifactContainer.DSSAPIDeployerInfraArtifactContainer mapAPIInfra_UncheckedIOException(DSSAPIDeployerInfra dssAPIDeployerInfra) {
        Artifact artifact = new Artifact();
        artifact.blueprintVersionId = SystemProvidedConstants.API_DEPLOYER_INFRA.getSingleDefaultBlueprintVersionId();
        EnrichedBlueprintVersion enrichedBlueprintVersion = this.getSystemDefaultBlueprintVersion_UncheckedIOException(SystemProvidedConstants.API_DEPLOYER_INFRA.getSingleDefaultBlueprintVersionId());
        artifact.name = dssAPIDeployerInfra.dssAPIDeployerInfraIdentifier.infraId;
        this.setMandatoryField(artifact, "infrastructure_id", dssAPIDeployerInfra.dssAPIDeployerInfraIdentifier.infraId);
        this.setMandatoryField(artifact, "node_id", dssAPIDeployerInfra.dssAPIDeployerInfraIdentifier.nodeId);
        this.addDetailsFields(artifact, enrichedBlueprintVersion, dssAPIDeployerInfra.details);
        return DSSArtifactContainer.buildAPIDeployerInfra(artifact);
    }

    private DSSArtifactContainer.DSSAPIDeployerDeploymentArtifactContainer mapAPIDeployment_UncheckedIOException(DSSAPIDeployerDeployment dssAPIDeployerDeployment) {
        Artifact artifact = new Artifact();
        artifact.blueprintVersionId = SystemProvidedConstants.API_DEPLOYER_DEPLOYMENT.getSingleDefaultBlueprintVersionId();
        EnrichedBlueprintVersion enrichedBlueprintVersion = this.getSystemDefaultBlueprintVersion_UncheckedIOException(SystemProvidedConstants.API_DEPLOYER_DEPLOYMENT.getSingleDefaultBlueprintVersionId());
        artifact.name = dssAPIDeployerDeployment.dssAPIDeployerDeploymentIdentifier.deploymentId;
        this.setMandatoryField(artifact, "deployment_id", dssAPIDeployerDeployment.dssAPIDeployerDeploymentIdentifier.deploymentId);
        this.setMandatoryField(artifact, "node_id", dssAPIDeployerDeployment.dssAPIDeployerDeploymentIdentifier.nodeId);
        this.setMandatoryField(artifact, "infrastructure_id", dssAPIDeployerDeployment.dssAPIDeployerInfraIdentifier.infraId);
        this.addDetailsFields(artifact, enrichedBlueprintVersion, dssAPIDeployerDeployment.details);
        return DSSArtifactContainer.buildAPIDeployerDeployment(artifact);
    }

    private EnrichedBlueprintVersion getSystemDefaultBlueprintVersion_UncheckedIOException(BlueprintVersionId blueprintVersionId) {
        try {
            return this.systemProvidedCacheService.getSystemEnrichedDefaultBlueprintVersion(blueprintVersionId);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private static class SavedModelVersionMapper
    implements IDSSSavedModelVersionVisitor {
        protected BlueprintVersionId blueprintVersionId;
        protected Consumer<Artifact> specificFieldsConsumer = artifact -> {};
        protected List<DSSSavedModelVersionEvaluationMetricDatapoints> evaluationMetricDatapoints = null;

        private SavedModelVersionMapper() {
        }

        public void visit(DSSPredictionSavedModelVersion dssPredictionSavedModelVersion) {
            this.blueprintVersionId = SystemProvidedConstants.DATAIKU_SAVED_MODEL_VERSION.findByVersionId("bv.system.prediction");
            this.specificFieldsConsumer = artifact -> {
                List customMetrics = dssPredictionSavedModelVersion.customMetrics;
                if (CollectionUtils.isNotEmpty((Collection)customMetrics)) {
                    artifact.fields.put("custom_metric_names", customMetrics.stream().map(customMetric -> customMetric.customMetricName).collect(Collectors.toList()));
                    artifact.fields.put("custom_metric_initial_values", customMetrics.stream().map(customMetric -> customMetric.value).collect(Collectors.toList()));
                    artifact.fields.put("custom_metric_initial_std_values", customMetrics.stream().map(customMetric -> customMetric.valuestd).collect(Collectors.toList()));
                }
            };
            this.evaluationMetricDatapoints = dssPredictionSavedModelVersion.evaluationMetrics;
        }

        public void visit(DSSClusteringSavedModelVersion dssClusteringSavedModelVersion) {
            this.blueprintVersionId = SystemProvidedConstants.DATAIKU_SAVED_MODEL_VERSION.findByVersionId("bv.system.clustering");
        }

        public void visit(DSSFineTuningSavedModelVersion dssFineTuningSavedModelVersion) {
            this.blueprintVersionId = SystemProvidedConstants.DATAIKU_SAVED_MODEL_VERSION.findByVersionId("bv.system.fine_tuning");
        }

        public void visit(DSSAgentSavedModelVersion dssAgentSavedModelVersion) {
            this.blueprintVersionId = SystemProvidedConstants.DATAIKU_SAVED_MODEL_VERSION.findByVersionId("bv.system.agent");
        }

        public void visit(DSSAugmentedSavedModelVersion dssAugmentedSavedModelVersion) {
            this.blueprintVersionId = SystemProvidedConstants.DATAIKU_SAVED_MODEL_VERSION.findByVersionId("bv.system.augmented");
        }
    }
}

