/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.gh.core.services.governance.utils;

import com.dataiku.gh.core.models.artifacts.Artifact;
import com.dataiku.gh.core.models.blueprints.BlueprintVersionId;
import com.dataiku.gh.core.models.governance.ArtifactAutoGovernanceConfiguration;
import com.dataiku.gh.core.models.governance.AutoGovernanceEffectiveAction;
import com.dataiku.gh.core.models.governance.IInputGovernanceSettingsVisitor;
import com.dataiku.gh.core.models.governance.InputGovernanceSettings;
import com.dataiku.gh.core.services.system.SystemProvidedConstants;
import com.dataiku.gh.core.services.validation.errors.ValidationException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;

public class GovernanceUtils {
    public static String getDefaultGoverningBlueprintIdForDSSArtifact(Artifact artifact) {
        if (SystemProvidedConstants.DATAIKU_PROJECT.matchBlueprint(artifact.blueprintVersionId.blueprintId)) {
            return SystemProvidedConstants.GOVERN_PROJECT.blueprintId;
        }
        if (SystemProvidedConstants.DATAIKU_BUNDLE.matchBlueprint(artifact.blueprintVersionId.blueprintId)) {
            return SystemProvidedConstants.GOVERN_BUNDLE.blueprintId;
        }
        if (SystemProvidedConstants.DATAIKU_DATASET.matchBlueprint(artifact.blueprintVersionId.blueprintId)) {
            return SystemProvidedConstants.GOVERN_DATASET.blueprintId;
        }
        if (SystemProvidedConstants.DATAIKU_SAVED_MODEL.matchBlueprint(artifact.blueprintVersionId.blueprintId)) {
            return SystemProvidedConstants.GOVERN_MODEL.blueprintId;
        }
        if (SystemProvidedConstants.DATAIKU_SAVED_MODEL_VERSION.matchBlueprint(artifact.blueprintVersionId.blueprintId)) {
            return SystemProvidedConstants.GOVERN_MODEL_VERSION.blueprintId;
        }
        throw new ValidationException("Not default governing BlueprintVersionId found for " + artifact.blueprintVersionId.blueprintId);
    }

    public static boolean isGoverned(Artifact artifact) {
        return StringUtils.isNotBlank((String)((String)artifact.fields.get("governed_by")));
    }

    public static boolean isHidden(Artifact artifact) {
        return Objects.equals(artifact.fields.get("hidden_in_governable_items_table"), true);
    }

    @Nullable
    public static BlueprintVersionId extractGoverningBlueprintVersion(InputGovernanceSettings inputGovernanceSettings) {
        final BlueprintVersionId[] dataikuItemBlueprintVersionId = new BlueprintVersionId[1];
        inputGovernanceSettings.accept(new IInputGovernanceSettingsVisitor(){

            @Override
            public void visit(InputGovernanceSettings.ProjectSettings governanceSettings) {
                dataikuItemBlueprintVersionId[0] = governanceSettings.blueprintVersionId;
            }

            @Override
            public void visit(InputGovernanceSettings.BundleSettings governanceSettings) {
                dataikuItemBlueprintVersionId[0] = governanceSettings.blueprintVersionId;
            }

            @Override
            public void visit(InputGovernanceSettings.ModelSettings governanceSettings) {
                dataikuItemBlueprintVersionId[0] = governanceSettings.blueprintVersionId;
            }

            @Override
            public void visit(InputGovernanceSettings.ModelVersionSettings governanceSettings) {
                dataikuItemBlueprintVersionId[0] = governanceSettings.blueprintVersionId;
            }
        });
        return dataikuItemBlueprintVersionId[0];
    }

    @Nullable
    public static Artifact extractPrefilledGovernArtifact(InputGovernanceSettings inputGovernanceSettings) {
        final Artifact[] prefilledGovernArtifact = new Artifact[1];
        inputGovernanceSettings.accept(new IInputGovernanceSettingsVisitor(){

            @Override
            public void visit(InputGovernanceSettings.ProjectSettings governanceSettings) {
                prefilledGovernArtifact[0] = governanceSettings.prefillArtifact;
            }

            @Override
            public void visit(InputGovernanceSettings.BundleSettings governanceSettings) {
                prefilledGovernArtifact[0] = governanceSettings.prefillArtifact;
            }

            @Override
            public void visit(InputGovernanceSettings.ModelSettings governanceSettings) {
                prefilledGovernArtifact[0] = governanceSettings.prefillArtifact;
            }

            @Override
            public void visit(InputGovernanceSettings.ModelVersionSettings governanceSettings) {
                prefilledGovernArtifact[0] = governanceSettings.prefillArtifact;
            }
        });
        return prefilledGovernArtifact[0];
    }

    public static AutoGovernanceEffectiveAction extractAction(InputGovernanceSettings inputGovernanceSettings) {
        final AutoGovernanceEffectiveAction[] action = new AutoGovernanceEffectiveAction[1];
        inputGovernanceSettings.accept(new IInputGovernanceSettingsVisitor(){

            @Override
            public void visit(InputGovernanceSettings.ProjectSettings governanceSettings) {
                action[0] = governanceSettings.action;
            }

            @Override
            public void visit(InputGovernanceSettings.ExistingProjectSettings governanceSettings) {
                action[0] = AutoGovernanceEffectiveAction.GOVERN;
            }

            @Override
            public void visit(InputGovernanceSettings.BundleSettings governanceSettings) {
                action[0] = governanceSettings.action;
            }

            @Override
            public void visit(InputGovernanceSettings.ModelSettings governanceSettings) {
                action[0] = governanceSettings.action;
            }

            @Override
            public void visit(InputGovernanceSettings.ModelVersionSettings governanceSettings) {
                action[0] = governanceSettings.action;
            }
        });
        return action[0];
    }

    @Nullable
    public static ArtifactAutoGovernanceConfiguration extractArtifactAutoGovernanceConfigurationToUpdate(InputGovernanceSettings inputGovernanceSettings) {
        final ArtifactAutoGovernanceConfiguration[] config = new ArtifactAutoGovernanceConfiguration[1];
        inputGovernanceSettings.accept(new IInputGovernanceSettingsVisitor(){

            @Override
            public void visit(InputGovernanceSettings.ProjectSettings governanceSettings) {
                config[0] = governanceSettings.projectAutoGovernanceConfiguration;
            }

            @Override
            public void visit(InputGovernanceSettings.ExistingProjectSettings governanceSettings) {
                config[0] = governanceSettings.projectAutoGovernanceConfiguration;
            }

            @Override
            public void visit(InputGovernanceSettings.ModelSettings governanceSettings) {
                config[0] = governanceSettings.modelAutoGovernanceConfiguration;
            }
        });
        return config[0];
    }

    public static boolean artifactIsGovernableWithAdvancedLicense(Artifact artifact) {
        BlueprintVersionId blueprintVersionId = artifact.blueprintVersionId;
        Object modelType = artifact.fields.get("model_type");
        return (!SystemProvidedConstants.DATAIKU_SAVED_MODEL.matchBlueprint(blueprintVersionId) || !(modelType instanceof String) || !org.apache.commons.lang3.StringUtils.equals((CharSequence)((String)modelType), (CharSequence)"LLM_GENERIC_RAW")) && (!SystemProvidedConstants.DATAIKU_SAVED_MODEL_VERSION.matchBlueprint(blueprintVersionId) || !SystemProvidedConstants.RESTRICTED_TO_ADVANCED_LICENSE_SAVED_MODEL_VERSIONS.contains(blueprintVersionId.versionId));
    }

    public static List<String> getDataikuItemChildrenIds(Artifact dataikuArtifact) {
        List<String> childrenFields = SystemProvidedConstants.DATAIKU_PROJECT.matchBlueprint(dataikuArtifact.blueprintVersionId) ? List.of("dataiku_bundles", "dataiku_saved_models") : (SystemProvidedConstants.DATAIKU_SAVED_MODEL.matchBlueprint(dataikuArtifact.blueprintVersionId) ? List.of("dataiku_saved_model_versions") : List.of());
        return childrenFields.stream().flatMap(field -> GovernanceUtils.safeReferencesKeys(dataikuArtifact, field).stream()).toList();
    }

    private static List<String> safeReferencesKeys(Artifact artifact, String fieldId) {
        return Optional.ofNullable(artifact.fields.get(fieldId)).filter(List.class::isInstance).map(m -> (List)m).map(l -> {
            l.removeIf(Objects::isNull);
            return l;
        }).filter(list -> list.isEmpty() || list.get(0) instanceof String).map(l -> l).orElse(new ArrayList());
    }
}

