/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.gh.core.services.import_export;

import com.dataiku.dip.DKUApp;
import com.dataiku.dip.utils.JSON;
import com.dataiku.gh.core.models.import_export.ExportedEntity;
import com.dataiku.gh.core.services.import_export.IExportedEntityMigrationConfigService;
import com.dataiku.gh.core.services.import_export.IExportedEntityMigrationService;
import com.dataiku.gh.core.services.validation.errors.ValidationException;
import com.dataiku.gh.core.utils.ValidatorUtils;
import com.google.common.annotations.VisibleForTesting;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ExportedEntityMigrationService
implements IExportedEntityMigrationService {
    private Map<Class<?>, Map<Long, EntityMigration>> migrationOnImportConfig;
    private static final long INITIAL_DSS_VERSION = 12199L;
    private final long currentDssVersion;

    @Autowired
    public ExportedEntityMigrationService(List<IExportedEntityMigrationConfigService> configServices) {
        this(Long.parseLong(DKUApp.getDSSVersion().conf_version), configServices);
    }

    @VisibleForTesting
    public ExportedEntityMigrationService(long currentDSSVersion, List<IExportedEntityMigrationConfigService> configServices) {
        this.currentDssVersion = currentDSSVersion;
        this.migrationOnImportConfig = configServices.stream().collect(Collectors.toMap(IExportedEntityMigrationConfigService::getTargetClass, IExportedEntityMigrationConfigService::getMigrationSteps));
    }

    @Override
    public <T> T unwrapAndMigrateExportedEntity(JsonObject object, Class<T> targetClass) throws IOException {
        return this.unwrapAndMigrateExportedEntity(object, targetClass, this.migrationOnImportConfig);
    }

    @VisibleForTesting
    protected <T> T unwrapAndMigrateExportedEntity(JsonObject object, Class<T> targetClass, Map<Class<?>, Map<Long, EntityMigration>> configurationMap) throws IOException {
        JsonObject entity;
        long version;
        if (ExportedEntity.matches(object)) {
            try {
                version = object.getAsJsonPrimitive("dssVersion").getAsLong();
            }
            catch (NumberFormatException e) {
                throw new ValidationException("Property 'dssVersion' can't be parsed as a Long");
            }
            entity = object.getAsJsonObject("entity");
        } else {
            version = 12199L;
            entity = object;
        }
        this.validateObjectVersion(version);
        if (configurationMap.containsKey(targetClass)) {
            entity = this.migrateToCurrent(version, entity, configurationMap.get(targetClass));
        }
        return (T)JSON.parse((JsonElement)entity, targetClass);
    }

    @Override
    public <T> ExportedEntity<T> wrapToExportedEntity(T entity) {
        return ExportedEntity.build(this.currentDssVersion, entity);
    }

    @VisibleForTesting
    protected JsonObject migrateToCurrent(Long fromVersion, JsonObject obj, Map<Long, EntityMigration> migrationMap) throws IOException {
        List allMigrationsToApply = migrationMap.keySet().stream().filter(version -> version > fromVersion).distinct().sorted(Long::compareTo).collect(Collectors.toList());
        Iterator iterator = allMigrationsToApply.iterator();
        while (iterator.hasNext()) {
            long version2 = (Long)iterator.next();
            obj = migrationMap.get(version2).migrate(obj);
        }
        return obj;
    }

    private void validateObjectVersion(long objectVersion) {
        ValidatorUtils.validateThat(objectVersion >= 12199L, "Invalid version for import (given: %s, expected >= %s)", objectVersion, 12199L);
        ValidatorUtils.validateThat(objectVersion <= this.currentDssVersion, "Invalid version for import (given: %s, expected <= %s)", objectVersion, this.currentDssVersion);
    }

    @FunctionalInterface
    public static interface EntityMigration {
        public JsonObject migrate(JsonObject var1) throws IOException;
    }
}

