/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.gh.core.services.mappers;

import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.utils.JSON;
import com.dataiku.gh.core.models.artifacts.Artifact;
import com.dataiku.gh.core.models.artifacts.ArtifactWorkflow;
import com.dataiku.gh.core.models.artifacts.ArtifactWorkflowStep;
import com.dataiku.gh.core.models.blueprints.Action;
import com.dataiku.gh.core.models.blueprints.BlueprintVersion;
import com.dataiku.gh.core.models.blueprints.StepDefinition;
import com.dataiku.gh.core.models.blueprints.WorkflowDefinition;
import com.dataiku.gh.core.models.blueprints.ui.UIDefinition;
import com.dataiku.gh.core.models.blueprints.ui.UIStepDefinition;
import com.dataiku.gh.core.models.blueprints.ui.View;
import com.dataiku.gh.core.models.enriched.EnrichedArtifact;
import com.dataiku.gh.core.models.enriched.EnrichedArtifactDetails;
import com.dataiku.gh.core.models.enriched.EnrichedArtifactWithoutPermissions;
import com.dataiku.gh.core.models.enriched.EnrichedBlueprint;
import com.dataiku.gh.core.models.enriched.EnrichedBlueprintVersion;
import com.dataiku.gh.core.models.fields.SourceType;
import com.dataiku.gh.core.models.fields.definitions.FieldDefinition;
import com.dataiku.gh.core.models.roles.AssignedRolesAndPermissionsCtx;
import com.dataiku.gh.core.models.roles.permissions.EffectivePermissionsItem;
import com.dataiku.gh.core.models.roles.permissions.FieldPermissionsItem;
import com.dataiku.gh.core.models.subscriptions.Subscription;
import com.dataiku.gh.core.models.ui.UIArtifact;
import com.dataiku.gh.core.models.ui.UIBlueprint;
import com.dataiku.gh.core.models.ui.UIBlueprintVersion;
import com.dataiku.gh.core.services.artifacts.IArtifactWorkflowService;
import com.dataiku.gh.core.services.artifacts.IArtifactsDataService;
import com.dataiku.gh.core.services.dss.status.IDSSIntegrationStatusService;
import com.dataiku.gh.core.services.mappers.IUIModelsMapperService;
import com.dataiku.gh.core.services.roles_and_permissions.ICheckPermissionsService;
import com.dataiku.gh.core.services.roles_and_permissions.helpers.UiIndexer;
import com.dataiku.gh.core.services.roles_and_permissions.helpers.ViewFilter;
import com.dataiku.gh.core.services.security.mappings.IUsersMappingsService;
import com.dataiku.gh.core.services.signoff.SignoffUtils;
import com.dataiku.gh.core.services.validation.errors.ValidationException;
import java.io.IOException;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class UIModelsMapperService
implements IUIModelsMapperService {
    @Autowired
    private ICheckPermissionsService checkPermissionsService;
    @Autowired
    private IUsersMappingsService usersMappingsService;
    @Autowired
    private IDSSIntegrationStatusService dssIntegrationStatusService;
    @Autowired
    private IArtifactWorkflowService artifactWorkflowService;
    @Autowired
    private IArtifactsDataService artifactsDataService;

    @Override
    public UIBlueprint checkReadAndMapEnrichedBlueprintToUIBlueprint(AssignedRolesAndPermissionsCtx assignedRolesAndPermissionsCtx, EnrichedBlueprint enrichedBlueprint) throws DKUSecurityException {
        this.checkPermissionsService.checkBlueprintReadPermission_NoLicenseCheck(assignedRolesAndPermissionsCtx.effectivePermissionsItem, enrichedBlueprint.blueprint.id);
        return UIBlueprint.build(enrichedBlueprint.blueprint, assignedRolesAndPermissionsCtx);
    }

    @Override
    public UIBlueprintVersion checkReadAndMapEnrichedBlueprintVersionToUIBlueprintVersion(boolean mayManageGovern, AssignedRolesAndPermissionsCtx assignedRolesAndPermissionsCtx, EnrichedBlueprintVersion enrichedBlueprintVersion) throws DKUSecurityException {
        return this.checkReadAndMapEnrichedBlueprintVersionToUIBlueprintVersion(mayManageGovern, assignedRolesAndPermissionsCtx, enrichedBlueprintVersion, null);
    }

    private UIBlueprintVersion checkReadAndMapEnrichedBlueprintVersionToUIBlueprintVersion(boolean mayManageGovern, AssignedRolesAndPermissionsCtx assignedRolesAndPermissionsCtx, EnrichedBlueprintVersion enrichedBlueprintVersion, @Nullable EnrichedArtifactWithoutPermissions enrichedArtifact) throws DKUSecurityException {
        this.checkPermissionsService.checkBlueprintVersionReadPermission_NoLicenseCheck(assignedRolesAndPermissionsCtx.effectivePermissionsItem, enrichedBlueprintVersion.blueprintVersion.id);
        AssignedRolesAndPermissionsCtx uiAssignedRolesAndPermissionsCtx = this.mapUIAssignedRolesAndPermissionsCtx(assignedRolesAndPermissionsCtx, enrichedBlueprintVersion.blueprintVersion);
        EffectivePermissionsItem uiEpi = uiAssignedRolesAndPermissionsCtx.effectivePermissionsItem;
        boolean hasWorkflowConditions = enrichedBlueprintVersion.blueprintVersion.workflowDefinition.hasConditions();
        boolean hasConditionalViews = enrichedBlueprintVersion.blueprintVersion.uiDefinition.hasConditionalViews();
        BlueprintVersion blueprintVersion = this.mapAndBuildBlueprintVersion(mayManageGovern, enrichedBlueprintVersion, uiEpi, enrichedArtifact);
        return UIBlueprintVersion.build(enrichedBlueprintVersion.blueprint, blueprintVersion, enrichedBlueprintVersion.blueprintVersionTrace, uiAssignedRolesAndPermissionsCtx, enrichedBlueprintVersion.signoffsConfigurations, hasWorkflowConditions, hasConditionalViews);
    }

    private BlueprintVersion mapAndBuildBlueprintVersion(boolean mayManageGovern, EnrichedBlueprintVersion enrichedBlueprintVersion, EffectivePermissionsItem uiEpi, @Nullable EnrichedArtifactWithoutPermissions enrichedArtifact) {
        String hierarchicalParentFieldId = null;
        if (StringUtils.isNotBlank((CharSequence)enrichedBlueprintVersion.blueprintVersion.hierarchicalParentFieldId) && this.checkPermissionsService.hasFieldReadPermission_NoLicenseCheck(uiEpi, enrichedBlueprintVersion.blueprintVersion.hierarchicalParentFieldId)) {
            hierarchicalParentFieldId = enrichedBlueprintVersion.blueprintVersion.hierarchicalParentFieldId;
        }
        HashMap<String, FieldDefinition> fieldDefinitions = new HashMap<String, FieldDefinition>();
        for (Map.Entry<String, FieldDefinition> entry : enrichedBlueprintVersion.blueprintVersion.fieldDefinitions.entrySet()) {
            if (!this.checkPermissionsService.hasFieldReadPermission_NoLicenseCheck(uiEpi, entry.getKey())) continue;
            fieldDefinitions.put((String)entry.getKey(), (FieldDefinition)entry.getValue());
        }
        ArrayList<StepDefinition> filteredStepDefinitions = new ArrayList<StepDefinition>();
        for (StepDefinition stepDefinition : enrichedBlueprintVersion.blueprintVersion.workflowDefinition.stepDefinitions) {
            if (stepDefinition.visibilityCondition != null) {
                StepDefinition sdCopy = (StepDefinition)JSON.deepCopy((Object)stepDefinition);
                sdCopy.visibilityCondition = null;
                filteredStepDefinitions.add(sdCopy);
                continue;
            }
            filteredStepDefinitions.add(stepDefinition);
        }
        UIDefinition uiDefinition = this.mapAndBuildUIDefinition(enrichedBlueprintVersion, uiEpi, enrichedArtifact);
        Map<String, Action> actions = enrichedBlueprintVersion.blueprintVersion.actions;
        if (!mayManageGovern) {
            actions = actions.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, v -> new Action(((Action)v.getValue()).name, ((Action)v.getValue()).description, null)));
        }
        return BlueprintVersion.build(enrichedBlueprintVersion.blueprintVersion.id, enrichedBlueprintVersion.blueprintVersion.name, fieldDefinitions, WorkflowDefinition.build(filteredStepDefinitions), mayManageGovern ? enrichedBlueprintVersion.blueprintVersion.logicalHookList : null, actions, hierarchicalParentFieldId, uiDefinition, enrichedBlueprintVersion.blueprintVersion.instructions);
    }

    private UIDefinition mapAndBuildUIDefinition(EnrichedBlueprintVersion enrichedBlueprintVersion, EffectivePermissionsItem uiEpi, @Nullable EnrichedArtifactWithoutPermissions enrichedArtifact) {
        UiIndexer uiIndexer = new UiIndexer();
        enrichedBlueprintVersion.blueprintVersion.accept(uiIndexer);
        Map<String, View> mutableViews = enrichedBlueprintVersion.blueprintVersion.uiDefinition.views.entrySet().stream().map(e -> {
            View mutableView = ViewFilter.filterReadableAndConditional((View)JSON.deepCopy((Object)((View)e.getValue())), (String)e.getKey(), uiEpi, enrichedArtifact, this.artifactsDataService);
            if (mutableView.viewComponent != null) {
                mutableView.viewComponent.cleanVisibilityCondition();
            }
            return new AbstractMap.SimpleEntry<String, View>((String)e.getKey(), mutableView);
        }).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        HashMap<String, UIStepDefinition> uiStepDefinitions = new HashMap<String, UIStepDefinition>();
        for (Map.Entry<String, UIStepDefinition> entry : enrichedBlueprintVersion.blueprintVersion.uiDefinition.uiStepDefinitions.entrySet()) {
            UIStepDefinition uiStepDefinition = new UIStepDefinition();
            uiStepDefinition.viewId = entry.getValue().viewId;
            uiStepDefinitions.put(entry.getKey(), uiStepDefinition);
        }
        return UIDefinition.build(mutableViews, uiStepDefinitions, enrichedBlueprintVersion.blueprintVersion.uiDefinition.artifactPageViewId);
    }

    private AssignedRolesAndPermissionsCtx mapUIAssignedRolesAndPermissionsCtx(AssignedRolesAndPermissionsCtx assignedRolesAndPermissionsCtx, BlueprintVersion blueprintVersion) {
        EffectivePermissionsItem effectivePermissionsItem = EffectivePermissionsItem.build(assignedRolesAndPermissionsCtx.effectivePermissionsItem.artifactPermissionsItem, assignedRolesAndPermissionsCtx.effectivePermissionsItem.systemLocked);
        effectivePermissionsItem.fieldPermissionsItems = new HashMap<String, FieldPermissionsItem>();
        for (Map.Entry<String, FieldDefinition> fieldDefinitionEntry : blueprintVersion.fieldDefinitions.entrySet()) {
            FieldPermissionsItem fpi = assignedRolesAndPermissionsCtx.effectivePermissionsItem.fieldPermissionsItems.get(fieldDefinitionEntry.getKey());
            if (fpi != null && fpi.hasReadPermission()) {
                effectivePermissionsItem.fieldPermissionsItems.put(fieldDefinitionEntry.getKey(), fpi);
                continue;
            }
            if (!this.checkPermissionsService.hasArtifactAdminPermission_NoLicenseCheck(assignedRolesAndPermissionsCtx.effectivePermissionsItem)) continue;
            effectivePermissionsItem.fieldPermissionsItems.put(fieldDefinitionEntry.getKey(), FieldPermissionsItem.buildWithAllPermissions());
        }
        return AssignedRolesAndPermissionsCtx.build(assignedRolesAndPermissionsCtx.assignedRoles, effectivePermissionsItem);
    }

    @Override
    public UIArtifact checkReadAndMapEnrichedArtifactToUIArtifact(boolean mayManageGovern, AssignedRolesAndPermissionsCtx assignedRolesAndPermissionsCtx, EnrichedArtifactWithoutPermissions enrichedArtifact, @Nullable Subscription.SubscriptionLevel subscriptionLevel) throws IOException, DKUSecurityException {
        this.checkPermissionsService.checkArtifactReadPermission_NoLicenseCheck(assignedRolesAndPermissionsCtx.effectivePermissionsItem, enrichedArtifact.artifact.id);
        EnrichedBlueprintVersion enrichedBlueprintVersion = new EnrichedBlueprintVersion();
        enrichedBlueprintVersion.blueprint = enrichedArtifact.blueprint;
        enrichedBlueprintVersion.blueprintVersion = enrichedArtifact.blueprintVersion;
        enrichedBlueprintVersion.blueprintVersionTrace = enrichedArtifact.blueprintVersionTrace;
        enrichedBlueprintVersion.blueprintRoleAssignments = null;
        enrichedBlueprintVersion.blueprintPermissions = null;
        enrichedBlueprintVersion.signoffsConfigurations = null;
        UIBlueprintVersion uiBlueprintVersion = this.checkReadAndMapEnrichedBlueprintVersionToUIBlueprintVersion(mayManageGovern, assignedRolesAndPermissionsCtx, enrichedBlueprintVersion, enrichedArtifact);
        UIArtifact uiArtifact = new UIArtifact();
        uiArtifact.assignedRolesAndPermissionsCtx = uiBlueprintVersion.assignedRolesAndPermissionsCtx;
        uiArtifact.blueprint = uiBlueprintVersion.blueprint;
        uiArtifact.blueprintVersion = uiBlueprintVersion.blueprintVersion;
        uiArtifact.blueprintVersionTrace = uiBlueprintVersion.blueprintVersionTrace;
        uiArtifact.signoffs = enrichedArtifact.signoffs;
        uiArtifact.subscriptionLevel = subscriptionLevel;
        uiArtifact.uiBlueprintVersionDetails.hasConditionalWorkflow = uiBlueprintVersion.uiBlueprintVersionDetails.hasConditionalWorkflow;
        uiArtifact.uiBlueprintVersionDetails.hasConditionalView = uiBlueprintVersion.uiBlueprintVersionDetails.hasConditionalView;
        uiArtifact.artifact = this.mapArtifactToPermissionFilteredArtifact(uiArtifact.assignedRolesAndPermissionsCtx, enrichedArtifact);
        this.usersMappingsService.setUserGroupGlobalAPIKeyInfoToUIArtifact(uiArtifact, enrichedArtifact.enrichedArtifactDetails);
        this.dssIntegrationStatusService.setDataikuLinkToUIArtifact(uiArtifact, enrichedArtifact);
        uiArtifact.artifact.status.stepId = uiArtifact.artifact.getLegacyStepId(this.artifactWorkflowService.computeVisibleArtifactWorkflowSteps(enrichedArtifact));
        return uiArtifact;
    }

    private Artifact mapArtifactToPermissionFilteredArtifact(AssignedRolesAndPermissionsCtx assignedRolesAndPermissionsCtx, EnrichedArtifactWithoutPermissions enrichedArtifact) {
        Artifact filteredArtifact = new Artifact();
        filteredArtifact.id = enrichedArtifact.artifact.id;
        filteredArtifact.blueprintVersionId = enrichedArtifact.artifact.blueprintVersionId;
        filteredArtifact.name = enrichedArtifact.artifact.name;
        filteredArtifact.status = enrichedArtifact.artifact.status;
        filteredArtifact.attachments = enrichedArtifact.artifact.attachments;
        filteredArtifact.fields = new HashMap<String, Object>();
        for (Map.Entry<String, Object> entry : enrichedArtifact.artifact.fields.entrySet()) {
            if (!this.checkPermissionsService.hasFieldReadPermission_NoLicenseCheck(assignedRolesAndPermissionsCtx.effectivePermissionsItem, entry.getKey())) continue;
            filteredArtifact.fields.put(entry.getKey(), entry.getValue());
        }
        filteredArtifact.workflow = this.mapVisibleWorkflowToFullWorkflowState(enrichedArtifact, assignedRolesAndPermissionsCtx.effectivePermissionsItem);
        return filteredArtifact;
    }

    private ArtifactWorkflow mapVisibleWorkflowToFullWorkflowState(EnrichedArtifactWithoutPermissions enrichedArtifact, EffectivePermissionsItem epi) {
        HashMap<String, ArtifactWorkflowStep> filteredSteps = new HashMap<String, ArtifactWorkflowStep>();
        Set<String> visibleStepIds = this.artifactWorkflowService.computeVisibleArtifactWorkflowStepIds(enrichedArtifact);
        for (StepDefinition stepDefinition : enrichedArtifact.blueprintVersion.workflowDefinition.stepDefinitions) {
            boolean isVisible = visibleStepIds.contains(stepDefinition.id);
            ArtifactWorkflowStep existingStep = enrichedArtifact.artifact.workflow.steps.get(stepDefinition.id);
            if (existingStep == null) {
                filteredSteps.put(stepDefinition.id, ArtifactWorkflowStep.build(ArtifactWorkflowStep.StepStatus.NOT_STARTED, isVisible));
                continue;
            }
            if (existingStep.isOngoing() && !isVisible) {
                filteredSteps.put(stepDefinition.id, ArtifactWorkflowStep.build(ArtifactWorkflowStep.StepStatus.NOT_STARTED, isVisible));
                continue;
            }
            filteredSteps.put(stepDefinition.id, ArtifactWorkflowStep.build(existingStep.status, isVisible));
        }
        ArtifactWorkflow artifactWorkflow = new ArtifactWorkflow();
        artifactWorkflow.steps = filteredSteps;
        return artifactWorkflow;
    }

    @Override
    public EnrichedArtifact buildEnrichedArtifactFromInputArtifactForCreation(AssignedRolesAndPermissionsCtx assignedRolesAndPermissionsCtx, EnrichedBlueprintVersion enrichedBlueprintVersion, Artifact inputArtifact) throws DKUSecurityException {
        Artifact wholeArtifact = this.buildNewWholeArtifact(inputArtifact, enrichedBlueprintVersion.blueprintVersion, assignedRolesAndPermissionsCtx, fieldId -> null, true, false);
        EnrichedArtifact enrichedArtifact = EnrichedArtifact.build(enrichedBlueprintVersion.blueprint, enrichedBlueprintVersion.blueprintVersion, enrichedBlueprintVersion.blueprintVersionTrace, enrichedBlueprintVersion.blueprintRoleAssignments, null, enrichedBlueprintVersion.blueprintPermissions, wholeArtifact, SignoffUtils.buildInitialSignoffsFromConfig(wholeArtifact.id, enrichedBlueprintVersion.signoffsConfigurations), EnrichedArtifactDetails.build(null, null, null));
        enrichedArtifact.artifact.workflow = this.artifactWorkflowService.initializeWorkflow(enrichedArtifact);
        return enrichedArtifact;
    }

    @Override
    public EnrichedArtifact buildEnrichedArtifactFromInputArtifactForSave(AssignedRolesAndPermissionsCtx assignedRolesAndPermissionsCtx, EnrichedArtifact enrichedArtifact, Artifact inputArtifact, boolean forSave) throws DKUSecurityException {
        Artifact wholeArtifact = this.buildNewWholeArtifact(inputArtifact, enrichedArtifact.blueprintVersion, assignedRolesAndPermissionsCtx, fieldId -> enrichedArtifact.artifact.fields.get(fieldId), false, forSave);
        wholeArtifact.workflow = this.artifactWorkflowService.prepareWorkflowForSaving(enrichedArtifact, wholeArtifact, forSave);
        return EnrichedArtifact.build(enrichedArtifact.blueprint, enrichedArtifact.blueprintVersion, enrichedArtifact.blueprintVersionTrace, enrichedArtifact.blueprintRoleAssignments, enrichedArtifact.artifactRoleAssignments, enrichedArtifact.blueprintPermissions, wholeArtifact, enrichedArtifact.signoffs, enrichedArtifact.enrichedArtifactDetails);
    }

    private Artifact buildNewWholeArtifact(Artifact inputArtifact, BlueprintVersion blueprintVersion, AssignedRolesAndPermissionsCtx assignedRolesAndPermissionsCtx, Function<String, Object> previousFieldValueOrNullGetter, boolean isCreation, boolean forSave) throws DKUSecurityException {
        Artifact wholeArtifact = new Artifact();
        wholeArtifact.id = inputArtifact.id;
        wholeArtifact.blueprintVersionId = inputArtifact.blueprintVersionId;
        wholeArtifact.name = inputArtifact.name;
        wholeArtifact.status = inputArtifact.status;
        wholeArtifact.attachments = inputArtifact.attachments;
        wholeArtifact.fields = new HashMap<String, Object>();
        wholeArtifact.workflow = inputArtifact.workflow;
        for (String string : inputArtifact.fields.keySet()) {
            if (blueprintVersion.fieldDefinitions.containsKey(string) && this.checkPermissionsService.hasFieldReadPermission_NoLicenseCheck(assignedRolesAndPermissionsCtx.effectivePermissionsItem, string)) continue;
            throw new ValidationException("Field `" + string + "` not found for artifact with id `" + inputArtifact.id + "`");
        }
        for (Map.Entry entry : blueprintVersion.fieldDefinitions.entrySet()) {
            String fieldId = (String)entry.getKey();
            FieldDefinition fieldDefinition = (FieldDefinition)entry.getValue();
            Object previousFieldValueOrNull = previousFieldValueOrNullGetter.apply(fieldId);
            Object userProvidedFieldValueOrNull = inputArtifact.fields.get(fieldId);
            boolean isStoredField = fieldDefinition.sourceType == SourceType.STORE;
            boolean hasFieldReadPermission = this.checkPermissionsService.hasFieldReadPermission_NoLicenseCheck(assignedRolesAndPermissionsCtx.effectivePermissionsItem, fieldId);
            if (isStoredField && hasFieldReadPermission) {
                if (!Objects.equals(userProvidedFieldValueOrNull, previousFieldValueOrNull)) {
                    if (isCreation) {
                        this.checkPermissionsService.checkFieldWritePermissionForCreate_NoLicenseCheck(assignedRolesAndPermissionsCtx.effectivePermissionsItem, fieldId);
                    } else {
                        this.checkPermissionsService.checkFieldWritePermissionForWrite_NoLicenseCheck(assignedRolesAndPermissionsCtx.effectivePermissionsItem, fieldId);
                    }
                }
                if (userProvidedFieldValueOrNull == null) continue;
                wholeArtifact.fields.put(fieldId, userProvidedFieldValueOrNull);
                continue;
            }
            if (!forSave && !isStoredField && hasFieldReadPermission) {
                if (userProvidedFieldValueOrNull == null) continue;
                wholeArtifact.fields.put(fieldId, userProvidedFieldValueOrNull);
                continue;
            }
            if (previousFieldValueOrNull == null) continue;
            wholeArtifact.fields.put(fieldId, previousFieldValueOrNull);
        }
        return wholeArtifact;
    }
}

