/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.gh.core.services.user_config;

import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.server.controllers.NotFoundException;
import com.dataiku.gh.core.models.user_config.PageConfiguration;
import com.dataiku.gh.core.models.user_config.SavedArtifactFilterConfiguration;
import com.dataiku.gh.core.models.user_config.UserConfiguration;
import com.dataiku.gh.core.services.user_config.IUserConfigurationDataService;
import com.dataiku.gh.core.services.user_config.IUserConfigurationService;
import com.dataiku.gh.core.services.utils.GHReadonlyTransaction;
import com.dataiku.gh.core.services.utils.GHWriteTransaction;
import com.dataiku.gh.core.services.validation.IUserConfigurationValidationService;
import com.dataiku.gh.core.services.validation.errors.ValidationException;
import com.dataiku.gh.core.storage.custom_pages.ICustomPageDAO;
import com.dataiku.gh.server.services.licensing.LicenseEnforcementService;
import java.io.IOException;
import java.util.Map;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class UserConfigurationService
implements IUserConfigurationService {
    @Autowired
    private IUserConfigurationDataService userConfigurationDataService;
    @Autowired
    private LicenseEnforcementService licenseEnforcementService;
    @Autowired
    private IUserConfigurationValidationService userConfigValidationService;
    @Autowired
    private ICustomPageDAO customPageDAO;

    @Override
    @GHReadonlyTransaction
    public UserConfiguration getUserConfiguration(AuthCtx authCtx) throws IOException, DKUSecurityException {
        this.licenseEnforcementService.checkReadGovernAllowed(authCtx);
        String userIdentifier = authCtx.getIdentifier();
        return this.getUserConfiguration_NoLicenseCheck(userIdentifier);
    }

    private UserConfiguration getUserConfiguration_NoLicenseCheck(String userIdentifier) throws IOException {
        return Optional.ofNullable(this.userConfigurationDataService.getUserConfigurationOrNull(userIdentifier)).orElse(new UserConfiguration(userIdentifier));
    }

    @Override
    @GHWriteTransaction
    public UserConfiguration addPageFilter(AuthCtx authCtx, String pageId, SavedArtifactFilterConfiguration savedArtifactFilterConfiguration) throws IOException, DKUSecurityException {
        Map<String, SavedArtifactFilterConfiguration> selectedPageFilters;
        this.licenseEnforcementService.checkReadGovernAllowed(authCtx);
        this.userConfigValidationService.validateFilterConfiguration(savedArtifactFilterConfiguration);
        if (!this.customPageDAO.exists(pageId)) {
            throw new NotFoundException("Cannot find customPage: " + pageId);
        }
        String userIdentifier = authCtx.getIdentifier();
        this.userConfigurationDataService.lockUserConfiguration(userIdentifier);
        UserConfiguration userConfig = this.getUserConfiguration_NoLicenseCheck(userIdentifier);
        if (!userConfig.pages.containsKey(pageId) || userConfig.pages.get((Object)pageId).advancedFilters.isEmpty()) {
            userConfig.pages.put(pageId, new PageConfiguration());
        }
        if ((selectedPageFilters = userConfig.pages.get((Object)pageId).advancedFilters).containsKey(savedArtifactFilterConfiguration.id)) {
            throw new ValidationException("Page `" + pageId + "` already contains filter with id: " + savedArtifactFilterConfiguration.id);
        }
        selectedPageFilters.put(savedArtifactFilterConfiguration.id, savedArtifactFilterConfiguration);
        return this.userConfigurationDataService.upsertUserConfiguration(userConfig);
    }

    @Override
    @GHWriteTransaction
    public UserConfiguration editPageFilter(AuthCtx authCtx, String pageId, SavedArtifactFilterConfiguration savedArtifactFilterConfiguration) throws IOException, DKUSecurityException {
        this.licenseEnforcementService.checkReadGovernAllowed(authCtx);
        this.userConfigValidationService.validateFilterConfiguration(savedArtifactFilterConfiguration);
        String userIdentifier = authCtx.getIdentifier();
        this.userConfigurationDataService.lockUserConfiguration(userIdentifier);
        UserConfiguration userConfig = this.getUserConfiguration_NoLicenseCheck(userIdentifier);
        if (!userConfig.pages.containsKey(pageId) || userConfig.pages.get((Object)pageId).advancedFilters.isEmpty()) {
            throw new ValidationException("Page `" + pageId + "` does not contain filters to edit");
        }
        Map<String, SavedArtifactFilterConfiguration> selectedPageFilters = userConfig.pages.get((Object)pageId).advancedFilters;
        if (!selectedPageFilters.containsKey(savedArtifactFilterConfiguration.id)) {
            throw new ValidationException("Page `" + pageId + "` does not contain filter with id: " + savedArtifactFilterConfiguration.id);
        }
        selectedPageFilters.put(savedArtifactFilterConfiguration.id, savedArtifactFilterConfiguration);
        return this.userConfigurationDataService.upsertUserConfiguration(userConfig);
    }

    @Override
    @GHWriteTransaction
    public void deletePageFilter(AuthCtx authCtx, String pageId, String filterConfigurationId) throws IOException, DKUSecurityException {
        this.licenseEnforcementService.checkReadGovernAllowed(authCtx);
        String userIdentifier = authCtx.getIdentifier();
        this.userConfigurationDataService.lockUserConfiguration(userIdentifier);
        UserConfiguration userConfig = this.getUserConfiguration_NoLicenseCheck(userIdentifier);
        if (!userConfig.pages.containsKey(pageId) || userConfig.pages.get((Object)pageId).advancedFilters.isEmpty()) {
            throw new ValidationException("Page `" + pageId + "` does not contain filters to delete");
        }
        Map<String, SavedArtifactFilterConfiguration> selectedPageFilters = userConfig.pages.get((Object)pageId).advancedFilters;
        if (!selectedPageFilters.containsKey(filterConfigurationId)) {
            throw new ValidationException("Cannot find filter `" + filterConfigurationId + "` to delete on page: `" + pageId + "`");
        }
        selectedPageFilters.remove(filterConfigurationId);
        this.userConfigurationDataService.upsertUserConfiguration(userConfig);
    }
}

