/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.gh.core.services.utils;

import com.dataiku.dip.utils.DKULogger;
import com.dataiku.gh.core.context.GovernActionContext;
import com.dataiku.gh.core.context.TransactionLogContext;
import com.dataiku.gh.core.services.utils.ITransactionHandler;
import com.dataiku.gh.core.services.utils.ITransactionScope;
import java.time.OffsetDateTime;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.TransactionDefinition;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.annotation.Isolation;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.support.DefaultTransactionDefinition;

@Service
public class TransactionHandler
implements ITransactionHandler {
    @Autowired
    private PlatformTransactionManager txManager;
    private static DKULogger logger = DKULogger.getLogger((String)"gh.services.db-transaction-handler");

    @Override
    public ITransactionScope openNewWriteTransaction() {
        DefaultTransactionDefinition td = new DefaultTransactionDefinition();
        td.setReadOnly(false);
        td.setIsolationLevel(Isolation.READ_COMMITTED.value());
        td.setPropagationBehavior(Propagation.REQUIRES_NEW.value());
        return new TransactionScopeImpl(this.txManager, (TransactionDefinition)td, true);
    }

    @Override
    public ITransactionScope openNewReadTransaction() {
        DefaultTransactionDefinition td = new DefaultTransactionDefinition();
        td.setReadOnly(true);
        td.setIsolationLevel(Isolation.REPEATABLE_READ.value());
        td.setPropagationBehavior(Propagation.REQUIRES_NEW.value());
        return new TransactionScopeImpl(this.txManager, (TransactionDefinition)td, true);
    }

    private static class TransactionScopeImpl
    implements ITransactionScope {
        private final TransactionStatus status;
        private final PlatformTransactionManager txManager;
        private final boolean newTransaction;
        private final GovernActionContext.ContextContainer previousContextContainer;
        private final TransactionLogContext.TransactionLogContextContainer transactionLogContextContainer;

        public TransactionScopeImpl(PlatformTransactionManager txManager, TransactionDefinition transactionDefinition, boolean forceNewContext) {
            boolean localNewTransaction = false;
            GovernActionContext.ContextContainer localPreviousContextContainer = null;
            if (!transactionDefinition.isReadOnly()) {
                if (forceNewContext) {
                    localPreviousContextContainer = GovernActionContext.removeContext();
                    GovernActionContext.attachNewContext(localPreviousContextContainer.actionType, localPreviousContextContainer.authCtx);
                }
                GovernActionContext.ContextContainer context = GovernActionContext.getContext();
                if (context.transactionStart == null) {
                    localNewTransaction = true;
                    context.transactionStart = OffsetDateTime.now();
                }
            }
            this.newTransaction = localNewTransaction;
            this.previousContextContainer = localPreviousContextContainer;
            this.txManager = txManager;
            this.status = txManager.getTransaction(transactionDefinition);
            try {
                this.transactionLogContextContainer = forceNewContext ? TransactionLogContext.newTransaction(transactionDefinition.isReadOnly()) : TransactionLogContext.newTransactionOrKeepExisting(transactionDefinition.isReadOnly());
            }
            catch (Exception e) {
                this.close();
                throw e;
            }
        }

        @Override
        public void commit() {
            this.txManager.commit(this.status);
        }

        @Override
        public void close() {
            try {
                if (this.transactionLogContextContainer != null) {
                    this.transactionLogContextContainer.close();
                }
            }
            catch (Exception e) {
                logger.error((Object)"Failed to close the transaction log context", (Throwable)e);
            }
            if (!this.status.isCompleted()) {
                this.txManager.rollback(this.status);
            }
            if (this.newTransaction && !this.status.isReadOnly()) {
                GovernActionContext.ContextContainer context = GovernActionContext.getContext();
                context.transactionStart = null;
                if (this.previousContextContainer != null) {
                    context.close();
                    GovernActionContext.attachContext(this.previousContextContainer);
                }
            }
        }
    }
}

