/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.gh.core.services.validation.validators;

import com.dataiku.gh.core.models.blueprints.Blueprint;
import com.dataiku.gh.core.services.validation.errors.ValidationException;
import com.dataiku.gh.core.utils.IdentifiersUtils;
import com.dataiku.gh.core.visitors.IBlueprintVisitor;
import org.apache.commons.lang3.StringUtils;

public class BlueprintValidator
implements IBlueprintVisitor {
    @Override
    public void visit(Blueprint blueprint) {
        if (!IdentifiersUtils.isValidBlueprintId(blueprint.id)) {
            throw new ValidationException("Invalid blueprint ID: " + blueprint.id);
        }
        if (StringUtils.isBlank((CharSequence)blueprint.name)) {
            throw new ValidationException("Blueprint name is required for blueprint with ID: " + blueprint.id);
        }
        if (StringUtils.isBlank((CharSequence)blueprint.icon)) {
            throw new ValidationException("Blueprint icon is required for blueprint with ID: " + blueprint.id);
        }
        if (StringUtils.isBlank((CharSequence)blueprint.color)) {
            throw new ValidationException("Blueprint color is required for blueprint with ID: " + blueprint.id);
        }
    }
}

