/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.gh.core.storage.sql.history;

import com.dataiku.dip.exceptions.DataStoreIOException;
import com.dataiku.dip.server.controllers.NotFoundException;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.gh.core.models.enriched.EnrichedArtifactWithoutPermissions;
import com.dataiku.gh.core.models.history.HistoryField;
import com.dataiku.gh.core.models.history.RevisionType;
import com.dataiku.gh.core.models.history.artifact.ArtifactAndHistoryActionEntry;
import com.dataiku.gh.core.models.history.artifact.ArtifactFullHistoryAction;
import com.dataiku.gh.core.models.history.timeline.ArtifactTimelineSearchConfig;
import com.dataiku.gh.core.models.history.timeline.TimelinePagination;
import com.dataiku.gh.core.services.utils.GHReadonlyTransaction;
import com.dataiku.gh.core.storage.history.IHistorySearchDAO;
import com.dataiku.gh.core.storage.sql.AbstractPostgreSQLClient;
import com.dataiku.gh.core.storage.sql.history.ArtifactFullHistoryActionRowMapper;
import com.dataiku.gh.core.storage.sql.history.ArtifactPartialHistoryActionRowMapper;
import com.dataiku.gh.core.storage.sql.history.EnrichedArtifactWithoutPermissionsAtTimestampRowMapper;
import com.dataiku.gh.core.storage.sql.history.HistoryFieldRowMapper;
import com.dataiku.gh.core.storage.sql.model.QArtifactsAtTimestamp;
import com.dataiku.gh.core.storage.sql.model.QArtifactsHistory;
import com.dataiku.gh.core.storage.sql.model.QArtifactsTimelineAtAction;
import com.dataiku.gh.core.storage.sql.model.QBlueprintVersionsHistory;
import com.dataiku.gh.core.storage.sql.model.QPartialArtifactGlobalTimeline;
import com.dataiku.gh.core.storage.sql.utils.QueryBuilderUtils;
import com.dataiku.gh.core.utils.ValidatorUtils;
import com.google.common.collect.Lists;
import com.querydsl.core.Tuple;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.OrderSpecifier;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.SubQueryExpression;
import com.querydsl.core.types.dsl.Expressions;
import com.querydsl.core.types.dsl.PathBuilder;
import com.querydsl.core.types.dsl.SimpleExpression;
import com.querydsl.sql.SQLExpressions;
import com.querydsl.sql.SQLQuery;
import java.io.IOException;
import java.time.Instant;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.dao.DataAccessException;
import org.springframework.dao.IncorrectResultSizeDataAccessException;
import org.springframework.stereotype.Service;

@Service
public class HistorySearchDAO
extends AbstractPostgreSQLClient
implements IHistorySearchDAO {
    private static final DKULogger logger = DKULogger.getLogger((String)"gh.storage.history");
    private static final String BEFORE_PREFIX = "before";
    private static final String AFTER_PREFIX = "after";
    private static final String HISTORY_FIELD_FIELD_ID = "field_id";
    private static final String HISTORY_FIELD_LABELS = "labels";

    @Override
    @GHReadonlyTransaction
    public Stream<ArtifactAndHistoryActionEntry> searchArtifactPartialHistoryActionStream(ArtifactTimelineSearchConfig artifactTimelineSearchConfig, TimelinePagination timelinePagination) throws IOException {
        try {
            List<String> blueprintIds;
            SQLQuery query = (SQLQuery)this.sqlQueryFactory.select(new Expression[]{QPartialArtifactGlobalTimeline.partialArtifactGlobalTimeline.historyActionId, QPartialArtifactGlobalTimeline.partialArtifactGlobalTimeline.artifactId, QPartialArtifactGlobalTimeline.partialArtifactGlobalTimeline.foreignEntity}).from((Expression)QPartialArtifactGlobalTimeline.partialArtifactGlobalTimeline);
            Long actionId = artifactTimelineSearchConfig.actionId;
            if (actionId != null) {
                query = (SQLQuery)query.where((Predicate)QPartialArtifactGlobalTimeline.partialArtifactGlobalTimeline.historyActionId.eq((Object)actionId));
            }
            if (timelinePagination.lastActionId != null) {
                query = (SQLQuery)query.where((Predicate)QPartialArtifactGlobalTimeline.partialArtifactGlobalTimeline.historyActionId.lt((Number)timelinePagination.lastActionId));
            }
            if (CollectionUtils.isNotEmpty(artifactTimelineSearchConfig.artifactIds)) {
                query = (SQLQuery)query.where((Predicate)QPartialArtifactGlobalTimeline.partialArtifactGlobalTimeline.artifactId.in(artifactTimelineSearchConfig.artifactIds));
            }
            if (artifactTimelineSearchConfig.actionBeforeDate != null) {
                query = (SQLQuery)query.where((Predicate)QPartialArtifactGlobalTimeline.partialArtifactGlobalTimeline.maxRevisionTimestamp.before((Comparable)this.ofTimestamp(artifactTimelineSearchConfig.actionBeforeDate)));
            }
            if (artifactTimelineSearchConfig.actionAfterDate != null) {
                query = (SQLQuery)query.where((Predicate)QPartialArtifactGlobalTimeline.partialArtifactGlobalTimeline.maxRevisionTimestamp.after((Comparable)this.ofTimestamp(artifactTimelineSearchConfig.actionAfterDate)));
            }
            if (CollectionUtils.isNotEmpty(artifactTimelineSearchConfig.actionTypes)) {
                List actionsAsStrings = artifactTimelineSearchConfig.actionTypes.stream().map(action -> action.name()).collect(Collectors.toList());
                query = (SQLQuery)query.where((Predicate)QueryBuilderUtils.jsonString(QPartialArtifactGlobalTimeline.partialArtifactGlobalTimeline.historyActionJson, new String[]{"type"}).in(actionsAsStrings));
            }
            if (CollectionUtils.isNotEmpty(artifactTimelineSearchConfig.users)) {
                query = (SQLQuery)query.where((Predicate)QPartialArtifactGlobalTimeline.partialArtifactGlobalTimeline.historyActionUser.in(artifactTimelineSearchConfig.users));
            }
            if (CollectionUtils.isNotEmpty(blueprintIds = artifactTimelineSearchConfig.blueprintIds)) {
                PathBuilder blueprintIdPath = new PathBuilder(Tuple.class, "blueprint_id_subquery");
                SQLQuery blueprintIdQuery = (SQLQuery)((SQLQuery)this.sqlQueryFactory.select(new Expression[]{QArtifactsHistory.artifactsHistory.artifactId, QArtifactsHistory.artifactsHistory.artifactBlueprintId}).from((Expression)QArtifactsHistory.artifactsHistory)).orderBy(new OrderSpecifier[]{QArtifactsHistory.artifactsHistory.artifactId.desc(), QArtifactsHistory.artifactsHistory._revisionId.desc()});
                blueprintIdQuery = QueryBuilderUtils.distinctOn(blueprintIdQuery, QArtifactsHistory.artifactsHistory.artifactId);
                query = (SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)query.with((Path)blueprintIdPath, blueprintIdQuery)).leftJoin((EntityPath)blueprintIdPath)).on((Predicate)blueprintIdPath.get(QArtifactsHistory.artifactsHistory.artifactId).eq((Expression)QPartialArtifactGlobalTimeline.partialArtifactGlobalTimeline.artifactId))).where((Predicate)blueprintIdPath.get(QArtifactsHistory.artifactsHistory.artifactBlueprintId).in(blueprintIds));
            }
            if (StringUtils.isNotBlank((CharSequence)timelinePagination.lastInnerArtifactId)) {
                ValidatorUtils.validateThat(actionId != null, "Pagination on last inner artifactId cannot be set without filtering on actionId too", new Object[0]);
                PathBuilder baseQueryPath = new PathBuilder(Tuple.class, "base");
                PathBuilder rowNumberPath = new PathBuilder(Tuple.class, "rowNumber");
                String rowNumberColumn = "row_number";
                query = (SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)this.sqlQueryFactory.query().with((Path)baseQueryPath, (SubQueryExpression)query)).with((Path)rowNumberPath, (SubQueryExpression)SQLExpressions.select((Expression[])new Expression[]{QueryBuilderUtils.allStar(baseQueryPath), Expressions.numberTemplate(Long.class, (String)"row_number() over()", (Object[])new Object[0]).as(rowNumberColumn)}).from((Expression)baseQueryPath))).select(QueryBuilderUtils.allStar(rowNumberPath)).from((Expression)rowNumberPath)).where((Predicate)rowNumberPath.getComparable(rowNumberColumn, Long.class).gt((Expression)((SQLQuery)SQLExpressions.select((Expression)rowNumberPath.getComparable(rowNumberColumn, Long.class)).from((Expression)rowNumberPath)).where((Predicate)rowNumberPath.get(QPartialArtifactGlobalTimeline.partialArtifactGlobalTimeline.artifactId).eq((Object)timelinePagination.lastInnerArtifactId))));
            }
            return this.querydslJdbcTemplate.queryForStream(query, new ArtifactPartialHistoryActionRowMapper());
        }
        catch (DataAccessException e) {
            logger.error((Object)"Cannot reach Dataiku Govern database", (Throwable)e);
            throw new DataStoreIOException("Cannot reach Dataiku Govern database", (Throwable)e);
        }
    }

    @Override
    @GHReadonlyTransaction
    public Stream<ArtifactFullHistoryAction> listArtifactsHistoryOfAction(long actionId, List<String> artifactIds) throws IOException {
        try {
            ArtifactFullHistoryActionRowMapper rowMapper = new ArtifactFullHistoryActionRowMapper(AFTER_PREFIX, BEFORE_PREFIX);
            SQLQuery query = (SQLQuery)this.sqlQueryFactory.select(rowMapper.columns).from(QArtifactsTimelineAtAction.asFunctionExpression(actionId, artifactIds));
            return this.querydslJdbcTemplate.queryForStream(query, rowMapper);
        }
        catch (DataAccessException e) {
            logger.error((Object)"Cannot reach Dataiku Govern database", (Throwable)e);
            throw new DataStoreIOException("Cannot reach Dataiku Govern database", (Throwable)e);
        }
    }

    @Override
    @GHReadonlyTransaction
    public Stream<HistoryField> getHistoryFieldsStream(String artifactId) throws IOException {
        try {
            SQLQuery artifactQuery = (SQLQuery)((SQLQuery)((SQLQuery)this.sqlQueryFactory.from((Expression)QArtifactsHistory.artifactsHistory)).where((Predicate)QArtifactsHistory.artifactsHistory.artifactId.eq((Object)artifactId))).groupBy(new Expression[]{QArtifactsHistory.artifactsHistory.artifactBlueprintId, QArtifactsHistory.artifactsHistory.artifactVersionId});
            PathBuilder fieldDefinitionPath = new PathBuilder(Object.class, "field_definitions");
            SQLQuery fieldQuery = (SQLQuery)((SQLQuery)((SQLQuery)this.sqlQueryFactory.select(new Expression[]{QBlueprintVersionsHistory.blueprintVersionsHistory.blueprintVersionBlueprintId, QBlueprintVersionsHistory.blueprintVersionsHistory.blueprintVersionVersionId, fieldDefinitionPath.get("key").as(HISTORY_FIELD_FIELD_ID), QueryBuilderUtils.jsonAgg(QueryBuilderUtils.jsonString((Expression<Object>)fieldDefinitionPath.get("value"), "label"), null, true).as(HISTORY_FIELD_LABELS)}).from(new Expression[]{QBlueprintVersionsHistory.blueprintVersionsHistory, QueryBuilderUtils.jsonEach(QueryBuilderUtils.jsonObjectDefaultEmpty(QBlueprintVersionsHistory.blueprintVersionsHistory.blueprintVersionJson, new String[]{"fieldDefinitions"})).as((Path)fieldDefinitionPath)})).where((Predicate)Expressions.list((SimpleExpression[])new SimpleExpression[]{QBlueprintVersionsHistory.blueprintVersionsHistory.blueprintVersionBlueprintId, QBlueprintVersionsHistory.blueprintVersionsHistory.blueprintVersionVersionId}).in((SubQueryExpression)artifactQuery.select(new Expression[]{QArtifactsHistory.artifactsHistory.artifactBlueprintId, QArtifactsHistory.artifactsHistory.artifactVersionId})))).groupBy(new Expression[]{QBlueprintVersionsHistory.blueprintVersionsHistory.blueprintVersionBlueprintId, QBlueprintVersionsHistory.blueprintVersionsHistory.blueprintVersionVersionId, fieldDefinitionPath.get("key")});
            return this.querydslJdbcTemplate.queryForStream(fieldQuery, new HistoryFieldRowMapper(HISTORY_FIELD_FIELD_ID, HISTORY_FIELD_LABELS));
        }
        catch (DataAccessException e) {
            logger.error((Object)"Cannot reach Dataiku Govern database", (Throwable)e);
            throw new DataStoreIOException("Cannot reach Dataiku Govern database", (Throwable)e);
        }
    }

    @Override
    @GHReadonlyTransaction
    public EnrichedArtifactWithoutPermissions getLastKnownEnrichedArtifact(String artifactId) throws IOException {
        try {
            String revisionTypeDeleteAlias = "rev_type_delete";
            SQLQuery lastTimestamp = (SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)this.sqlQueryFactory.select(new Expression[]{QArtifactsHistory.artifactsHistory._revisionTimestamp, QueryBuilderUtils.jsonString(QArtifactsHistory.artifactsHistory._revisionJson, new String[]{"operation"}).eq((Object)RevisionType.DELETE.toString()).as("rev_type_delete")}).from((Expression)QArtifactsHistory.artifactsHistory)).where((Predicate)QArtifactsHistory.artifactsHistory.artifactId.eq((Object)artifactId))).orderBy(QArtifactsHistory.artifactsHistory._revisionTimestamp.desc())).limit(1L);
            PathBuilder lastTimestampPath = new PathBuilder(OffsetDateTime.class, "last_timestamp");
            EnrichedArtifactWithoutPermissionsAtTimestampRowMapper rowMapper = new EnrichedArtifactWithoutPermissionsAtTimestampRowMapper();
            SQLQuery lastKnownArtifactQuery = (SQLQuery)((SQLQuery)this.sqlQueryFactory.select(rowMapper.columns).from(new Expression[]{lastTimestamp.as((Path)lastTimestampPath), QArtifactsAtTimestamp.asFunctionExpression(QueryBuilderUtils.extractTimestampFromPath(lastTimestampPath.get(QArtifactsHistory.artifactsHistory._revisionTimestamp), Expressions.numberTemplate(Long.class, (String)"CASE WHEN {0} THEN {1s} ELSE {2s} END", (Object[])new Object[]{lastTimestampPath.get("rev_type_delete"), -1, 0})), (List<String>)Lists.newArrayList((Object[])new String[]{artifactId}))})).limit(1L);
            return this.querydslJdbcTemplate.queryForObject(lastKnownArtifactQuery, rowMapper);
        }
        catch (IncorrectResultSizeDataAccessException e) {
            throw new NotFoundException("Item has never existed: " + artifactId);
        }
        catch (DataAccessException e) {
            logger.error((Object)"Cannot reach Dataiku Govern database", (Throwable)e);
            throw new DataStoreIOException("Cannot reach Dataiku Govern database", (Throwable)e);
        }
    }

    private OffsetDateTime ofTimestamp(long timestamp) {
        return OffsetDateTime.ofInstant(Instant.ofEpochMilli(timestamp), ZoneOffset.UTC);
    }
}

