/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.gh.server.services;

import com.dataiku.dip.DKUApp;
import com.dataiku.dip.FeatureFlags;
import com.dataiku.dip.ProxySettings;
import com.dataiku.dip.dao.UsersActivityDAO;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.exceptions.UnauthorizedException;
import com.dataiku.dip.integrations.IntegrationChannel;
import com.dataiku.dip.license.LicenseStatusService;
import com.dataiku.dip.license.LicenseUtils;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.PasswordEncryptionService;
import com.dataiku.dip.security.SSOSettings;
import com.dataiku.dip.security.audit.AuditTrailService;
import com.dataiku.dip.server.notifications.DSSEvent;
import com.dataiku.dip.server.notifications.DSSEventListener;
import com.dataiku.dip.server.services.CloudStacksCloud;
import com.dataiku.dip.server.services.DeploymentMode;
import com.dataiku.dip.server.services.InstanceLicenseKind;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.server.services.UsageDataReporting;
import com.dataiku.dip.server.services.licensing.AbstractLicenseFeaturesStatusBuilder;
import com.dataiku.dip.server.services.licensing.LimitsStatusComputer;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.dataiku.dip.util.ApiKeyUtils;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.JSON;
import com.dataiku.dss.shadelib.org.apache.commons.io.FileUtils;
import com.dataiku.gh.ApplicationConfigurator;
import com.dataiku.gh.core.storage.sql.DatabaseConfiguration;
import com.dataiku.gh.dao.GeneralSettingsDAO;
import com.dataiku.gh.dao.UsersDAO;
import com.dataiku.gh.security.IPermissionsService;
import com.dataiku.gh.security.auth.UIAuthService;
import com.dataiku.gh.security.model.PublicUser;
import com.dataiku.gh.server.notifications.backend.GeneralSettingsChangedEvent;
import com.dataiku.gh.server.services.PubSubService;
import com.dataiku.gh.server.services.UsersService;
import com.dataiku.gh.server.services.licensing.LicenseEnforcementService;
import com.dataiku.gh.server.services.licensing.SAASInstanceService;
import com.dataiku.j2ts.annotations.UIModel;
import com.dataiku.j2ts.annotations.UINullable;
import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import com.zaxxer.hikari.HikariDataSource;
import jakarta.servlet.http.Cookie;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.PostConstruct;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class GeneralSettingsService {
    private static boolean justAfterRegister;
    @Autowired
    private GeneralSettingsDAO generalSettingsDAO;
    @Autowired
    private PubSubService pubSub;
    @Autowired
    private LicenseEnforcementService enforcementService;
    @Autowired
    private LicenseStatusService licenseService;
    @Autowired
    private UIAuthService authService;
    @Autowired
    private UsersActivityDAO usersActivityDAO;
    @Autowired
    private UsersDAO userDAO;
    @Autowired
    private UsersService usersService;
    @Autowired
    private TransactionService transactionService;
    @Autowired
    private LicenseEnforcementService licenseEnforcementService;
    @Autowired
    private PasswordEncryptionService passwordEncryptionService;
    @Autowired
    private IPermissionsService permissionsService;
    @Autowired
    private AuditTrailService auditTrailService;
    @Autowired
    private HikariDataSource dataSource;
    private static DKULogger logger;

    @PostConstruct
    public void setup() throws IOException {
        logger.debug((Object)"Init settings service");
        try (Transaction t = this.transactionService.beginRead();){
            GeneralSettingsDAO.GeneralSettings gs = this.read();
            DKUApp.setSecurityFlags((boolean)gs.security.hideLogs, (boolean)gs.security.hideErrorStacks, (boolean)gs.security.hideLogTails, (boolean)gs.security.secureCookies, (boolean)gs.security.sameSiteNoneCookies);
            ApiKeyUtils.setUseHashedApiKeys((boolean)gs.security.hashApiKeys);
        }
        logger.debug((Object)"Done init settings service");
        this.pubSub.subscribe("general-settings-changed", (DSSEventListener)new DSSEventListener<GeneralSettingsChangedEvent>(){

            public void on(GeneralSettingsChangedEvent evt) throws Exception {
                if (!JSON.jsonEquals((Object)evt.previousSettings.auditTrailSettings, (Object)evt.newSettings.auditTrailSettings)) {
                    logger.info((Object)"Audit settings changed, reconfiguring");
                    GeneralSettingsService.this.auditTrailService.reconfigure(evt.newSettings.auditTrailSettings);
                }
                GeneralSettingsService.this.reloadDataSourcePropertiesIfNecessary(evt.newSettings, evt.previousSettings);
            }
        });
    }

    public GeneralSettingsDAO.GeneralSettings read() throws IOException {
        return this.generalSettingsDAO.read();
    }

    private void fillResultingUDRFlags(AppConfig appConfig, GeneralSettingsDAO.GeneralSettings gs, AbstractLicenseFeaturesStatusBuilder.LicenseFeaturesStatus licensedFeatures) {
        String overridePrivacyMode;
        appConfig.udrMode = gs.udrMode;
        if (licensedFeatures != null) {
            if (licensedFeatures.lockedTracking) {
                appConfig.udrMode = UsageDataReporting.UsageDataReportingMode.DEFAULT;
            }
            if (licensedFeatures.forbiddenTracking) {
                appConfig.udrMode = UsageDataReporting.UsageDataReportingMode.NO;
            }
            if (licensedFeatures.mandatoryMinimalTracking && appConfig.udrMode == UsageDataReporting.UsageDataReportingMode.NO) {
                appConfig.udrMode = UsageDataReporting.UsageDataReportingMode.OPEN_ONLY;
            }
            appConfig.udrPrivacyMode = licensedFeatures.udrPrivacyMode;
            if (appConfig.udrPrivacyMode == null) {
                appConfig.udrPrivacyMode = UsageDataReporting.UsageDataReportingPrivacyMode.LINK;
            }
        } else {
            appConfig.udrMode = UsageDataReporting.UsageDataReportingMode.DEFAULT;
            appConfig.udrPrivacyMode = UsageDataReporting.UsageDataReportingPrivacyMode.LINK;
        }
        if (StringUtils.isNotBlank((String)(overridePrivacyMode = DKUApp.getParams().getParam("dku.tracking.usageDataPrivacyMode")))) {
            appConfig.udrPrivacyMode = UsageDataReporting.UsageDataReportingPrivacyMode.valueOf((String)overridePrivacyMode);
        }
        appConfig.errorsReporting = gs.errorsReportingEnabled;
        appConfig.pingTracking = ApplicationConfigurator.getParams().getBoolParam("dku.tracking.pingTracking", true);
        appConfig.pingTrackingInterval = ApplicationConfigurator.getParams().getIntParam("dku.tracking.pingTrackingInterval", Integer.valueOf(120000));
    }

    public AppConfig getConfigurationInternal(HttpServletRequest req, HttpServletResponse resp) throws Exception {
        File customJSFile;
        boolean unattendedMode;
        AppConfig c = new AppConfig();
        GeneralSettingsDAO.GeneralSettings generalSettings = this.read();
        c.version = ApplicationConfigurator.getDSSVersion();
        if (System.getenv("DKUDISTRIB") != null) {
            String str = System.getenv("DKUDISTRIB");
            c.distrib = StringUtils.split((String)str, (char)' ')[0];
            c.distribVersion = str.substring(c.distrib.length() + 1);
        } else {
            c.distrib = "unknown";
            c.distribVersion = "unknown";
        }
        c.launcherVersion = System.getenv("DKU_LAUNCHER_VERSION");
        c.dkuCloudSpaceId = System.getenv("DKU_CLOUD_SPACE_ID");
        c.dkuCloudLaunchpadUrl = System.getenv("DKU_CLOUD_LAUNCHPAD_URL");
        if (StringUtils.isBlank((String)c.dkuCloudLaunchpadUrl)) {
            c.dkuCloudLaunchpadUrl = ApplicationConfigurator.getParams().getParam("dku.cloud.launchpadUrl");
        }
        c.vmInfo = System.getenv("DKU_VM_INFO");
        c.wslInfo = System.getenv("DKU_WSL_INFO");
        c.deploymentMode = DKUApp.getDeploymentMode();
        c.cloudStacksCloud = DKUApp.getCloudStacksCloud();
        c.nodeType = DKUApp.getInstallNodeType();
        c.dipInstanceId = ApplicationConfigurator.dipInstanceId();
        c.installId = ApplicationConfigurator.getInstallId();
        c.registrationChannel = ApplicationConfigurator.getParams().getParam("dku.registration.channel", null);
        c.unattendedMode = unattendedMode = "true".equals(GeneralSettingsService.getCookieValue(req, "dku_unattended"));
        c.debug = ApplicationConfigurator.debugEnabled();
        c.devInstance = System.getenv("DSS_DEV") != null;
        c.xsrfCookieName = UIAuthService.getXSRFCookieName();
        c.nodeName = generalSettings.nodeName;
        c.studioForgotPasswordUrl = generalSettings.studioForgotPasswordUrl;
        c.dssExternalURL = generalSettings.studioExternalUrl;
        c.offlineFrontend = unattendedMode || ApplicationConfigurator.getParams().getBoolParam("dku.offlineFrontend", false);
        c.hashedApiKeysEnabled = ApiKeyUtils.useHashedApiKeys();
        c.ssoLoginEnabled = generalSettings.ssoSettings.enabled;
        c.ssoProtocol = generalSettings.ssoSettings.protocol;
        c.noLoginMode = generalSettings.noLoginMode;
        c.saasAuth = ApplicationConfigurator.isSAASAuth();
        if (c.saasAuth) {
            c.saasUserURL = ApplicationConfigurator.getMandatoryProperty((String)"saasUserURL");
            c.saasAccess = (SAASInstanceService.UserAccessSummary)JSON.deepCopy((Object)this.authService.getSAASAccess(req));
            c.saasAccess.xsrfTokenSalt = null;
            c.saasAccess.accessToken = null;
        }
        c.saasManagerURL = ApplicationConfigurator.getProperty((String)"saasManagerURL", (String)"https://my.dataiku.com/saas/api");
        c.enableEmailAndDisplayNameModification = generalSettings.security.enableEmailAndDisplayNameModification;
        AuthCtx u = this.authService.getUserNoXSRF(req);
        if (u != null) {
            if (u.getAuthSource() != AuthCtx.AuthSource.USER_FROM_UI) {
                throw new DKUSecurityException("Unexpected auth source: " + String.valueOf(u.getAuthSource()));
            }
            c.loggedIn = true;
            c.login = u.getAssociatedDSSUserMand();
            UsersDAO.User user = this.userDAO.getOrNullUnsafe(c.login);
            UsersService.UIUser uiUser = this.usersService.getUser_NoLeak(c.login);
            uiUser.computeTrialStatus(generalSettings, user);
            c.user = new PublicUser(uiUser.login, uiUser.displayName, uiUser.email, uiUser.creationDate, uiUser.sourceType);
            this.usersActivityDAO.updateUserLastSessionActivity(c.login);
            c.admin = u.isAdmin();
            c.canAccessCloudDataikerAdminCapabilities = this.permissionsService.hasAdditionalCloudDataikerAdminPermission(u);
            if (req.getHeader("X-DKU-APIKey") == null) {
                this.authService.setXSRFCookie(req, resp);
            }
            c.userProfile = this.licenseEnforcementService.getUserProfileByNameOrFallback(uiUser.resultingUserProfile);
            c.globalPermissions = this.usersService.getUserEffectiveGroupPermissions(user).getResolved();
        } else {
            c.firstLoginAfterRegister = justAfterRegister;
        }
        c.licensing = this.licenseService.getLicensingStatus();
        c.licensing.properties = null;
        c.communityEdition = c.licensing.community;
        c.ceEntrepriseTrial = c.licensing.ceEntrepriseTrial;
        AbstractLicenseFeaturesStatusBuilder.LicenseFeaturesStatus licensedFeatures = null;
        if (c.licensing.hasLicense) {
            licensedFeatures = this.enforcementService.getFeaturesStatus();
            if (c.licensing.licenseContent.licenseKind != null) {
                c.licenseKind = InstanceLicenseKind.valueOf((String)c.licensing.licenseContent.licenseKind);
            } else if (c.communityEdition) {
                c.licenseKind = InstanceLicenseKind.COMMUNITY;
            }
            c.licensedFeatures = licensedFeatures;
            c.governAllowed = licensedFeatures.governAllowed;
        } else {
            c.licenseKind = InstanceLicenseKind.NONE;
        }
        if (c.licenseKind == null) {
            c.licenseKind = InstanceLicenseKind.UNKNOWN;
        }
        c.licensingMode = ApplicationConfigurator.getLicensingMode();
        if (c.licensingMode == DKUApp.LicensingMode.ON_PREMISE_DISCONNECTED && !c.licensing.hasLicense) {
            c.licensingMode = DKUApp.LicensingMode.NONE;
            c.nodeId = LicenseUtils.getMainNodeId();
        }
        c.anonRegistrationAllowed = ApplicationConfigurator.getParams().getBoolParam("dku.registration.anonAllowed", false);
        if (!c.loggedIn) {
            c.licensing.licenseContent = null;
            c.licensing.sublicense = null;
            c.licensedFeatures = null;
        }
        this.fillResultingUDRFlags(c, generalSettings, licensedFeatures);
        if (c.loggedIn) {
            c.postLogoutBehavior = generalSettings.security.postLogoutBehavior;
            c.postLogoutCustomURL = generalSettings.security.postLogoutCustomURL;
            c.studioAdminContact = generalSettings.studioAdminContact;
            ProxySettings proxySettings = this.read().proxySettings;
            c.hasGlobalProxy = proxySettings.hasProxy();
            c.featureFlags.addAll(FeatureFlags.listEnabled());
            c.preventSignoffDelegateForNonAdmins = DKUApp.getParams().getBoolParam("dku.govern.preventSignoffDelegateForNonAdmins", false);
            c.preventSignoffApprovalFromSignoffRequesters = DKUApp.getParams().getBoolParam("dku.govern.preventSignoffApprovalFromSignoffRequesters", false);
        }
        if (c.loggedIn && (customJSFile = ApplicationConfigurator.getFile((String)"local/custom.js")).isFile()) {
            c.customJS = FileUtils.readFileToString((File)customJSFile, (String)"utf8");
        }
        if (!c.loggedIn && generalSettings.security.hideVersionStringsWhenNotLogged) {
            c.distrib = null;
            c.distribVersion = null;
            c.version = null;
            c.launcherVersion = null;
            c.deploymentMode = null;
            c.dkuCloudSpaceId = null;
        }
        justAfterRegister = false;
        return c;
    }

    public Map<String, String> getCustomHeadersForTracking(AuthCtx liu) {
        HashMap headers = Maps.newHashMap();
        headers.put("dipInstanceId", ApplicationConfigurator.dipInstanceId());
        headers.put("dssVersion", String.valueOf(ApplicationConfigurator.getDSSVersion()));
        LicenseStatusService.LicensingStatus licensing = this.licenseService.getLicensingStatus();
        InstanceLicenseKind licenseKind = null;
        if (licensing.hasLicense) {
            if (licensing.licenseContent.licenseKind != null) {
                licenseKind = InstanceLicenseKind.valueOf((String)licensing.licenseContent.licenseKind);
            } else if (licensing.community) {
                licenseKind = InstanceLicenseKind.COMMUNITY;
            }
        } else {
            licenseKind = InstanceLicenseKind.NONE;
        }
        if (licenseKind == null) {
            licenseKind = InstanceLicenseKind.UNKNOWN;
        }
        headers.put("dssLicenseKind", licenseKind.name());
        if (System.getenv("DKUDISTRIB") != null) {
            String str = System.getenv("DKUDISTRIB");
            String distrib = StringUtils.split((String)str, (char)' ')[0];
            headers.put("bkdDistrib", distrib);
            headers.put("bkdDistribVersion", str.substring(distrib.length() + 1));
        }
        return null;
    }

    private int dkuHashCode(String s) {
        int hash = 0;
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            hash = (hash << 5) - hash + c;
        }
        return hash;
    }

    public GeneralSettingsChangedEvent save(AuthCtx authCtx, GeneralSettingsDAO.GeneralSettings gs) throws Exception {
        GeneralSettingsDAO.GeneralSettings previous = this.generalSettingsDAO.read();
        if (gs.ldapSettings != null && gs.ldapSettings.enabled) {
            this.enforcementService.checkLdapAllowed();
        }
        gs.ldapSettings.encryptFields(this.passwordEncryptionService);
        gs.ssoSettings.encryptFields(this.passwordEncryptionService);
        gs.proxySettings.encryptFields(this.passwordEncryptionService);
        gs.ssoSettings.openIDParams.encryptFields(this.passwordEncryptionService);
        gs.azureADSettings.encryptFields(this.passwordEncryptionService);
        gs.integrationChannels.stream().map(IntegrationChannel::getConfiguration).forEach(conf -> conf.encryptFields(this.passwordEncryptionService));
        this.checkForbiddenCloudChanges(authCtx, previous, gs);
        this.generalSettingsDAO.save((GeneralSettingsDAO.GeneralSettings)Preconditions.checkNotNull((Object)gs));
        GeneralSettingsChangedEvent evt = new GeneralSettingsChangedEvent(previous, gs);
        this.pubSub.publishAfterTransaction((DSSEvent)evt);
        return evt;
    }

    private void reloadDataSourcePropertiesIfNecessary(GeneralSettingsDAO.GeneralSettings current, GeneralSettingsDAO.GeneralSettings previous) {
        GeneralSettingsDAO.DatasourceConnectionSettings previousSettings = previous.datasourceConnectionSettings;
        GeneralSettingsDAO.DatasourceConnectionSettings currentSettings = current.datasourceConnectionSettings;
        if (!Objects.equals(previousSettings, currentSettings)) {
            DatabaseConfiguration.loadDataSourceProperties(this.dataSource, currentSettings);
        }
    }

    private void checkForbiddenCloudChanges(AuthCtx authCtx, GeneralSettingsDAO.GeneralSettings before, GeneralSettingsDAO.GeneralSettings after) throws DKUSecurityException {
        if (authCtx.getAuthSource() == AuthCtx.AuthSource.NONE) {
            return;
        }
        if (this.permissionsService.hasAdditionalCloudDataikerAdminPermission(authCtx)) {
            return;
        }
        logger.debug((Object)"Cloud limited-admin: checking for forbidden changes");
        assert (authCtx.isAdmin());
        assert (before != null);
        if (!JSON.jsonEquals((Object)before.auditTrailSettings, (Object)after.auditTrailSettings)) {
            throw new UnauthorizedException("Settings change forbidden", "cloud-customer-audit-change");
        }
        if (!JSON.jsonEquals(before.fallbackNodeRefs, after.fallbackNodeRefs)) {
            throw new UnauthorizedException("Settings change forbidden", "cloud-customer-audit-change");
        }
    }

    public static void setJustAfterRegister(boolean justAfterRegister) {
        GeneralSettingsService.justAfterRegister = justAfterRegister;
    }

    private static String getCookieValue(HttpServletRequest req, String name) {
        Cookie[] cookies = req.getCookies();
        if (cookies != null) {
            for (Cookie cookie : cookies) {
                if (!name.equals(cookie.getName())) continue;
                return cookie.getValue();
            }
        }
        return null;
    }

    static {
        logger = DKULogger.getLogger((String)"dku.config");
    }

    @UIModel
    public static class AppConfig {
        String nodeType;
        InstanceLicenseKind licenseKind;
        String dipInstanceId;
        String installId;
        @UINullable
        DKUApp.DSSVersion version;
        @UINullable
        String launcherVersion;
        @UINullable
        String dkuCloudSpaceId;
        @UINullable
        String dkuCloudLaunchpadUrl;
        @UINullable
        DeploymentMode deploymentMode;
        CloudStacksCloud cloudStacksCloud;
        String vmInfo;
        String wslInfo;
        boolean hasGlobalProxy;
        boolean ssoLoginEnabled;
        SSOSettings.SSOProtocol ssoProtocol;
        GeneralSettingsDAO.PostLogoutBehavior postLogoutBehavior;
        String postLogoutCustomURL;
        boolean loggedIn;
        @UINullable
        String login;
        @UINullable
        PublicUser user;
        boolean debug;
        boolean devInstance;
        LicenseStatusService.LicensingStatus licensing;
        UsageDataReporting.UsageDataReportingMode udrMode;
        UsageDataReporting.UsageDataReportingPrivacyMode udrPrivacyMode;
        boolean errorsReporting;
        boolean pingTracking;
        int pingTrackingInterval;
        boolean hashedApiKeysEnabled;
        boolean admin;
        Boolean canAccessCloudDataikerAdminCapabilities;
        @UINullable
        LimitsStatusComputer.LicensedProfile userProfile;
        boolean enableEmailAndDisplayNameModification;
        @UINullable
        UsersDAO.GroupPermissions globalPermissions;
        public DKUApp.LicensingMode licensingMode;
        boolean saasAuth;
        String saasUserURL;
        boolean firstLoginAfterRegister;
        String saasManagerURL;
        SAASInstanceService.UserAccessSummary saasAccess;
        String xsrfCookieName;
        String nodeId;
        String studioForgotPasswordUrl;
        String studioAdminContact;
        boolean communityEdition;
        boolean ceEntrepriseTrial;
        @UINullable
        AbstractLicenseFeaturesStatusBuilder.LicenseFeaturesStatus licensedFeatures;
        boolean offlineFrontend;
        boolean unattendedMode;
        List<String> featureFlags = new ArrayList<String>();
        @UINullable
        String customJS;
        @UINullable
        String distrib;
        @UINullable
        String distribVersion;
        boolean noLoginMode;
        boolean anonRegistrationAllowed;
        @UINullable
        String registrationChannel;
        String dssExternalURL;
        String nodeName;
        public boolean governAllowed;
        public boolean preventSignoffDelegateForNonAdmins;
        public boolean preventSignoffApprovalFromSignoffRequesters;
    }
}

