/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.hproxy.server.servlets;

import com.dataiku.hproxy.server.Context;
import com.dataiku.hproxy.server.pig.checker.Checker;
import com.dataiku.hproxy.server.servlets.BaseServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import org.apache.log4j.Logger;

public class PigCheckerServlet
extends BaseServlet {
    private static final long serialVersionUID = -3145161833034655675L;
    private static Logger logger = Logger.getLogger(PigCheckerServlet.class);

    public PigCheckerServlet(Context ctx) {
        super(ctx);
    }

    @Override
    public void serviceCall(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        String path = req.getPathInfo();
        logger.info((Object)("Received command : " + path));
        try {
            switch (path) {
                case "/check": {
                    this.handleCheck(req, resp);
                    break;
                }
                default: {
                    this.sendError(resp, new Exception("Unknown command"));
                    break;
                }
            }
        }
        catch (Throwable e) {
            this.sendError(resp, e);
        }
    }

    private void handleCheck(HttpServletRequest req, HttpServletResponse resp) throws Exception {
        String query = this.getParameter(req, "query");
        this.writeJSON(resp, new Checker(this.getContext()).check(query));
    }
}

