/*
 * Decompiled with CFR 0.152.
 */
package io.delta.kernel.defaults.internal.data.vector;

import io.delta.kernel.defaults.internal.data.vector.AbstractColumnVector;
import io.delta.kernel.internal.util.Preconditions;
import io.delta.kernel.types.BinaryType;
import io.delta.kernel.types.DataType;
import io.delta.kernel.types.StringType;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import java.util.Optional;

public class DefaultBinaryVector
extends AbstractColumnVector {
    private final byte[][] values;

    public DefaultBinaryVector(DataType dataType, int n, byte[][] byArray) {
        super(n, dataType, Optional.empty());
        Preconditions.checkArgument((dataType instanceof StringType || dataType instanceof BinaryType ? 1 : 0) != 0, (String)"invalid type for binary vector: %s", (Object[])new Object[]{dataType});
        this.values = Objects.requireNonNull(byArray, "values is null");
        Preconditions.checkArgument((byArray.length >= n ? 1 : 0) != 0, (String)"invalid number of values (%s) for given size (%s)", (Object[])new Object[]{byArray.length, n});
    }

    @Override
    public boolean isNullAt(int n) {
        this.checkValidRowId(n);
        return this.values[n] == null;
    }

    @Override
    public String getString(int n) {
        if (!(this.getDataType() instanceof StringType)) {
            throw this.unsupportedDataAccessException("string");
        }
        this.checkValidRowId(n);
        byte[] byArray = this.values[n];
        if (byArray == null) {
            return null;
        }
        return StandardCharsets.UTF_8.decode(ByteBuffer.wrap(byArray)).toString();
    }

    @Override
    public byte[] getBinary(int n) {
        if (!(this.getDataType() instanceof BinaryType)) {
            throw this.unsupportedDataAccessException("binary");
        }
        this.checkValidRowId(n);
        return this.values[n];
    }
}

