/*
 * Decompiled with CFR 0.152.
 */
package io.delta.kernel.defaults.internal.data.vector;

import io.delta.kernel.defaults.internal.data.vector.AbstractColumnVector;
import io.delta.kernel.internal.util.Preconditions;
import io.delta.kernel.types.DataType;
import io.delta.kernel.types.FloatType;
import java.util.Objects;
import java.util.Optional;

public class DefaultFloatVector
extends AbstractColumnVector {
    private final float[] values;

    public DefaultFloatVector(int n, Optional<boolean[]> optional, float[] fArray) {
        super(n, (DataType)FloatType.FLOAT, optional);
        this.values = Objects.requireNonNull(fArray, "values is null");
        Preconditions.checkArgument((fArray.length >= n ? 1 : 0) != 0, (String)"invalid number of values (%s) for given size (%s)", (Object[])new Object[]{fArray.length, n});
    }

    @Override
    public float getFloat(int n) {
        this.checkValidRowId(n);
        return this.values[n];
    }
}

