/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.server.api;

import com.dataiku.dip.connections.ConnectionsDAO;
import com.dataiku.dip.connections.DSSConnection;
import com.dataiku.dip.connections.FSProviderizableConnection;
import com.dataiku.dip.dao.GeneralSettingsDAO;
import com.dataiku.dip.dataflow.FlowGraphService;
import com.dataiku.dip.futures.FutureResponse;
import com.dataiku.dip.futures.FutureService;
import com.dataiku.dip.managedfolder.KernelsManagedFolderService;
import com.dataiku.dip.managedfolder.ManagedFolder;
import com.dataiku.dip.managedfolder.ManagedFolderCopier;
import com.dataiku.dip.managedfolder.ManagedFolderDAO;
import com.dataiku.dip.managedfolder.ManagedFolderHandler;
import com.dataiku.dip.managedfolder.ManagedFoldersService;
import com.dataiku.dip.metrics.DisplayedMetricsSet;
import com.dataiku.dip.metrics.Metric;
import com.dataiku.dip.metrics.MetricTargetType;
import com.dataiku.dip.metrics.MetricUtils;
import com.dataiku.dip.metrics.MetricsComputationService;
import com.dataiku.dip.metrics.MetricsEngineDesc;
import com.dataiku.dip.metrics.MetricsLaunchService;
import com.dataiku.dip.metrics.MetricsService;
import com.dataiku.dip.metrics.ProbesSet;
import com.dataiku.dip.output.Output;
import com.dataiku.dip.partitioning.Partition;
import com.dataiku.dip.partitioning.PartitioningScheme;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.DSSAuthCtx;
import com.dataiku.dip.security.IPermissionsService;
import com.dataiku.dip.security.Privileges;
import com.dataiku.dip.security.audit.AuditTrailService;
import com.dataiku.dip.security.auth.MetaAuthService;
import com.dataiku.dip.server.api.PublicAPIControllerBase;
import com.dataiku.dip.server.controllers.AuditInline;
import com.dataiku.dip.server.controllers.AuditedCall;
import com.dataiku.dip.server.controllers.NotFoundException;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.transactions.ifaces.RWTransaction;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.dataiku.dip.util.SecretKeyGenerator;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.ErrorContext;
import com.dataiku.dip.utils.JSON;
import com.dataiku.dss.shadelib.org.apache.commons.io.IOUtils;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.InputStream;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;

@Controller
@RequestMapping(value={"/publicapi/projects/{projectKey}/managedfolders"})
public class PublicAPIManagedFoldersController
extends PublicAPIControllerBase {
    @Autowired
    private TransactionService transactionService;
    @Autowired
    private MetaAuthService authService;
    @Autowired
    private IPermissionsService permissionsService;
    @Autowired
    private ManagedFoldersService managedFolderService;
    @Autowired
    private KernelsManagedFolderService kernelsManagedFolderService;
    @Autowired
    private ManagedFolderDAO managedFolderDAO;
    @Autowired
    private MetricsService metricsService;
    @Autowired
    private MetricsLaunchService metricsLaunchService;
    @Autowired
    private GeneralSettingsDAO generalSettingsDAO;
    @Autowired
    private ConnectionsDAO connectionsDAO;
    @Autowired
    private FutureService futureService;
    @Autowired
    private AuditTrailService auditTrailService;
    @Autowired
    private FlowGraphService flowGraphService;
    static DKULogger logger = DKULogger.getLogger((String)"dip.api.managedfolders");

    @AuditedCall(value={"msgType", "managedfolders-list", "projectKey", "${projectKey}"})
    @RequestMapping(value={"/"}, method={RequestMethod.GET})
    public void listJobs(HttpServletRequest req, HttpServletResponse resp, @PathVariable String projectKey) throws Exception {
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx authCtx = this.authService.getTicketOrKey(req);
            this.permissionsService.checkProjectPrivileges(authCtx, projectKey, new Privileges.ProjectLevelPrivilegeType[]{Privileges.ProjectLevelPrivilegeType.READ_CONF});
            List ret = this.kernelsManagedFolderService.list(projectKey);
            PublicAPIManagedFoldersController.writeJSON((HttpServletResponse)resp, (Object)ret);
        }
    }

    @AuditInline
    @RequestMapping(value={"/"}, method={RequestMethod.POST})
    public void add(HttpServletRequest req, HttpServletResponse resp, @PathVariable String projectKey) throws Exception {
        JsonObject mfObject = (JsonObject)this.getRequestBodyAs(req, JsonObject.class);
        this.require(mfObject.has("name") && StringUtils.isNotBlank((String)mfObject.get("name").getAsString()), "Required field 'name' is missing.");
        if (mfObject.has("projectKey") && !mfObject.get("projectKey").isJsonNull() && mfObject.get("projectKey").getAsString().length() > 0) {
            this.require(mfObject.get("projectKey").getAsString().equals(projectKey), "Managed folder projectKey does not match the requested URL");
        } else {
            mfObject.addProperty("projectKey", projectKey);
        }
        this.require(mfObject.has("params") && !mfObject.get("params").isJsonNull(), "Required field 'params' is missing.");
        JsonObject mfParamsObject = mfObject.get("params").getAsJsonObject();
        this.require(mfParamsObject.has("connection"), "Required field 'params.connection' is missing.");
        AuthCtx authCtx = this.authService.getTicketOrKey_NT(req);
        try (Transaction t = this.transactionService.beginRead();){
            DSSConnection c = this.connectionsDAO.getMandatoryConnection(authCtx, mfParamsObject.get("connection").getAsString());
            if (!(c instanceof FSProviderizableConnection)) {
                throw new IllegalArgumentException("Invalid connection type for managed folders : " + c.getType());
            }
            FSProviderizableConnection fspc = (FSProviderizableConnection)c;
            if (mfObject.has("type") && !mfObject.get("type").isJsonNull()) {
                if (!fspc.getProviderTypes().contains(mfObject.get("type").getAsString())) {
                    throw new IllegalArgumentException("Managed folder type does not match the connection");
                }
            } else {
                mfObject.addProperty("type", (String)fspc.getProviderTypes().get(0));
            }
        }
        ManagedFolder mf = (ManagedFolder)JSON.parse((JsonElement)mfObject, ManagedFolder.class);
        ManagedFolder created = new ManagedFolder(projectKey, StringUtils.isBlank((String)mf.id) ? SecretKeyGenerator.generate((int)8) : mf.id);
        created.name = mf.name;
        created.contentType = mf.contentType;
        created.type = mf.type;
        created.checklists = mf.checklists;
        created.creationTag = mf.creationTag;
        created.versionTag = mf.versionTag;
        created.tags = mf.tags;
        created.description = mf.description;
        created.shortDesc = mf.shortDesc;
        created.flowOptions = mf.flowOptions;
        created.params = mf.getParams();
        String commitMessage = "Created managed folder " + created.id + " (named " + created.name + ") in " + created.projectKey;
        try (RWTransaction t = this.transactionService.beginWriteAsLoggedInUser(authCtx);){
            this.permissionsService.checkProjectPrivileges(authCtx, projectKey, new Privileges.ProjectLevelPrivilegeType[]{Privileges.ProjectLevelPrivilegeType.WRITE_CONF});
            if (this.managedFolderService.getOrNull(created.projectKey, created.id) != null) {
                throw new IllegalArgumentException("The managed folder '" + created.id + "' already exists in project " + created.projectKey);
            }
            this.managedFolderService.create(created, authCtx);
            t.commit(commitMessage);
        }
        this.auditTrailService.generic("managedfolder-create").with("projectKey", mf.projectKey).with("folderId", mf.id).with("name", mf.name).emit();
        PublicAPIManagedFoldersController.writeJSON((HttpServletResponse)resp, (Object)new PublicAPIControllerBase.ResponseMessageWithId(created.id, commitMessage));
    }

    @AuditedCall(value={"msgType", "managedfolder-get", "folderId", "${odbId}"})
    @RequestMapping(value={"/{odbId:.+}"}, method={RequestMethod.GET})
    public void get(HttpServletRequest req, HttpServletResponse resp, @PathVariable String projectKey, @PathVariable String odbId) throws Exception {
        ManagedFolder mf;
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx authCtx = this.authService.getTicketOrKey(req);
            this.permissionsService.checkProjectPrivileges(authCtx, projectKey, new Privileges.ProjectLevelPrivilegeType[]{Privileges.ProjectLevelPrivilegeType.READ_CONF});
            mf = this.managedFolderService.getMandatoryUnsafe(projectKey, odbId);
        }
        PublicAPIManagedFoldersController.writeJSON((HttpServletResponse)resp, (Object)mf);
    }

    @AuditedCall(value={"msgType", "managedfolder-save", "projectKey", "${projectKey}", "folderId", "${odbId}"})
    @RequestMapping(value={"/{odbId:.+}"}, method={RequestMethod.PUT})
    public void update(HttpServletRequest req, HttpServletResponse resp, @PathVariable String projectKey, @PathVariable String odbId) throws Exception {
        ManagedFolder mf = (ManagedFolder)this.getRequestBodyAs(req, ManagedFolder.class);
        this.require(StringUtils.isNotBlank((String)mf.projectKey), "Required field 'projectKey' is missing.");
        this.require(StringUtils.isNotBlank((String)mf.name), "Required field 'name' is missing.");
        this.require(StringUtils.isNotBlank((String)mf.id), "Required field 'id' is missing.");
        this.require(mf.projectKey.equals(projectKey), "Managed folder projectKey does not match the requested URL");
        this.require(mf.id.equals(odbId), "Managed folder id does not match the requested URL");
        String commitMessage = "Updated managed folder " + mf.projectKey + "." + mf.id;
        AuthCtx authCtx = this.authService.getTicketOrKey_NT(req);
        try (RWTransaction t = this.transactionService.beginWriteAsLoggedInUser(authCtx);){
            this.permissionsService.checkProjectPrivileges(authCtx, projectKey, new Privileges.ProjectLevelPrivilegeType[]{Privileges.ProjectLevelPrivilegeType.WRITE_CONF});
            ManagedFolder oldMf = this.managedFolderService.getMandatory(mf.projectKey, mf.id);
            if (mf.getParams() == null) {
                mf.params = oldMf.getParams();
            }
            this.managedFolderService.save(mf, false, false);
            t.commit(commitMessage);
        }
        this.writeMessage(resp, commitMessage, new Object[0]);
    }

    @AuditedCall(value={"msgType", "managedfolder-delete", "projectKey", "${projectKey}", "folderId", "${odbId}"})
    @RequestMapping(value={"/{odbId:.+}"}, method={RequestMethod.DELETE})
    public void delete(HttpServletRequest req, HttpServletResponse resp, @PathVariable String projectKey, @PathVariable String odbId) throws Exception {
        String commitMessage = "Deleted managed folder " + projectKey + "." + odbId;
        AuthCtx authCtx = this.authService.getTicketOrKey_NT(req);
        try (RWTransaction t = this.transactionService.beginWriteAsLoggedInUser(authCtx);){
            this.permissionsService.checkProjectPrivileges(authCtx, projectKey, new Privileges.ProjectLevelPrivilegeType[]{Privileges.ProjectLevelPrivilegeType.WRITE_CONF});
            this.managedFolderService.performDeletion(authCtx, projectKey, odbId, null);
            this.flowGraphService.invalidateCache(projectKey);
            t.commit(commitMessage);
        }
        this.writeMessage(resp, commitMessage, new Object[0]);
    }

    @AuditedCall(value={"msgType", "managedfolder-list-content", "projectKey", "${projectKey}", "folderId", "${odbId}"})
    @RequestMapping(value={"/{odbId}/contents"}, method={RequestMethod.GET})
    public void listItems(HttpServletRequest req, HttpServletResponse resp, @PathVariable String projectKey, @PathVariable String odbId) throws Exception {
        ManagedFolder mf;
        AuthCtx authCtx;
        try (Transaction t = this.transactionService.beginRead();){
            authCtx = this.authService.getTicketOrKey(req);
            this.permissionsService.checkProjectPrivileges(authCtx, projectKey, new Privileges.ProjectLevelPrivilegeType[]{Privileges.ProjectLevelPrivilegeType.READ_CONF});
            mf = this.managedFolderService.getMandatoryUnsafe(projectKey, odbId);
        }
        ManagedFolderHandler.ManagedFolderListing contents = this.kernelsManagedFolderService.handleListFSRequest_NT(authCtx, mf, Partition.newNP(), false);
        PublicAPIManagedFoldersController.writeJSON((HttpServletResponse)resp, (Object)contents);
    }

    @AuditedCall(value={"msgType", "managedfolder-list-content", "projectKey", "${projectKey}", "folderId", "${odbId}"})
    @RequestMapping(value={"/{odbId}/contents/**"}, method={RequestMethod.GET})
    public void getItem(HttpServletRequest req, HttpServletResponse resp, @PathVariable String projectKey, @PathVariable String odbId) throws Exception {
        AuthCtx authCtx;
        String itemPath = PublicAPIManagedFoldersController.extractPathFromRequest((HttpServletRequest)req);
        try (Transaction t = this.transactionService.beginRead();){
            authCtx = this.authService.getTicketOrKey(req);
            this.permissionsService.checkProjectPrivileges(authCtx, projectKey, new Privileges.ProjectLevelPrivilegeType[]{Privileges.ProjectLevelPrivilegeType.READ_CONF});
        }
        this.kernelsManagedFolderService.handleDownloadRequest_NT(projectKey, odbId, itemPath, resp, authCtx);
    }

    @AuditInline
    @RequestMapping(value={"/{odbId}/contents/**"}, method={RequestMethod.POST})
    public void putItem(HttpServletRequest req, HttpServletResponse resp, @PathVariable String projectKey, @PathVariable String odbId, @RequestParam(value="file") MultipartFile filePart) throws Exception {
        String itemPath = PublicAPIManagedFoldersController.extractPathFromRequest((HttpServletRequest)req);
        String path = "/" + (itemPath.isEmpty() ? filePart.getOriginalFilename() : itemPath);
        AuthCtx authCtx = this.authService.getTicketOrKey_NT(req);
        try (RWTransaction t = this.transactionService.beginWriteAsLoggedInUser(authCtx);){
            this.permissionsService.checkProjectPrivileges(authCtx, projectKey, new Privileges.ProjectLevelPrivilegeType[]{Privileges.ProjectLevelPrivilegeType.WRITE_CONF});
        }
        this.auditTrailService.generic("managedfolder-upload").with("projectKey", projectKey).with("folderId", odbId).emit();
        PublicAPIManagedFoldersController.writeJSON((HttpServletResponse)resp, (Object)this.kernelsManagedFolderService.handleUploadRequest_NT(projectKey, odbId, filePart.getInputStream(), path, true, authCtx));
    }

    @AuditInline
    @RequestMapping(value={"/{odbId}/contents/**"}, method={RequestMethod.DELETE})
    public void deleteItem(HttpServletRequest req, HttpServletResponse resp, @PathVariable String projectKey, @PathVariable String odbId) throws Exception {
        AuthCtx authCtx;
        String itemPath = PublicAPIManagedFoldersController.extractPathFromRequest((HttpServletRequest)req);
        try (Transaction t = this.transactionService.beginRead();){
            authCtx = this.authService.getTicketOrKey(req);
            this.permissionsService.checkProjectPrivileges(authCtx, projectKey, new Privileges.ProjectLevelPrivilegeType[]{Privileges.ProjectLevelPrivilegeType.WRITE_CONF});
            this.managedFolderService.getMandatory(projectKey, odbId);
        }
        FutureResponse deleteItem = this.kernelsManagedFolderService.handleDeleteItemsRequest(projectKey, odbId, new String[]{itemPath}, authCtx);
        this.auditTrailService.generic("managedfolder-delete-item").with("projectKey", projectKey).with("folderId", odbId).with("itemPath", itemPath).emit();
        this.futureService.waitForFinalResponse(deleteItem);
    }

    @AuditedCall(value={"msgType", "managedfolder-read-status", "projectKey", "${projectKey}", "folderId", "${odbId}"})
    @RequestMapping(value={"/{odbId}/metrics/last"}, method={RequestMethod.GET})
    @ResponseBody
    public MetricsService.ComputedMetrics getLastValuesOnFolder(HttpServletRequest req, @PathVariable String projectKey, @PathVariable String odbId) throws Exception {
        ManagedFolder folder;
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx authCtx = this.authService.getTicketOrKey(req);
            this.permissionsService.checkProjectPrivileges(authCtx, projectKey, new Privileges.ProjectLevelPrivilegeType[]{Privileges.ProjectLevelPrivilegeType.READ_CONF});
            folder = (ManagedFolder)this.managedFolderDAO.getMandatoryUnsafe(projectKey, odbId);
        }
        DisplayedMetricsSet dms = folder.metrics != null ? folder.metrics.displayedState : null;
        return this.metricsService.listComputedMetrics_NT((Object)folder, MetricTargetType.MANAGED_FOLDER, dms, true);
    }

    @AuditedCall(value={"msgType", "managedfolder-read-status", "projectKey", "${projectKey}", "folderId", "${odbId}"})
    @RequestMapping(value={"/{odbId}/metrics/history"}, method={RequestMethod.GET})
    @ResponseBody
    public MetricsService.MetricHistoryData getHistoryValuesOnFolder(HttpServletRequest req, @PathVariable String projectKey, @PathVariable String odbId, @RequestParam String metricLookup) throws Exception {
        ManagedFolder folder;
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx authCtx = this.authService.getTicketOrKey(req);
            this.permissionsService.checkProjectPrivileges(authCtx, projectKey, new Privileges.ProjectLevelPrivilegeType[]{Privileges.ProjectLevelPrivilegeType.READ_CONF});
            folder = (ManagedFolder)this.managedFolderDAO.getMandatory(projectKey, odbId);
        }
        Map lastMetrics = this.metricsService.getLastKnownMetrics_NT((Object)folder, MetricTargetType.MANAGED_FOLDER);
        Metric lookedUpMetric = MetricsService.lookupMetric((String)metricLookup, (Map)lastMetrics);
        if (lookedUpMetric == null) {
            throw new NotFoundException("Metric: '" + metricLookup + "' does not exist on managed folder " + projectKey + "." + odbId + ".");
        }
        return this.metricsService.getMetricData_NT((Object)folder, MetricTargetType.MANAGED_FOLDER, null, lookedUpMetric.getId(), true);
    }

    @AuditedCall(value={"msgType", "managedfolder-compute-status", "projectKey", "${projectKey}", "folderId", "${odbId}"})
    @RequestMapping(value={"/{odbId}/actions/computeMetrics"}, method={RequestMethod.POST})
    public void computeMetrics(HttpServletRequest req, HttpServletResponse resp, @PathVariable String projectKey, @PathVariable String odbId, @RequestParam(defaultValue="") String partition) throws Exception {
        AuthCtx authCtx = this.authService.getTicketOrKey_NT(req);
        try (RWTransaction t = this.transactionService.beginWriteAsLoggedInUser(authCtx);){
            this.permissionsService.checkProjectPrivileges(authCtx, projectKey, new Privileges.ProjectLevelPrivilegeType[]{Privileges.ProjectLevelPrivilegeType.WRITE_CONF});
            ManagedFolder mf = this.managedFolderService.getMandatory(projectKey, odbId);
            ProbesSet probesToCompute = null;
            String body = IOUtils.toString((InputStream)req.getInputStream());
            if (body != null && body.length() > 0) {
                probesToCompute = (ProbesSet)JSON.parse((String)body, ProbesSet.class);
            } else {
                logger.info((Object)"Probes to compute not specified, using the ones from the folder config");
                probesToCompute = mf.metrics;
            }
            Partition p = MetricsComputationService.makePartitionFromId((PartitioningScheme)mf.getPartitioningSchema(), (String)partition);
            MetricsComputationService.MetricsComputationEnvironment environment = new MetricsComputationService.MetricsComputationEnvironment();
            environment.startedFromBuild = false;
            GeneralSettingsDAO.GeneralSettings generalSettings = this.generalSettingsDAO.read();
            environment.graphiteServerUrl = generalSettings.graphiteServerUrl;
            environment.graphiteMetricPrefix = generalSettings.graphiteMetricPrefix;
            FutureResponse fr = this.metricsLaunchService.launchComputeMetrics(authCtx, mf, p, probesToCompute, new MetricsEngineDesc.MetricsEngineContext(authCtx), environment);
            fr = this.futureService.waitForFinalResponse(fr);
            PublicAPIManagedFoldersController.writeJSON((HttpServletResponse)resp, (Object)fr);
        }
    }

    @AuditedCall(value={"msgType", "managedfolder-compute-status", "projectKey", "${projectKey}", "folderId", "${odbId}"})
    @RequestMapping(value={"/{odbId}/actions/computeMetricsFromIds"}, method={RequestMethod.POST})
    public void computeMetricsFromIds(HttpServletRequest req, HttpServletResponse resp, @PathVariable String projectKey, @PathVariable String odbId, @RequestParam(defaultValue="") String partition) throws Exception {
        AuthCtx authCtx = this.authService.getTicketOrKey_NT(req);
        try (RWTransaction t = this.transactionService.beginWriteAsLoggedInUser(authCtx);){
            this.permissionsService.checkProjectPrivileges(authCtx, projectKey, new Privileges.ProjectLevelPrivilegeType[]{Privileges.ProjectLevelPrivilegeType.WRITE_CONF});
            ManagedFolder mf = this.managedFolderService.getMandatory(projectKey, odbId);
            logger.info((Object)"Start to compute");
            MetricUtils.CustomMetricsSet cms = (MetricUtils.CustomMetricsSet)this.getRequestBodyAs(req, MetricUtils.CustomMetricsSet.class);
            ProbesSet datasetProbes = mf.metrics;
            ProbesSet probesToCompute = MetricUtils.probesSetFromMetricIds((ProbesSet)datasetProbes, (List)cms.metricIds);
            Partition p = MetricsComputationService.makePartitionFromId((PartitioningScheme)mf.getPartitioningSchema(), (String)partition);
            logger.info((Object)("Will compute: " + JSON.json((Object)probesToCompute)));
            MetricsComputationService.MetricsComputationEnvironment environment = new MetricsComputationService.MetricsComputationEnvironment();
            environment.startedFromBuild = false;
            GeneralSettingsDAO.GeneralSettings generalSettings = this.generalSettingsDAO.read();
            environment.graphiteServerUrl = generalSettings.graphiteServerUrl;
            environment.graphiteMetricPrefix = generalSettings.graphiteMetricPrefix;
            FutureResponse fr = this.metricsLaunchService.launchComputeMetrics(authCtx, mf, p, probesToCompute, new MetricsEngineDesc.MetricsEngineContext(authCtx), environment);
            fr = this.futureService.waitForFinalResponse(fr);
            PublicAPIManagedFoldersController.writeJSON((HttpServletResponse)resp, (Object)fr);
        }
    }

    @AuditedCall(value={"msgType", "dataset-copy", "projectKey", "${projectKey}", "folderId", "${folderId}"})
    @RequestMapping(value={"/{folderId}/actions/copyTo"}, method={RequestMethod.POST})
    public void copyTo(HttpServletRequest req, HttpServletResponse resp, @PathVariable String projectKey, @PathVariable String folderId) throws Exception {
        ManagedFolder target;
        ManagedFolder source;
        ManagedFolderCopyRequest fcr = (ManagedFolderCopyRequest)this.getRequestBodyAs(req, ManagedFolderCopyRequest.class);
        DSSAuthCtx authCtx = null;
        try (Transaction t = this.transactionService.beginRead();){
            authCtx = (DSSAuthCtx)this.authService.getTicketOrKey(req);
            this.permissionsService.checkProjectPrivileges((AuthCtx)authCtx, projectKey, new Privileges.ProjectLevelPrivilegeType[]{Privileges.ProjectLevelPrivilegeType.READ_CONF});
            this.permissionsService.checkProjectPrivileges((AuthCtx)authCtx, fcr.targetProjectKey, new Privileges.ProjectLevelPrivilegeType[]{Privileges.ProjectLevelPrivilegeType.WRITE_CONF});
            source = this.managedFolderService.getMandatoryUnsafe(projectKey, folderId);
            target = this.managedFolderService.getMandatoryUnsafe(fcr.targetProjectKey, fcr.targetFolderId);
            if (source.getPartitioningSchema().isPartitioned()) {
                throw ErrorContext.iaef((String)"Folder %s is partitioned, this is not supported for the copy API", (Object)source.getFullId(), (Object[])new Object[0]);
            }
            if (target.getPartitioningSchema().isPartitioned()) {
                throw ErrorContext.iaef((String)"Folder %s is partitioned, this is not supported for the copy API", (Object)target.getFullId(), (Object[])new Object[0]);
            }
        }
        ManagedFolderCopier copier = new ManagedFolderCopier();
        PublicAPIManagedFoldersController.writeJSON((HttpServletResponse)resp, (Object)copier.startCopy_NT(authCtx, source.getFullId(), target.getFullId(), fcr.writeMode));
    }

    static class ManagedFolderCopyRequest {
        public String targetProjectKey;
        public String targetFolderId;
        public Output.WriteMode writeMode = Output.WriteMode.OVERWRITE;

        ManagedFolderCopyRequest() {
        }
    }
}

