/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.server.api.admin;

import com.dataiku.dip.cluster.Cluster;
import com.dataiku.dip.cluster.ClustersService;
import com.dataiku.dip.containers.exec.KubectlHelper;
import com.dataiku.dip.containers.exec.KubernetesClusterService;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.futures.FutureResponse;
import com.dataiku.dip.futures.FutureService;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.DSSAuthCtx;
import com.dataiku.dip.security.IPermissionsService;
import com.dataiku.dip.security.Privileges;
import com.dataiku.dip.security.audit.AuditTrailService;
import com.dataiku.dip.security.auth.MetaAuthService;
import com.dataiku.dip.server.api.PublicAPIControllerBase;
import com.dataiku.dip.server.controllers.AuditInline;
import com.dataiku.dip.server.controllers.AuditedCall;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.transactions.ifaces.RWTransaction;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.dataiku.dip.utils.DKUtils;
import com.dataiku.dip.utils.ErrorContext;
import com.google.common.collect.Lists;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

@Controller
@RequestMapping(value={"/publicapi/admin/clusters"})
public class PublicAPIClustersController
extends PublicAPIControllerBase {
    @Autowired
    private MetaAuthService authService;
    @Autowired
    private IPermissionsService permissionsService;
    @Autowired
    private TransactionService transactionService;
    @Autowired
    private ClustersService clustersService;
    @Autowired
    private AuditTrailService auditTrailService;
    @Autowired
    private FutureService futureService;
    @Autowired
    private KubernetesClusterService kubernetesClusterService;

    @AuditedCall(value={"msgType", "clusters-list"})
    @RequestMapping(value={"/"}, method={RequestMethod.GET})
    public void list(HttpServletRequest req, HttpServletResponse resp) throws Exception {
        try (Transaction t = this.transactionService.beginRead();){
            DSSAuthCtx authCtx = (DSSAuthCtx)this.authService.getTicketOrKey(req);
            if (!authCtx.getPermissions().mayCreateClusters() && !authCtx.getPermissions().mayManageClusters()) {
                throw new SecurityException("You may not manage clusters");
            }
            ArrayList items = Lists.newArrayList();
            for (Cluster cluster : this.clustersService.listUnsafe()) {
                if (!this.permissionsService.hasAnyClusterAccess((AuthCtx)authCtx, cluster.id)) continue;
                ClustersService.ClusterHeadItem clusterHeadItem = new ClustersService.ClusterHeadItem(cluster);
                clusterHeadItem.fillPrivilegeInfo(this.permissionsService, (AuthCtx)authCtx);
                items.add(clusterHeadItem);
            }
            this.clustersService.collectUsageCounts((List)items);
            PublicAPIClustersController.writeJSON((HttpServletResponse)resp, (Object)items);
        }
    }

    @AuditedCall(value={"msgType", "clusters-get", "clusterId", "${clusterId}"})
    @RequestMapping(value={"/{clusterId:.+}"}, method={RequestMethod.GET})
    public void get(HttpServletRequest req, HttpServletResponse resp, @PathVariable String clusterId) throws Exception {
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx authCtx = this.authService.getTicketOrKey(req);
            this.permissionsService.checkClusterPrivileges(authCtx, clusterId, new Privileges.ClusterLevelPrivilegeType[]{Privileges.ClusterLevelPrivilegeType.UPDATE});
            Cluster cluster = this.clustersService.getMandatoryUnsafe(clusterId);
            ClustersService.ClusterItem clusterItem = new ClustersService.ClusterItem(cluster);
            clusterItem.fillPrivilegeInfo(this.permissionsService, authCtx);
            PublicAPIClustersController.writeJSON((HttpServletResponse)resp, (Object)clusterItem);
        }
    }

    @AuditedCall(value={"msgType", "clusters-get-status", "clusterId", "${clusterId}"})
    @RequestMapping(value={"/{clusterId}/status"}, method={RequestMethod.GET})
    public void getStatus(HttpServletRequest req, HttpServletResponse resp, @PathVariable String clusterId) throws Exception {
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx authCtx = this.authService.getTicketOrKey(req);
            this.permissionsService.checkClusterPrivileges(authCtx, clusterId, new Privileges.ClusterLevelPrivilegeType[]{Privileges.ClusterLevelPrivilegeType.UPDATE});
            ClustersService.ClusterStatus status = this.clustersService.getStatus(clusterId);
            PublicAPIClustersController.writeJSON((HttpServletResponse)resp, (Object)status);
        }
    }

    @AuditedCall(value={"msgType", "clusters-delete", "clusterId", "${clusterId}"})
    @RequestMapping(value={"/{clusterId:.+}"}, method={RequestMethod.DELETE})
    public void delete(HttpServletRequest req, HttpServletResponse resp, @PathVariable String clusterId) throws Exception {
        try (RWTransaction t = this.transactionService.beginWriteForAPI(req);){
            AuthCtx authCtx = this.authService.getTicketOrKey(req);
            this.permissionsService.checkClusterPrivileges(authCtx, clusterId, new Privileges.ClusterLevelPrivilegeType[]{Privileges.ClusterLevelPrivilegeType.UPDATE});
            Cluster cluster = this.clustersService.delete(clusterId);
            t.commit("Delete cluster " + cluster.name);
        }
    }

    @AuditInline
    @RequestMapping(value={"/"}, method={RequestMethod.POST})
    public void create(HttpServletRequest req, HttpServletResponse resp) throws Exception {
        Cluster cluster = (Cluster)this.getRequestBodyAs(req, Cluster.class);
        try (RWTransaction t = this.transactionService.beginWriteForAPI(req);){
            DSSAuthCtx authCtx = (DSSAuthCtx)this.authService.getTicketOrKey(req);
            if (!authCtx.getPermissions().mayCreateClusters()) {
                throw new SecurityException("You may not create clusters");
            }
            cluster.origin = Cluster.ClusterOrigin.makeManual((AuthCtx)authCtx);
            cluster = this.clustersService.create((AuthCtx)authCtx, cluster);
            t.commit("Create cluster " + cluster.name);
            PublicAPIClustersController.writeJSON((HttpServletResponse)resp, (Object)cluster);
            this.auditTrailService.generic("clusters-create").with("clusterId", cluster.id).emit();
        }
        catch (Exception e) {
            this.auditTrailService.failure("clusters-create", (Throwable)e).with("clusterId", cluster.id).emit();
            throw e;
        }
    }

    @AuditedCall(value={"msgType", "clusters-save", "clusterId", "${clusterId}"})
    @RequestMapping(value={"/{clusterId:.+}"}, method={RequestMethod.PUT})
    public void save(HttpServletRequest req, HttpServletResponse resp, @PathVariable String clusterId) throws Exception {
        Cluster cluster = (Cluster)this.getRequestBodyAs(req, Cluster.class);
        cluster.id = clusterId;
        try (RWTransaction t = this.transactionService.beginWriteForAPI(req);){
            AuthCtx authCtx = this.authService.getTicketOrKey(req);
            this.permissionsService.checkClusterPrivileges(authCtx, cluster.id, new Privileges.ClusterLevelPrivilegeType[]{Privileges.ClusterLevelPrivilegeType.UPDATE});
            cluster = this.clustersService.saveFromUser(cluster, this.permissionsService.hasClusterPrivilege(authCtx, cluster.id, Privileges.ClusterLevelPrivilegeType.MANAGE_USERS));
            ClustersService.ClusterItem clusterItem = new ClustersService.ClusterItem(cluster);
            clusterItem.fillPrivilegeInfo(this.permissionsService, authCtx);
            PublicAPIClustersController.writeJSON((HttpServletResponse)resp, (Object)clusterItem);
            t.commit("Save cluster " + cluster.name);
        }
    }

    @AuditedCall(value={"msgType", "clusters-start", "clusterId", "${clusterId}"})
    @RequestMapping(value={"/{clusterId}/actions/start"}, method={RequestMethod.POST})
    public void start(HttpServletRequest req, HttpServletResponse resp, @PathVariable String clusterId) throws Exception {
        FutureResponse fr;
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx authCtx = this.authService.getTicketOrKey(req);
            this.permissionsService.checkClusterPrivileges(authCtx, clusterId, new Privileges.ClusterLevelPrivilegeType[]{Privileges.ClusterLevelPrivilegeType.UPDATE});
            Cluster cluster = this.clustersService.getMandatoryUnsafe(clusterId);
            fr = this.clustersService.start(authCtx, null, cluster);
        }
        fr = this.futureService.waitForFinalResponse(fr);
        PublicAPIClustersController.writeJSON((HttpServletResponse)resp, (Object)fr.result);
    }

    @AuditedCall(value={"msgType", "clusters-stop", "clusterId", "${clusterId}"})
    @RequestMapping(value={"/{clusterId}/actions/stop"}, method={RequestMethod.POST})
    public void stop(HttpServletRequest req, HttpServletResponse resp, @PathVariable String clusterId, @RequestParam(required=false, defaultValue="true") boolean terminate, @RequestParam(required=false, defaultValue="false") boolean forceStop) throws Exception {
        FutureResponse fr;
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx authCtx = this.authService.getTicketOrKey(req);
            this.permissionsService.checkClusterPrivileges(authCtx, clusterId, new Privileges.ClusterLevelPrivilegeType[]{Privileges.ClusterLevelPrivilegeType.UPDATE});
            Cluster cluster = this.clustersService.getMandatoryUnsafe(clusterId);
            fr = this.clustersService.stop(authCtx, null, cluster, terminate, forceStop);
        }
        fr = this.futureService.waitForFinalResponse(fr);
        PublicAPIClustersController.writeJSON((HttpServletResponse)resp, (Object)fr.result);
    }

    @AuditedCall(value={"msgType", "clusters-k8s-kubectl-command", "clusterId", "${clusterId}", "request", "${request}"})
    @RequestMapping(value={"/{clusterId}/k8s/actions/run-kubectl"}, method={RequestMethod.POST})
    public void runKubectlCommand(HttpServletRequest req, HttpServletResponse resp, @PathVariable String clusterId, @RequestBody KubectlCommandRequest request) throws Exception {
        AuthCtx authCtx = this.getAuthCtx_NT(req);
        this.permissionsService.checkAdmin(authCtx);
        this.kubernetesClusterService.checkClusterUpdatePrivilegeAndArchitecture_NT(authCtx, clusterId);
        if (request == null || request.args == null) {
            throw ErrorContext.iae((String)"Kubectl arguments missing from request body");
        }
        PublicAPIClustersController.writeJSON((HttpServletResponse)resp, (Object)new KubectlExecutionResult(this.waitForKubectlResponse((FutureResponse<DKUtils.ExecutionResults>)this.kubernetesClusterService.futureRunKubectlCommand(authCtx, clusterId, KubectlHelper.parseCommand((String)request.args)))));
    }

    @AuditedCall(value={"msgType", "clusters-k8s-delete-finished-jobs", "clusterId", "${clusterId}", "deleteFailed", "${deleteFailed}"})
    @RequestMapping(value={"/{clusterId}/k8s/jobs/actions/delete-finished"}, method={RequestMethod.POST})
    public void deleteFinishedJobs(HttpServletRequest req, HttpServletResponse resp, @PathVariable String clusterId, @RequestParam(required=false, defaultValue="false") boolean deleteFailed, @RequestParam(required=false, defaultValue="true") boolean dryRun, @RequestParam(required=false) String namespace, @RequestParam(required=false) String labelFilter) throws Exception {
        AuthCtx authCtx = this.getAuthCtx_NT(req);
        this.kubernetesClusterService.checkClusterUpdatePrivilegeAndArchitecture_NT(authCtx, clusterId);
        PublicAPIClustersController.writeJSON((HttpServletResponse)resp, (Object)this.waitForDeleteResponse((FutureResponse<DKUtils.ExecutionResults>)this.kubernetesClusterService.deleteFinishedJobs(authCtx, clusterId, dryRun, deleteFailed, namespace, labelFilter)));
    }

    @AuditedCall(value={"msgType", "clusters-k8s-delete-finished-pods", "clusterId", "${clusterId}"})
    @RequestMapping(value={"/{clusterId}/k8s/pods/actions/delete-finished"}, method={RequestMethod.POST})
    public void deleteFinishedPods(HttpServletRequest req, HttpServletResponse resp, @PathVariable String clusterId, @RequestParam(required=false, defaultValue="true") boolean dryRun, @RequestParam(required=false) String namespace, @RequestParam(required=false) String labelFilter) throws Exception {
        AuthCtx authCtx = this.getAuthCtx_NT(req);
        this.kubernetesClusterService.checkClusterUpdatePrivilegeAndArchitecture_NT(authCtx, clusterId);
        PublicAPIClustersController.writeJSON((HttpServletResponse)resp, (Object)this.waitForDeleteResponse((FutureResponse<DKUtils.ExecutionResults>)this.kubernetesClusterService.deleteFinishedPods(authCtx, clusterId, dryRun, namespace, labelFilter)));
    }

    @AuditedCall(value={"msgType", "clusters-k8s-delete-all-pods", "clusterId", "${clusterId}"})
    @RequestMapping(value={"/{clusterId}/k8s/pods/actions/delete-all"}, method={RequestMethod.POST})
    public void deleteAllPods(HttpServletRequest req, HttpServletResponse resp, @PathVariable String clusterId, @RequestParam(required=false, defaultValue="true") boolean dryRun, @RequestParam(required=false) String namespace, @RequestParam(required=false) String labelFilter) throws Exception {
        AuthCtx authCtx = this.getAuthCtx_NT(req);
        this.kubernetesClusterService.checkClusterUpdatePrivilegeAndArchitecture_NT(authCtx, clusterId);
        PublicAPIClustersController.writeJSON((HttpServletResponse)resp, (Object)this.waitForDeleteResponse((FutureResponse<DKUtils.ExecutionResults>)this.kubernetesClusterService.deleteAllPods(authCtx, clusterId, dryRun, namespace, labelFilter)));
    }

    private DKUtils.ExecutionResults waitForKubectlResponse(FutureResponse<DKUtils.ExecutionResults> kubectlFutureResponse) throws Exception {
        kubectlFutureResponse = this.futureService.waitForFinalResponse(kubectlFutureResponse);
        return (DKUtils.ExecutionResults)kubectlFutureResponse.result;
    }

    private DeleteExecutionResult waitForDeleteResponse(FutureResponse<DKUtils.ExecutionResults> kubectlFutureResponse) throws Exception {
        return new DeleteExecutionResult(this.waitForKubectlResponse(kubectlFutureResponse));
    }

    private AuthCtx getAuthCtx_NT(HttpServletRequest req) throws DKUSecurityException {
        try (Transaction ignored = this.transactionService.beginRead();){
            AuthCtx authCtx = this.authService.getTicketOrKey(req);
            return authCtx;
        }
    }

    public static class KubectlCommandRequest {
        public String args;
    }

    public static class KubectlExecutionResult {
        public int returnValue;
        public String output;
        public String error;

        public KubectlExecutionResult(DKUtils.ExecutionResults results) {
            this.returnValue = results.rv;
            this.output = results.out;
            this.error = results.err;
        }
    }

    public static class DeleteExecutionResult {
        public boolean success;
        public List<String> deleted = new ArrayList<String>();
        public DebugInfo debug = new DebugInfo();

        public DeleteExecutionResult(DKUtils.ExecutionResults results) {
            this.success = results.rv == 0;
            this.debug.returnValue = results.rv;
            this.debug.stdout = results.out;
            this.debug.stderr = results.err;
            if (this.success) {
                this.deleted = this.parseOutputToList(results.out);
            }
        }

        private List<String> parseOutputToList(String out) {
            if (out.startsWith("No resources found")) {
                return new ArrayList<String>();
            }
            return Arrays.stream(out.split(System.lineSeparator())).map(line -> StringUtils.substringBetween((String)line, (String)"\"")).collect(Collectors.toList());
        }

        private static class DebugInfo {
            public int returnValue;
            public String stdout;
            public String stderr;

            private DebugInfo() {
            }
        }
    }
}

