/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.server.api.openai;

import com.dataiku.common.server.DKUControllerBase;
import com.dataiku.dip.llm.online.LLMClient;
import com.dataiku.dip.server.api.PublicAPILLMController;
import com.dataiku.dip.server.api.openai.OpenAIChatCompletionRequest;
import com.dataiku.dip.server.api.openai.OpenAIChatCompletionResponse;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.JSON;
import com.dataiku.dss.shadelib.com.google.common.collect.Lists;
import com.google.gson.JsonObject;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;

@Service
public class OpenAIAPIConverter {
    private static final DKULogger logger = DKULogger.getLogger(OpenAIAPIConverter.class);
    private static final Pattern inlineImageMatcherPattern = Pattern.compile("^data:(image/[^;]+);base64,(.*)$");

    public static PublicAPILLMController.CompletionsRequest convertToCompletionRequest(OpenAIChatCompletionRequest openAIChatCompletionRequest) {
        if (openAIChatCompletionRequest.n != null) {
            if (openAIChatCompletionRequest.n > 1) {
                throw new UnsupportedOperationException("Invalid parameter n. Multiple choice generation for the same input message is not supported");
            }
            if (openAIChatCompletionRequest.n < 1) {
                throw new UnsupportedOperationException("Invalid parameter n. It should be a positive number");
            }
        }
        PublicAPILLMController.CompletionsRequest completionsRequest = new PublicAPILLMController.CompletionsRequest();
        completionsRequest.llmId = openAIChatCompletionRequest.model;
        LLMClient.SingleCompletionQuery completionQuery = OpenAIAPIConverter.convertToSingleCompletionQuery(openAIChatCompletionRequest);
        completionsRequest.queries = Lists.newArrayList((Object[])new LLMClient.SingleCompletionQuery[]{completionQuery});
        LLMClient.CompletionSettings completionSettings = new LLMClient.CompletionSettings();
        completionSettings.frequencyPenalty = openAIChatCompletionRequest.frequencyPenalty;
        completionSettings.logProbs = openAIChatCompletionRequest.logprobs;
        completionSettings.logitBias = openAIChatCompletionRequest.logitBias;
        completionSettings.maxOutputTokens = openAIChatCompletionRequest.maxTokens;
        completionSettings.presencePenalty = openAIChatCompletionRequest.presencePenalty;
        completionSettings.stopSequences = openAIChatCompletionRequest.stop;
        completionSettings.temperature = openAIChatCompletionRequest.temperature;
        completionSettings.topP = openAIChatCompletionRequest.topP;
        completionSettings.topLogProbs = openAIChatCompletionRequest.topLogprobs;
        completionSettings.responseFormat = OpenAIAPIConverter.convertToResponseFormat(openAIChatCompletionRequest);
        completionSettings.tools = OpenAIAPIConverter.convertToCompletionRequestTools(openAIChatCompletionRequest);
        completionSettings.toolChoice = OpenAIAPIConverter.convertToCompletionRequestToolChoice(openAIChatCompletionRequest);
        if (!StringUtils.isEmpty((CharSequence)openAIChatCompletionRequest.reasoningEffort)) {
            if (openAIChatCompletionRequest.reasoningEffort.equals("OFF")) {
                completionSettings.reasoningEffort = LLMClient.ReasoningEffort.OFF;
            } else if (openAIChatCompletionRequest.reasoningEffort.equals("STANDARD")) {
                completionSettings.reasoningEffort = LLMClient.ReasoningEffort.STANDARD;
            } else {
                completionSettings.reasoningEffort = LLMClient.ReasoningEffort.CUSTOM;
                completionSettings.customReasoningEffort = openAIChatCompletionRequest.reasoningEffort;
            }
        }
        completionsRequest.settings = completionSettings;
        return completionsRequest;
    }

    private static LLMClient.ResponseFormat convertToResponseFormat(OpenAIChatCompletionRequest openAIChatCompletionRequest) {
        if (openAIChatCompletionRequest.responseFormat != null) {
            if (openAIChatCompletionRequest.responseFormat instanceof OpenAIChatCompletionRequest.OpenAIChatCompletionRequestFormatJsonObject) {
                return new LLMClient.ResponseFormatJson();
            }
            if (openAIChatCompletionRequest.responseFormat instanceof OpenAIChatCompletionRequest.OpenAIChatCompletionRequestFormatText) {
                return new LLMClient.ResponseFormatText();
            }
            if (openAIChatCompletionRequest.responseFormat instanceof OpenAIChatCompletionRequest.OpenAIChatCompletionRequestFormatJsonSchema) {
                OpenAIChatCompletionRequest.OpenAIChatCompletionRequestFormatJsonSchema oaiSchema = (OpenAIChatCompletionRequest.OpenAIChatCompletionRequestFormatJsonSchema)openAIChatCompletionRequest.responseFormat;
                LLMClient.ResponseFormatJson responseFormat = new LLMClient.ResponseFormatJson();
                JsonObject jsonSchemObj = oaiSchema.jsonSchema.schema;
                if (!jsonSchemObj.has("title") && !StringUtils.isBlank((CharSequence)oaiSchema.jsonSchema.name)) {
                    jsonSchemObj.addProperty("title", oaiSchema.jsonSchema.name);
                }
                if (!jsonSchemObj.has("description") && !StringUtils.isBlank((CharSequence)oaiSchema.jsonSchema.description)) {
                    jsonSchemObj.addProperty("description", oaiSchema.jsonSchema.description);
                }
                responseFormat.schema = oaiSchema.jsonSchema.schema;
                return responseFormat;
            }
        }
        return new LLMClient.ResponseFormatText();
    }

    private static LLMClient.ToolChoice convertToCompletionRequestToolChoice(OpenAIChatCompletionRequest openAIChatCompletionRequest) {
        if (openAIChatCompletionRequest.toolChoice == null) {
            return null;
        }
        if (openAIChatCompletionRequest.toolChoice instanceof OpenAIChatCompletionRequest.OpenAIChatCompletionRequestNoneToolChoice) {
            return new LLMClient.NoneToolChoice();
        }
        if (openAIChatCompletionRequest.toolChoice instanceof OpenAIChatCompletionRequest.OpenAIChatCompletionRequestRequiredToolChoice) {
            return new LLMClient.RequiredToolChoice();
        }
        if (openAIChatCompletionRequest.toolChoice instanceof OpenAIChatCompletionRequest.OpenAIChatCompletionRequestAutoToolChoice) {
            return new LLMClient.AutoToolChoice();
        }
        if (openAIChatCompletionRequest.toolChoice instanceof OpenAIChatCompletionRequest.OpenAIChatCompletionRequestFunctionToolChoice) {
            LLMClient.NamedToolChoice namedToolChoice = new LLMClient.NamedToolChoice();
            OpenAIChatCompletionRequest.OpenAIChatCompletionRequestFunctionToolChoice toolChoice = (OpenAIChatCompletionRequest.OpenAIChatCompletionRequestFunctionToolChoice)openAIChatCompletionRequest.toolChoice;
            if (toolChoice.function == null) {
                throw new DKUControllerBase.MalformedRequestException("Function cannot be null for tool choice of type function");
            }
            namedToolChoice.name = toolChoice.function.name;
            return namedToolChoice;
        }
        throw new DKUControllerBase.MalformedRequestException("Unsupported tool choice");
    }

    public static OpenAIChatCompletionResponse convertToOpenAIResponse(OpenAIChatCompletionRequest request, PublicAPILLMController.CompletionsResponse completionsResponse) {
        if (completionsResponse.responses == null || completionsResponse.responses.isEmpty()) {
            throw new IllegalArgumentException("No completion response found");
        }
        if (completionsResponse.responses.size() > 1) {
            throw new IllegalArgumentException("Unsupported multiple responses for request: " + JSON.sampleJson((Object)request, (int)120));
        }
        LLMClient.SimpleCompletionResponseOrError simpleCompletionResponseOrError = completionsResponse.responses.get(0);
        OpenAIChatCompletionResponse openAIChatCompletionResponse = new OpenAIChatCompletionResponse();
        if (!simpleCompletionResponseOrError.ok) {
            OpenAIChatCompletionResponse.OpenAIChatCompletionError completionError = new OpenAIChatCompletionResponse.OpenAIChatCompletionError();
            completionError.message = simpleCompletionResponseOrError.errorMessage;
            if (simpleCompletionResponseOrError.errorType == LLMClient.LLMErrorType.REFUSAL) {
                openAIChatCompletionResponse.choices = new ArrayList<OpenAIChatCompletionResponse.OpenAIChatCompletionChoice>();
                OpenAIChatCompletionResponse.OpenAIChatCompletionChoice choice = new OpenAIChatCompletionResponse.OpenAIChatCompletionChoice();
                choice.message = new OpenAIChatCompletionResponse.OpenAIChatCompletionMessage();
                choice.message.role = "assistant";
                choice.index = 0;
                choice.finishReason = LLMClient.FinishReason.STOP.toString();
                choice.message.refusal = simpleCompletionResponseOrError.errorMessage;
                openAIChatCompletionResponse.choices.add(choice);
                openAIChatCompletionResponse.usage = new OpenAIChatCompletionResponse.OpenAIChatCompletionUsage();
                openAIChatCompletionResponse.usage.completionTokens = simpleCompletionResponseOrError.completionTokens;
                openAIChatCompletionResponse.usage.promptTokens = simpleCompletionResponseOrError.promptTokens;
                openAIChatCompletionResponse.usage.totalTokens = simpleCompletionResponseOrError.totalTokens;
                openAIChatCompletionResponse.created = System.currentTimeMillis() / 1000L;
                openAIChatCompletionResponse.model = request.model;
            } else {
                openAIChatCompletionResponse.error = completionError;
            }
            return openAIChatCompletionResponse;
        }
        openAIChatCompletionResponse.created = System.currentTimeMillis() / 1000L;
        openAIChatCompletionResponse.model = request.model;
        openAIChatCompletionResponse.choices = Lists.newArrayList((Object[])new OpenAIChatCompletionResponse.OpenAIChatCompletionChoice[]{OpenAIAPIConverter.convertToOpenAIChatCompletionChoice(simpleCompletionResponseOrError)});
        openAIChatCompletionResponse.usage = new OpenAIChatCompletionResponse.OpenAIChatCompletionUsage();
        openAIChatCompletionResponse.usage.completionTokens = simpleCompletionResponseOrError.completionTokens;
        openAIChatCompletionResponse.usage.promptTokens = simpleCompletionResponseOrError.promptTokens;
        openAIChatCompletionResponse.usage.totalTokens = simpleCompletionResponseOrError.totalTokens;
        return openAIChatCompletionResponse;
    }

    private static OpenAIChatCompletionResponse.OpenAIChatCompletionChoice convertToOpenAIChatCompletionChoice(LLMClient.SimpleCompletionResponseOrError simpleCompletionResponseOrError) {
        OpenAIChatCompletionResponse.OpenAIChatCompletionChoice openAIChatCompletionChoice = new OpenAIChatCompletionResponse.OpenAIChatCompletionChoice();
        openAIChatCompletionChoice.index = 0;
        if (simpleCompletionResponseOrError.finishReason != null) {
            openAIChatCompletionChoice.finishReason = simpleCompletionResponseOrError.finishReason == LLMClient.FinishReason.UNKNOWN ? LLMClient.FinishReason.LENGTH.toString() : simpleCompletionResponseOrError.finishReason.toString();
        }
        openAIChatCompletionChoice.message = new OpenAIChatCompletionResponse.OpenAIChatCompletionMessage();
        openAIChatCompletionChoice.message.content = simpleCompletionResponseOrError.text;
        openAIChatCompletionChoice.message.role = "assistant";
        if (simpleCompletionResponseOrError.logProbs != null) {
            openAIChatCompletionChoice.logprobs = OpenAIAPIConverter.convertToOpenAIChatLogProbs(simpleCompletionResponseOrError.logProbs);
        }
        if (simpleCompletionResponseOrError.toolCalls != null) {
            openAIChatCompletionChoice.message.toolCalls = OpenAIAPIConverter.convertToOpenAIToolCalls(simpleCompletionResponseOrError.toolCalls);
        }
        return openAIChatCompletionChoice;
    }

    public static PublicAPILLMController.FullCompletionRequest convertToFullCompletionRequest(OpenAIChatCompletionRequest openAIChatCompletionRequest) {
        PublicAPILLMController.FullCompletionRequest fullCompletionRequest = new PublicAPILLMController.FullCompletionRequest();
        fullCompletionRequest.llmId = openAIChatCompletionRequest.model;
        fullCompletionRequest.query = OpenAIAPIConverter.convertToSingleCompletionQuery(openAIChatCompletionRequest);
        LLMClient.CompletionSettings completionSettings = new LLMClient.CompletionSettings();
        completionSettings.frequencyPenalty = openAIChatCompletionRequest.frequencyPenalty;
        completionSettings.logProbs = openAIChatCompletionRequest.logprobs;
        completionSettings.logitBias = openAIChatCompletionRequest.logitBias;
        completionSettings.maxOutputTokens = openAIChatCompletionRequest.maxTokens;
        completionSettings.presencePenalty = openAIChatCompletionRequest.presencePenalty;
        completionSettings.stopSequences = openAIChatCompletionRequest.stop;
        completionSettings.temperature = openAIChatCompletionRequest.temperature;
        completionSettings.topP = openAIChatCompletionRequest.topP;
        completionSettings.responseFormat = OpenAIAPIConverter.convertToResponseFormat(openAIChatCompletionRequest);
        completionSettings.topLogProbs = openAIChatCompletionRequest.topLogprobs;
        completionSettings.tools = OpenAIAPIConverter.convertToCompletionRequestTools(openAIChatCompletionRequest);
        completionSettings.toolChoice = OpenAIAPIConverter.convertToCompletionRequestToolChoice(openAIChatCompletionRequest);
        if (!StringUtils.isEmpty((CharSequence)openAIChatCompletionRequest.reasoningEffort)) {
            if (openAIChatCompletionRequest.reasoningEffort.equals("OFF")) {
                completionSettings.reasoningEffort = LLMClient.ReasoningEffort.OFF;
            } else if (openAIChatCompletionRequest.reasoningEffort.equals("STANDARD")) {
                completionSettings.reasoningEffort = LLMClient.ReasoningEffort.STANDARD;
            } else {
                completionSettings.reasoningEffort = LLMClient.ReasoningEffort.CUSTOM;
                completionSettings.customReasoningEffort = openAIChatCompletionRequest.reasoningEffort;
            }
        }
        fullCompletionRequest.settings = completionSettings;
        return fullCompletionRequest;
    }

    private static List<LLMClient.AbstractTool> convertToCompletionRequestTools(OpenAIChatCompletionRequest openAIChatCompletionRequest) {
        if (openAIChatCompletionRequest.tools == null) {
            return null;
        }
        ArrayList<LLMClient.AbstractTool> tools = new ArrayList<LLMClient.AbstractTool>();
        for (OpenAIChatCompletionRequest.OpenAIChatCompletionRequestAbstractTool tool : openAIChatCompletionRequest.tools) {
            if (!(tool instanceof OpenAIChatCompletionRequest.OpenAIChatCompletionRequestFunctionTool)) continue;
            OpenAIChatCompletionRequest.OpenAIChatCompletionRequestFunctionTool openAIChatCompletionRequestFunctionTool = (OpenAIChatCompletionRequest.OpenAIChatCompletionRequestFunctionTool)tool;
            if (openAIChatCompletionRequestFunctionTool.function == null) {
                throw new DKUControllerBase.MalformedRequestException("Tool function cannot be null");
            }
            LLMClient.FunctionTool functionTool = new LLMClient.FunctionTool();
            functionTool.function = new LLMClient.FunctionToolDesc();
            functionTool.function.name = openAIChatCompletionRequestFunctionTool.function.name;
            functionTool.function.description = openAIChatCompletionRequestFunctionTool.function.description;
            functionTool.function.setParameters(openAIChatCompletionRequestFunctionTool.function.parameters);
            tools.add((LLMClient.AbstractTool)functionTool);
        }
        return tools;
    }

    private static LLMClient.SingleCompletionQuery convertToSingleCompletionQuery(OpenAIChatCompletionRequest openAIChatCompletionRequest) {
        LLMClient.SingleCompletionQuery completionQuery = new LLMClient.SingleCompletionQuery();
        completionQuery.messages = new ArrayList();
        for (OpenAIChatCompletionRequest.OpenAIChatCompletionRequestMessage message : openAIChatCompletionRequest.messages) {
            LLMClient.ChatMessage chatMessage = null;
            if (message instanceof OpenAIChatCompletionRequest.OpenAIChatCompletionRequestUserMessage) {
                chatMessage = OpenAIAPIConverter.createChatMessageWithContent("user", ((OpenAIChatCompletionRequest.OpenAIChatCompletionRequestUserMessage)message).content.text, ((OpenAIChatCompletionRequest.OpenAIChatCompletionRequestUserMessage)message).content.parts);
            } else if (message instanceof OpenAIChatCompletionRequest.OpenAIChatCompletionRequestSystemMessage) {
                chatMessage = OpenAIAPIConverter.createChatMessageWithContent("system", ((OpenAIChatCompletionRequest.OpenAIChatCompletionRequestSystemMessage)message).content.text, ((OpenAIChatCompletionRequest.OpenAIChatCompletionRequestSystemMessage)message).content.parts);
            } else if (message instanceof OpenAIChatCompletionRequest.OpenAIChatCompletionRequestAssistantMessage) {
                OpenAIChatCompletionRequest.OpenAIChatCompletionRequestAssistantMessage assistantMessage = (OpenAIChatCompletionRequest.OpenAIChatCompletionRequestAssistantMessage)message;
                if (assistantMessage.content != null) {
                    chatMessage = OpenAIAPIConverter.createChatMessageWithContent("assistant", assistantMessage.content.text, assistantMessage.content.parts);
                } else {
                    chatMessage = new LLMClient.ChatMessage();
                    chatMessage.role = "assistant";
                }
                if (assistantMessage.toolCalls != null) {
                    ArrayList<LLMClient.FunctionToolCall> toolCalls = new ArrayList<LLMClient.FunctionToolCall>();
                    int index = 0;
                    for (OpenAIChatCompletionRequest.OpenAIChatCompletionRequestToolCall openAIChatCompletionRequestToolCall : assistantMessage.toolCalls) {
                        if (!(openAIChatCompletionRequestToolCall instanceof OpenAIChatCompletionRequest.OpenAIChatCompletionRequestFunctionToolCall)) continue;
                        LLMClient.FunctionToolCall toolCall = new LLMClient.FunctionToolCall();
                        OpenAIChatCompletionRequest.OpenAIChatCompletionRequestFunctionToolCall openAIChatCompletionRequestFunctionToolCall = (OpenAIChatCompletionRequest.OpenAIChatCompletionRequestFunctionToolCall)openAIChatCompletionRequestToolCall;
                        if (openAIChatCompletionRequestFunctionToolCall.function == null) {
                            throw new DKUControllerBase.MalformedRequestException("Tool call function cannot be null");
                        }
                        toolCall.id = openAIChatCompletionRequestToolCall.id;
                        toolCall.index = index++;
                        toolCall.function = new LLMClient.FunctionToolCallInfo();
                        toolCall.function.name = openAIChatCompletionRequestFunctionToolCall.function.name;
                        toolCall.function.arguments = openAIChatCompletionRequestFunctionToolCall.function.arguments;
                        toolCalls.add(toolCall);
                    }
                    chatMessage.toolCalls = toolCalls;
                }
            } else if (message instanceof OpenAIChatCompletionRequest.OpenAIChatCompletionRequestToolMessage) {
                chatMessage = new LLMClient.ChatMessage();
                chatMessage.role = "tool";
                OpenAIChatCompletionRequest.OpenAIChatCompletionRequestToolMessage toolMessage = (OpenAIChatCompletionRequest.OpenAIChatCompletionRequestToolMessage)message;
                LLMClient.ToolOutput toolOutput = new LLMClient.ToolOutput();
                if (toolMessage.content.parts != null) {
                    throw new DKUControllerBase.MalformedRequestException("Multi-modal input for tool messages is not supported");
                }
                toolOutput.output = toolMessage.content.text;
                toolOutput.callId = toolMessage.toolCallId;
                chatMessage.toolOutputs = List.of(toolOutput);
            }
            completionQuery.messages.add(chatMessage);
        }
        return completionQuery;
    }

    private static LLMClient.ChatMessage createChatMessageWithContent(String role, String text, List<OpenAIChatCompletionRequest.OpenAIChatCompletionMessageContentPart> parts) {
        if (parts != null && !parts.isEmpty()) {
            return new LLMClient.ChatMessage(role, OpenAIAPIConverter.convertToChatMessageParts(parts));
        }
        return new LLMClient.ChatMessage(role, text);
    }

    private static List<LLMClient.ChatMessagePart> convertToChatMessageParts(List<OpenAIChatCompletionRequest.OpenAIChatCompletionMessageContentPart> parts) {
        ArrayList<LLMClient.ChatMessagePart> chatMessageParts = new ArrayList<LLMClient.ChatMessagePart>();
        for (OpenAIChatCompletionRequest.OpenAIChatCompletionMessageContentPart part : parts) {
            LLMClient.ChatMessagePart messagePart = new LLMClient.ChatMessagePart();
            if (part.type.equals("image_url") && part.imageUrl != null) {
                Matcher matcher = inlineImageMatcherPattern.matcher(part.imageUrl.url);
                if (matcher.find()) {
                    messagePart.type = LLMClient.ChatMessagePartType.IMAGE_INLINE;
                    messagePart.imageMimeType = matcher.group(1);
                    messagePart.inlineImage = matcher.group(2);
                } else {
                    messagePart.type = LLMClient.ChatMessagePartType.IMAGE_URI;
                    messagePart.imageUrl = part.imageUrl.url;
                }
            } else {
                messagePart.text = part.text;
                messagePart.type = LLMClient.ChatMessagePartType.TEXT;
            }
            chatMessageParts.add(messagePart);
        }
        return chatMessageParts;
    }

    public static OpenAIChatCompletionResponse.OpenAIChatCompletionChunkResponse convertToOpenAIChunkResponse(String model, String responseId, LLMClient.StreamedCompletionResponseChunk chunk) {
        OpenAIChatCompletionResponse.OpenAIChatCompletionChunkResponse openAIChatCompletionChunkResponse = new OpenAIChatCompletionResponse.OpenAIChatCompletionChunkResponse();
        openAIChatCompletionChunkResponse.id = responseId;
        openAIChatCompletionChunkResponse.created = System.currentTimeMillis() / 1000L;
        openAIChatCompletionChunkResponse.model = model;
        openAIChatCompletionChunkResponse.object = "chat.completion.chunk";
        OpenAIChatCompletionResponse.OpenAIChatCompletionChunkResponseChoice openAIChatCompletionChoice = new OpenAIChatCompletionResponse.OpenAIChatCompletionChunkResponseChoice();
        openAIChatCompletionChoice.index = 0;
        openAIChatCompletionChoice.delta = new OpenAIChatCompletionResponse.OpenAIChatCompletionChunkDelta();
        openAIChatCompletionChoice.delta.content = chunk.text;
        openAIChatCompletionChoice.delta.role = "assistant";
        if (chunk.logProbs != null) {
            openAIChatCompletionChoice.logprobs = OpenAIAPIConverter.convertToOpenAIChatLogProbs(chunk.logProbs);
        }
        if (chunk.toolCalls != null) {
            openAIChatCompletionChoice.delta.toolCalls = OpenAIAPIConverter.convertToOpenAIToolCalls(chunk.toolCalls);
        }
        openAIChatCompletionChunkResponse.choices = Lists.newArrayList((Object[])new OpenAIChatCompletionResponse.OpenAIChatCompletionChunkResponseChoice[]{openAIChatCompletionChoice});
        return openAIChatCompletionChunkResponse;
    }

    private static List<OpenAIChatCompletionResponse.OpenAIChatCompletionAbstractToolCall> convertToOpenAIToolCalls(List<LLMClient.AbstractToolCall> chunk) {
        ArrayList<OpenAIChatCompletionResponse.OpenAIChatCompletionAbstractToolCall> toolCallsList = new ArrayList<OpenAIChatCompletionResponse.OpenAIChatCompletionAbstractToolCall>();
        for (LLMClient.AbstractToolCall toolCall : chunk) {
            if (!(toolCall instanceof LLMClient.FunctionToolCall)) continue;
            LLMClient.FunctionToolCall functionToolCall = (LLMClient.FunctionToolCall)toolCall;
            if (functionToolCall.function == null) {
                throw new RuntimeException("Unexpected null value on tool call function");
            }
            OpenAIChatCompletionResponse.OpenAIChatCompletionFunctionToolCall openAIChatCompletionFunctionToolCall = new OpenAIChatCompletionResponse.OpenAIChatCompletionFunctionToolCall();
            openAIChatCompletionFunctionToolCall.id = functionToolCall.id;
            openAIChatCompletionFunctionToolCall.index = functionToolCall.index == null ? functionToolCall.id.hashCode() : functionToolCall.index.intValue();
            openAIChatCompletionFunctionToolCall.function = new OpenAIChatCompletionResponse.OpenAIChatCompletionFunctionToolCallInfo();
            openAIChatCompletionFunctionToolCall.function.name = functionToolCall.function.name;
            openAIChatCompletionFunctionToolCall.function.arguments = functionToolCall.function.arguments;
            toolCallsList.add(openAIChatCompletionFunctionToolCall);
        }
        return toolCallsList;
    }

    private static OpenAIChatCompletionResponse.OpenAIChatLogProbs convertToOpenAIChatLogProbs(List<LLMClient.DetailedLogProb> chunk) {
        OpenAIChatCompletionResponse.OpenAIChatLogProbs openAIChatLogProbs = new OpenAIChatCompletionResponse.OpenAIChatLogProbs();
        ArrayList<OpenAIChatCompletionResponse.OpenAIChatLogProbContent> logProbContentList = new ArrayList<OpenAIChatCompletionResponse.OpenAIChatLogProbContent>();
        for (LLMClient.DetailedLogProb logProb : chunk) {
            OpenAIChatCompletionResponse.OpenAIChatLogProbContent openAIChatLogProbContent = new OpenAIChatCompletionResponse.OpenAIChatLogProbContent();
            openAIChatLogProbContent.token = logProb.token;
            openAIChatLogProbContent.logprob = logProb.logProb;
            openAIChatLogProbContent.bytes = logProb.token.getBytes(StandardCharsets.UTF_8);
            if (logProb.topLogProbs != null) {
                ArrayList<OpenAIChatCompletionResponse.OpenAIChatTopLogProb> topLogProbList = new ArrayList<OpenAIChatCompletionResponse.OpenAIChatTopLogProb>();
                for (LLMClient.SimpleLogProb topLogProb : logProb.topLogProbs) {
                    OpenAIChatCompletionResponse.OpenAIChatTopLogProb openAIChatTopLogProb = new OpenAIChatCompletionResponse.OpenAIChatTopLogProb();
                    openAIChatTopLogProb.token = topLogProb.token;
                    openAIChatTopLogProb.logprob = topLogProb.logProb;
                    openAIChatTopLogProb.bytes = topLogProb.token.getBytes(StandardCharsets.UTF_8);
                    topLogProbList.add(openAIChatTopLogProb);
                }
                openAIChatLogProbContent.topLogprobs = topLogProbList;
            }
            logProbContentList.add(openAIChatLogProbContent);
        }
        openAIChatLogProbs.content = logProbContentList;
        return openAIChatLogProbs;
    }

    public static OpenAIChatCompletionResponse.OpenAIChatCompletionChunkResponse convertToOpenAIChunkResponse(String model, String responseId, LLMClient.StreamedCompletionResponseFooter footer, boolean hasStreamedToolCalls) {
        OpenAIChatCompletionResponse.OpenAIChatCompletionChunkResponse openAIChatCompletionChunkResponse = new OpenAIChatCompletionResponse.OpenAIChatCompletionChunkResponse();
        openAIChatCompletionChunkResponse.id = responseId;
        openAIChatCompletionChunkResponse.created = System.currentTimeMillis() / 1000L;
        openAIChatCompletionChunkResponse.model = model;
        openAIChatCompletionChunkResponse.object = "chat.completion.chunk";
        OpenAIChatCompletionResponse.OpenAIChatCompletionChunkResponseChoice chatCompletionChunkResponseChoice = new OpenAIChatCompletionResponse.OpenAIChatCompletionChunkResponseChoice();
        chatCompletionChunkResponseChoice.index = 0;
        chatCompletionChunkResponseChoice.delta = new OpenAIChatCompletionResponse.OpenAIChatCompletionChunkDelta();
        LLMClient.FinishReason reason = footer.finishReason;
        if (reason == null || reason == LLMClient.FinishReason.UNKNOWN) {
            reason = LLMClient.FinishReason.STOP;
        }
        if (hasStreamedToolCalls && reason == LLMClient.FinishReason.STOP) {
            reason = LLMClient.FinishReason.TOOL_CALLS;
        }
        chatCompletionChunkResponseChoice.finishReason = reason.toString();
        openAIChatCompletionChunkResponse.choices = Lists.newArrayList((Object[])new OpenAIChatCompletionResponse.OpenAIChatCompletionChunkResponseChoice[]{chatCompletionChunkResponseChoice});
        return openAIChatCompletionChunkResponse;
    }

    public static OpenAIChatCompletionResponse.OpenAIChatCompletionChunkResponse convertToOpenAIRefusalLastChunk(String model, String responseId) {
        OpenAIChatCompletionResponse.OpenAIChatCompletionChunkResponse openAIChatCompletionChunkResponse = new OpenAIChatCompletionResponse.OpenAIChatCompletionChunkResponse();
        openAIChatCompletionChunkResponse.id = responseId;
        openAIChatCompletionChunkResponse.created = System.currentTimeMillis() / 1000L;
        openAIChatCompletionChunkResponse.model = model;
        openAIChatCompletionChunkResponse.object = "chat.completion.chunk";
        OpenAIChatCompletionResponse.OpenAIChatCompletionChunkResponseChoice chatCompletionChunkResponseChoice = new OpenAIChatCompletionResponse.OpenAIChatCompletionChunkResponseChoice();
        chatCompletionChunkResponseChoice.index = 0;
        chatCompletionChunkResponseChoice.delta = new OpenAIChatCompletionResponse.OpenAIChatCompletionChunkDelta();
        chatCompletionChunkResponseChoice.finishReason = LLMClient.FinishReason.STOP.toString();
        openAIChatCompletionChunkResponse.choices = Lists.newArrayList((Object[])new OpenAIChatCompletionResponse.OpenAIChatCompletionChunkResponseChoice[]{chatCompletionChunkResponseChoice});
        return openAIChatCompletionChunkResponse;
    }

    public static OpenAIChatCompletionResponse.OpenAIChatCompletionChunkResponse convertToOpenAIChunkUsageResponse(String model, String responseId, LLMClient.StreamedCompletionResponseFooter footer) {
        OpenAIChatCompletionResponse.OpenAIChatCompletionChunkResponse openAIChatCompletionChunkResponse = new OpenAIChatCompletionResponse.OpenAIChatCompletionChunkResponse();
        openAIChatCompletionChunkResponse.id = responseId;
        openAIChatCompletionChunkResponse.created = System.currentTimeMillis() / 1000L;
        openAIChatCompletionChunkResponse.model = model;
        openAIChatCompletionChunkResponse.object = "chat.completion.chunk";
        openAIChatCompletionChunkResponse.choices = Lists.newArrayList();
        openAIChatCompletionChunkResponse.usage = new OpenAIChatCompletionResponse.OpenAIChatCompletionUsage();
        openAIChatCompletionChunkResponse.usage.completionTokens = footer.completionTokens;
        openAIChatCompletionChunkResponse.usage.promptTokens = footer.promptTokens;
        openAIChatCompletionChunkResponse.usage.totalTokens = footer.totalTokens;
        return openAIChatCompletionChunkResponse;
    }

    public static OpenAIChatCompletionResponse.OpenAIChatCompletionChunkResponse convertToOpenAIRefusalUsage(String model, String responseId, LLMClient.SimpleCompletionResponseOrError error) {
        OpenAIChatCompletionResponse.OpenAIChatCompletionChunkResponse openAIChatCompletionChunkResponse = new OpenAIChatCompletionResponse.OpenAIChatCompletionChunkResponse();
        openAIChatCompletionChunkResponse.id = responseId;
        openAIChatCompletionChunkResponse.created = System.currentTimeMillis() / 1000L;
        openAIChatCompletionChunkResponse.model = model;
        openAIChatCompletionChunkResponse.object = "chat.completion.chunk";
        openAIChatCompletionChunkResponse.choices = Lists.newArrayList();
        openAIChatCompletionChunkResponse.usage = new OpenAIChatCompletionResponse.OpenAIChatCompletionUsage();
        openAIChatCompletionChunkResponse.usage.completionTokens = error.completionTokens;
        openAIChatCompletionChunkResponse.usage.promptTokens = error.promptTokens;
        openAIChatCompletionChunkResponse.usage.totalTokens = error.totalTokens;
        return openAIChatCompletionChunkResponse;
    }

    public static OpenAIChatCompletionResponse.OpenAIChatCompletionChunkResponse convertToOpenAIRefusalChunk(String model, String responseId, LLMClient.SimpleCompletionResponseOrError error) {
        OpenAIChatCompletionResponse.OpenAIChatCompletionChunkResponse openAIChatCompletionChunkResponse = new OpenAIChatCompletionResponse.OpenAIChatCompletionChunkResponse();
        openAIChatCompletionChunkResponse.id = responseId;
        openAIChatCompletionChunkResponse.created = System.currentTimeMillis() / 1000L;
        openAIChatCompletionChunkResponse.model = model;
        openAIChatCompletionChunkResponse.object = "chat.completion.chunk";
        openAIChatCompletionChunkResponse.choices = new ArrayList<OpenAIChatCompletionResponse.OpenAIChatCompletionChunkResponseChoice>();
        OpenAIChatCompletionResponse.OpenAIChatCompletionChunkResponseChoice choice = new OpenAIChatCompletionResponse.OpenAIChatCompletionChunkResponseChoice();
        choice.delta = new OpenAIChatCompletionResponse.OpenAIChatCompletionChunkDelta();
        choice.delta.role = "assistant";
        choice.delta.refusal = error.errorMessage;
        choice.index = 0;
        openAIChatCompletionChunkResponse.choices.add(choice);
        return openAIChatCompletionChunkResponse;
    }
}

