/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.server.api.projects;

import com.dataiku.common.server.DKUControllerBase;
import com.dataiku.dip.ApplicativeException;
import com.dataiku.dip.DKUApp;
import com.dataiku.dip.aiexplanations.ExplainStuffFrontendResponse;
import com.dataiku.dip.aiexplanations.flow.AIFlowExplanationService;
import com.dataiku.dip.apideployer.datamodel.actual.AbstractProjectDeploymentHeavyStatus;
import com.dataiku.dip.coremodel.AppManifest;
import com.dataiku.dip.coremodel.Dataset;
import com.dataiku.dip.coremodel.ExposedObject;
import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.coremodel.ObjectCompleteMetadata;
import com.dataiku.dip.coremodel.SerializedDataset;
import com.dataiku.dip.coremodel.SerializedProject;
import com.dataiku.dip.cuspol.CustomFieldsService;
import com.dataiku.dip.dao.DatasetsDAO;
import com.dataiku.dip.dao.InterestsInternalDB;
import com.dataiku.dip.dao.StreamingEndpointsDAO;
import com.dataiku.dip.datasets.DatasetUtils;
import com.dataiku.dip.datasets.fs.hdfs.HDFSPermissionsSynchronizer;
import com.dataiku.dip.discussions.DiscussionsService;
import com.dataiku.dip.futures.FutureProgress;
import com.dataiku.dip.futures.FutureProgressState;
import com.dataiku.dip.futures.FutureResponse;
import com.dataiku.dip.futures.FutureService;
import com.dataiku.dip.managedfolder.ManagedFoldersService;
import com.dataiku.dip.metrics.ChecksSet;
import com.dataiku.dip.metrics.ProbesSet;
import com.dataiku.dip.metrics.checks.AbstractCheckContext;
import com.dataiku.dip.projects.apps.AppsService;
import com.dataiku.dip.projects.importexport.ProjectExporter;
import com.dataiku.dip.projects.importexport.ProjectImporter;
import com.dataiku.dip.projects.importexport.model.BundleContainerSettings;
import com.dataiku.dip.projects.importexport.model.BundleExporterSettings;
import com.dataiku.dip.projects.importexport.model.ProjectDuplicateOptions;
import com.dataiku.dip.projects.importexport.model.ProjectExportOptions;
import com.dataiku.dip.scheduler.scenarios.Scenario;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.DSSAuthCtx;
import com.dataiku.dip.security.IPermissionsService;
import com.dataiku.dip.security.PermissionsWatcher;
import com.dataiku.dip.security.PermissionsWatchersService;
import com.dataiku.dip.security.Privileges;
import com.dataiku.dip.security.audit.AuditTrailService;
import com.dataiku.dip.security.auth.MetaAuthService;
import com.dataiku.dip.server.api.PublicAPIControllerBase;
import com.dataiku.dip.server.api.projects.ProjectPermissions;
import com.dataiku.dip.server.controllers.AuditInline;
import com.dataiku.dip.server.controllers.AuditedCall;
import com.dataiku.dip.server.controllers.ProjectImportExportController;
import com.dataiku.dip.server.datasets.DatasetAccessService;
import com.dataiku.dip.server.datasets.DatasetRenameService;
import com.dataiku.dip.server.notifications.backend.TaggableObjectChangedEvent;
import com.dataiku.dip.server.recipes.RecipeSaveService;
import com.dataiku.dip.server.services.ExposedObjectsService;
import com.dataiku.dip.server.services.ITaggingService;
import com.dataiku.dip.server.services.InterestsService;
import com.dataiku.dip.server.services.ProjectFoldersService;
import com.dataiku.dip.server.services.ProjectsService;
import com.dataiku.dip.server.services.ReadOnlyJobsInternalDB;
import com.dataiku.dip.server.services.ScenariosService;
import com.dataiku.dip.server.services.TaggableObjectsService;
import com.dataiku.dip.server.services.TaggingService;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.server.services.dataquality.DataQualitySummaryService;
import com.dataiku.dip.timelines.TimelinesService;
import com.dataiku.dip.transactions.git.jgit.ProjectsJGitService;
import com.dataiku.dip.transactions.ifaces.RWTransaction;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.dataiku.dip.util.DKUExecutors;
import com.dataiku.dip.util.Id;
import com.dataiku.dip.util.SecretKeyGenerator;
import com.dataiku.dip.utils.DKUFileUtils;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.ErrorContext;
import com.dataiku.dip.utils.ExceptionUtils;
import com.dataiku.dip.utils.JSON;
import com.dataiku.dip.variables.VariablesContext;
import com.dataiku.dip.variables.VariablesService;
import com.dataiku.dip.webapps.WebAppsService;
import com.dataiku.dss.shadelib.com.google.common.base.Preconditions;
import com.dataiku.dss.shadelib.org.joda.time.DateTime;
import com.google.gson.JsonObject;
import com.google.gson.reflect.TypeToken;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.File;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.ServletRequestUtils;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;

@Controller
@RequestMapping(value={"/publicapi/projects"})
public class PublicAPIProjectsController
extends PublicAPIControllerBase {
    @Autowired
    private MetaAuthService authService;
    @Autowired
    private IPermissionsService permissionsService;
    @Autowired
    private ProjectsService projectsService;
    @Autowired
    private ProjectsJGitService projectsGitService;
    @Autowired
    private TransactionService transactionService;
    @Autowired
    private VariablesService variablesService;
    @Autowired
    private TaggingService taggingService;
    @Autowired
    private AuditTrailService auditTrailService;
    @Autowired
    private DiscussionsService discussionsService;
    @Autowired
    private CustomFieldsService customFieldsService;
    @Autowired
    private ProjectFoldersService projectFoldersService;
    @Autowired
    private AppsService appsService;
    @Autowired
    private ExposedObjectsService exposedObjectsService;
    @Autowired
    private PermissionsWatchersService permissionsWatchersService;
    @Autowired
    private ScenariosService scenariosService;
    @Autowired
    private TimelinesService timelinesService;
    @Autowired
    private InterestsService interestsService;
    @Autowired
    private DatasetAccessService datasetAccessService;
    @Autowired
    private DatasetsDAO datasetsDAO;
    @Autowired
    private StreamingEndpointsDAO streamingEndpointsDAO;
    @Autowired
    private DatasetRenameService datasetRenameService;
    @Autowired
    private RecipeSaveService recipeSaveService;
    @Autowired
    private ManagedFoldersService managedFolderService;
    @Autowired
    private DataQualitySummaryService dataQualitySummaryService;
    @Autowired
    private ReadOnlyJobsInternalDB readOnlyJobsInternalDB;
    @Autowired
    private WebAppsService webAppsService;
    @Autowired
    private AIFlowExplanationService aiFlowExplanationService;
    @Autowired
    private FutureService futureService;
    @Autowired
    private ProjectImportExportController internalController;
    private static final DKULogger logger = DKULogger.getLogger((String)"dku.api.projects");

    @AuditedCall(value={"msgType", "projects-list"})
    @RequestMapping(value={"/"}, method={RequestMethod.GET})
    @ResponseBody
    public List<ProjectsService.UIProject> list(HttpServletRequest req, @RequestParam(value="tags", required=false) String[] tagList, @RequestParam(defaultValue="false") boolean includeLocation) throws Exception {
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx authCtx = this.authService.getTicketOrKey(req);
            assert (authCtx != null);
            ArrayList<ProjectsService.UIProject> projects = new ArrayList<ProjectsService.UIProject>();
            for (String projectKey : this.projectsService.listKeys()) {
                if (!this.permissionsService.hasAnyProjectAccess(authCtx, projectKey)) continue;
                projects.add(this.projectsService.getSummary(authCtx, projectKey, includeLocation));
            }
            if (tagList != null && tagList.length > 0) {
                ArrayList<ProjectsService.UIProject> unfiltered = projects;
                projects = new ArrayList();
                block6: for (ProjectsService.UIProject p : unfiltered) {
                    for (String tag : tagList) {
                        if (!p.tags.contains(tag)) continue;
                        projects.add(p);
                        continue block6;
                    }
                }
            }
            ArrayList<ProjectsService.UIProject> arrayList = projects;
            return arrayList;
        }
    }

    @AuditInline
    @RequestMapping(value={"/"}, method={RequestMethod.POST})
    @ResponseBody
    public PublicAPIControllerBase.ResponseMessage create(HttpServletRequest req, HttpServletResponse resp, @RequestParam(required=false) String projectFolderId, @RequestBody SerializedProject project) throws Exception {
        this.customFieldsService.enrichWithDefaultCustomFieldsForTaggableObject((TaggableObjectsService.TaggableObject)project);
        this.require(StringUtils.isNotBlank((String)project.projectKey), "Required field 'projectKey' is missing.");
        this.require(ProjectsService.isValidProjectKey((String)project.projectKey), "Field 'projectKey' contains invalid character");
        this.require(StringUtils.isNotBlank((String)project.name), "Required field 'name' is missing.");
        this.require(StringUtils.isNotBlank((String)project.owner), "Required field 'owner' is missing.");
        this.checkPermissionsAreValid(project.permissions);
        if (project.tags != null) {
            this.require(project.tags.stream().noneMatch(StringUtils::isBlank), "Cannot set empty tags for a project");
        }
        DSSAuthCtx authCtx = (DSSAuthCtx)this.authService.getTicketOrKey_NT(req);
        try (RWTransaction t = this.transactionService.beginWriteAsLoggedInUser((AuthCtx)authCtx);){
            if (authCtx.getAuthSource() == AuthCtx.AuthSource.CONFIGURABLE_API_KEY_PROJECT || !authCtx.getPermissions().mayCreateProjects()) {
                throw new SecurityException("You may not create new projects");
            }
            if (this.projectsService.getOrNullUnsafe(project.projectKey) != null) {
                throw new DKUControllerBase.MalformedRequestException("Project " + project.projectKey + " already exists");
            }
            PermissionsWatcher pw = this.permissionsWatchersService.startProjectWatch(project.projectKey);
            project.permissionsVersion = SerializedProject.PermissionsVersion.V2;
            this.projectsService.create(project, TaggableObjectChangedEvent.ProjectEditSubtype.UNKNOWN, projectFolderId);
            pw.stop();
            t.commit("Created project " + project.projectKey);
            this.auditTrailService.generic("project-create").with("projectKey", project.projectKey).emit();
        }
        this.projectsGitService.addProjectVersionTag_NT((AuthCtx)authCtx, project.projectKey);
        return new PublicAPIControllerBase.ResponseMessage("Created project " + project.projectKey);
    }

    @AuditedCall(value={"msgType", "project-get-summary", "projectKey", "${projectKey}"})
    @RequestMapping(value={"/{projectKey}"}, method={RequestMethod.GET})
    @ResponseBody
    public ProjectsService.UIProject getSummary(HttpServletRequest req, @PathVariable String projectKey) throws Exception {
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx authCtx = this.authService.getTicketOrKey(req);
            assert (authCtx != null);
            this.permissionsService.checkAnyProjectAccess(authCtx, projectKey);
            ProjectsService.UIProject uIProject = this.projectsService.getSummary(authCtx, projectKey, true);
            return uIProject;
        }
    }

    @AuditedCall(value={"msgType", "project-get-settings", "projectKey", "${projectKey}"})
    @RequestMapping(value={"/{projectKey}/settings"}, method={RequestMethod.GET})
    public void getSettings(HttpServletRequest req, HttpServletResponse resp, @PathVariable String projectKey) throws Exception {
        AuthCtx authCtx = this.authService.getTicketOrKey_NT(req);
        try (Transaction t = this.transactionService.beginRead();){
            this.permissionsService.checkProjectPrivileges(authCtx, projectKey, new Privileges.ProjectLevelPrivilegeType[]{Privileges.ProjectLevelPrivilegeType.ADMIN});
            SerializedProject project = this.projectsService.getMandatory(projectKey);
            APIProjectSettings ret = new APIProjectSettings();
            ret.projectStatus = project.projectStatus;
            ret.imgColor = project.imgColor;
            ret.imgPattern = project.imgPattern;
            ret.showInitials = project.showInitials;
            ret.settings = project.settings;
            ret.exposedObjects = project.exposedObjects;
            ret.metrics = project.metrics;
            ret.metricsChecks = project.metricsChecks;
            ret.bundleContainerSettings = project.bundleContainerSettings;
            ret.bundleExporterSettings = project.bundleExporterSettings;
            ret.projectAppType = project.projectAppType;
            PublicAPIProjectsController.writeJSON((HttpServletResponse)resp, (Object)ret);
        }
    }

    @AuditedCall(value={"msgType", "project-rename-dataset", "projectKey", "${projectKey}"})
    @RequestMapping(value={"/{projectKey}/actions/renameDataset"}, method={RequestMethod.POST})
    public void renameDataset(HttpServletRequest req, HttpServletResponse resp, @PathVariable String projectKey, @RequestBody RenameObjectAction renameAction) throws Exception {
        Dataset dataset;
        DatasetUtils.checkName((String)renameAction.newName);
        AuthCtx authCtx = this.authService.getTicketOrKey_NT(req);
        try (Transaction t = this.transactionService.beginRead();){
            this.permissionsService.checkProjectPrivileges(authCtx, projectKey, new Privileges.ProjectLevelPrivilegeType[]{Privileges.ProjectLevelPrivilegeType.WRITE_CONF});
            dataset = this.datasetAccessService.getMandatory(projectKey, renameAction.oldName);
            if (!renameAction.oldName.equalsIgnoreCase(renameAction.newName) && this.datasetsDAO.datasetExistsCaseInsensitive(projectKey, renameAction.newName)) {
                throw ErrorContext.iaef((String)"Dataset '%s' already exists", (Object)renameAction.newName, (Object[])new Object[0]);
            }
            if (this.streamingEndpointsDAO.exists(projectKey, renameAction.newName)) {
                throw ErrorContext.iaef((String)"Name %s is already used by a streaming endpoint", (Object)renameAction.newName, (Object[])new Object[0]);
            }
        }
        DatasetRenameService.RenamingImpact impact = this.datasetRenameService.computeRenamingImpact(dataset);
        this.datasetRenameService.performRenaming(authCtx, dataset, renameAction.newName, impact);
    }

    @AuditedCall(value={"msgType", "project-rename-recipe", "projectKey", "${projectKey}"})
    @RequestMapping(value={"/{projectKey}/actions/renameRecipe"}, method={RequestMethod.POST})
    public void renameRecipe(HttpServletRequest req, HttpServletResponse resp, @PathVariable String projectKey, @RequestBody RenameObjectAction renameAction) throws Exception {
        AuthCtx authCtx = this.authService.getTicketOrKey_NT(req);
        try (RWTransaction t = this.transactionService.beginWriteAsLoggedInUser(authCtx);){
            logger.info((Object)("Rename recipe: " + renameAction.oldName + " -> " + renameAction.newName));
            this.permissionsService.checkProjectPrivileges(authCtx, projectKey, new Privileges.ProjectLevelPrivilegeType[]{Privileges.ProjectLevelPrivilegeType.WRITE_CONF});
            this.recipeSaveService.rename(t, projectKey, renameAction.oldName, renameAction.newName);
            t.commit("Renamed recipe " + renameAction.oldName + " to " + renameAction.newName);
        }
    }

    @AuditedCall(value={"msgType", "project-rename-managedfodler", "projectKey", "${projectKey}"})
    @RequestMapping(value={"/{projectKey}/actions/renameManagedFolder"}, method={RequestMethod.POST})
    public void renameManagedFolder(HttpServletRequest req, HttpServletResponse resp, @PathVariable String projectKey, @RequestBody RenameWithIdObjectAction renameAction) throws Exception {
        AuthCtx authCtx = this.authService.getTicketOrKey_NT(req);
        try (RWTransaction t = this.transactionService.beginWriteAsLoggedInUser(authCtx);){
            logger.info((Object)("Rename managed folder " + renameAction.id + ": " + renameAction.newName));
            this.permissionsService.checkProjectPrivileges(authCtx, projectKey, new Privileges.ProjectLevelPrivilegeType[]{Privileges.ProjectLevelPrivilegeType.WRITE_CONF});
            this.managedFolderService.rename(projectKey, renameAction.id, renameAction.newName);
            t.commit("Renamed managed folder " + renameAction.id + ": " + renameAction.newName);
        }
    }

    @AuditedCall(value={"msgType", "project-save-settings", "projectKey", "${projectKey}"})
    @RequestMapping(value={"/{projectKey}/settings"}, method={RequestMethod.PUT})
    public void saveSettings(HttpServletRequest req, HttpServletResponse resp, @PathVariable String projectKey) throws Exception {
        APIProjectSettings aps = (APIProjectSettings)this.getRequestBodyAs(req, APIProjectSettings.class);
        AuthCtx authCtx = this.authService.getTicketOrKey_NT(req);
        try (RWTransaction t = this.transactionService.beginWriteAsLoggedInUser(authCtx);){
            this.permissionsService.checkProjectPrivileges(authCtx, projectKey, new Privileges.ProjectLevelPrivilegeType[]{Privileges.ProjectLevelPrivilegeType.ADMIN});
            SerializedProject project = this.projectsService.getMandatory(projectKey);
            TaggableObjectChangedEvent.ProjectEditSubtype editType = project.exposedObjects.equals((Object)aps.exposedObjects) ? TaggableObjectChangedEvent.ProjectEditSubtype.LOCAL_SETTINGS_ONLY : TaggableObjectChangedEvent.ProjectEditSubtype.LOCAL_SETTINGS_AND_EXPOSED_ONLY;
            project.projectStatus = aps.projectStatus;
            project.imgColor = aps.imgColor;
            project.imgPattern = aps.imgPattern;
            project.showInitials = aps.showInitials;
            project.settings = aps.settings;
            project.exposedObjects = aps.exposedObjects;
            project.metrics = aps.metrics;
            project.metricsChecks = aps.metricsChecks;
            project.bundleContainerSettings = aps.bundleContainerSettings;
            project.bundleExporterSettings = aps.bundleExporterSettings;
            if (aps.projectAppType != null) {
                if (project.projectAppType == SerializedProject.ProjectAppType.REGULAR && aps.projectAppType == SerializedProject.ProjectAppType.APP_TEMPLATE) {
                    this.appsService.appTemplatify_T(project);
                } else if (project.projectAppType != SerializedProject.ProjectAppType.REGULAR && aps.projectAppType == SerializedProject.ProjectAppType.REGULAR) {
                    this.appsService.unAppTemplatify_T(project);
                }
                project.projectAppType = aps.projectAppType;
            }
            this.projectsService.save(project, editType);
            t.commit("Updated project settings for " + projectKey);
        }
    }

    @AuditedCall(value={"msgType", "project-save-settings", "projectKey", "${projectKey}"})
    @RequestMapping(value={"/{projectKey}/expose"}, method={RequestMethod.PUT})
    public void addExpositionRules(HttpServletRequest req, HttpServletResponse resp, @PathVariable String projectKey) throws Exception {
        List objectsToExpose = (List)this.getRequestBodyAs(req, (TypeToken)new TypeToken<List<ExposedObject>>(){});
        AuthCtx authCtx = this.authService.getTicketOrKey_NT(req);
        try (RWTransaction t = this.transactionService.beginWriteAsLoggedInUser(authCtx);){
            this.permissionsService.checkProjectPrivileges(authCtx, projectKey, new Privileges.ProjectLevelPrivilegeType[]{Privileges.ProjectLevelPrivilegeType.WRITE_CONF});
            for (ExposedObject exposedObject : objectsToExpose) {
                for (ExposedObject.Rule rule : exposedObject.rules) {
                    this.permissionsService.checkProjectPrivileges(authCtx, rule.targetProject, new Privileges.ProjectLevelPrivilegeType[]{Privileges.ProjectLevelPrivilegeType.WRITE_CONF});
                }
            }
            this.exposedObjectsService.addExposedObject(projectKey, objectsToExpose);
            t.commit("Updated project object expositions for " + projectKey);
        }
    }

    @AuditedCall(value={"msgType", "project-save-settings", "projectKey", "${projectKey}"})
    @RequestMapping(value={"/{projectKey}/unexpose-to-projects"}, method={RequestMethod.PUT})
    public void removeExpositionRules(HttpServletRequest req, HttpServletResponse resp, @PathVariable String projectKey) throws Exception {
        List unexposedProjects = (List)this.getRequestBodyAs(req, (TypeToken)new TypeToken<List<String>>(){});
        AuthCtx authCtx = this.authService.getTicketOrKey_NT(req);
        try (RWTransaction t = this.transactionService.beginWriteAsLoggedInUser(authCtx);){
            this.permissionsService.checkProjectPrivileges(authCtx, projectKey, new Privileges.ProjectLevelPrivilegeType[]{Privileges.ProjectLevelPrivilegeType.WRITE_CONF});
            this.exposedObjectsService.unshare(projectKey, unexposedProjects);
            t.commit("Updated project object expositions for " + projectKey);
        }
    }

    @AuditedCall(value={"msgType", "project-get-meta", "projectKey", "${projectKey}"})
    @RequestMapping(value={"/{projectKey}/metadata"}, method={RequestMethod.GET})
    @ResponseBody
    public ObjectCompleteMetadata getMetadata(HttpServletRequest req, @PathVariable String projectKey) throws Exception {
        AuthCtx authCtx = this.authService.getTicketOrKey_NT(req);
        try (Transaction t = this.transactionService.beginRead();){
            this.permissionsService.checkProjectPrivileges(authCtx, projectKey, new Privileges.ProjectLevelPrivilegeType[]{Privileges.ProjectLevelPrivilegeType.READ_CONF});
            SerializedProject project = this.projectsService.getMandatoryUnsafe(projectKey);
            ProjectsService.ProjectCompleteMetadata projectCompleteMetadata = ProjectsService.getMetadata((SerializedProject)project);
            return projectCompleteMetadata;
        }
    }

    @AuditedCall(value={"msgType", "project-save-meta", "projectKey", "${projectKey}"})
    @RequestMapping(value={"/{projectKey}/metadata"}, method={RequestMethod.PUT})
    public void setMetadata(HttpServletRequest req, HttpServletResponse resp, @PathVariable String projectKey) throws Exception {
        ProjectsService.ProjectCompleteMetadata pcm = (ProjectsService.ProjectCompleteMetadata)this.getRequestBodyAs(req, ProjectsService.ProjectCompleteMetadata.class);
        this.require(StringUtils.isNotBlank((String)pcm.label), "Required field 'label' is missing");
        this.require(pcm.tags != null && pcm.tags.stream().noneMatch(StringUtils::isBlank), "Cannot set empty tags for a project");
        AuthCtx authCtx = this.authService.getTicketOrKey_NT(req);
        try (RWTransaction t = this.transactionService.beginWriteAsLoggedInUser(authCtx);){
            this.permissionsService.checkProjectPrivileges(authCtx, projectKey, new Privileges.ProjectLevelPrivilegeType[]{Privileges.ProjectLevelPrivilegeType.ADMIN});
            SerializedProject project = this.projectsService.getMandatory(projectKey);
            ProjectsService.setMetadata((SerializedProject)project, (ProjectsService.ProjectCompleteMetadata)pcm);
            this.projectsService.save(project, TaggableObjectChangedEvent.ProjectEditSubtype.SUMMARY_ONLY);
            t.commit("Updated project metadata in " + projectKey);
        }
    }

    @AuditedCall(value={"msgType", "project-get-permissions", "projectKey", "${projectKey}"})
    @RequestMapping(value={"/{projectKey}/permissions"}, method={RequestMethod.GET})
    public void getPermissions(HttpServletRequest req, HttpServletResponse resp, @PathVariable String projectKey) throws Exception {
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx authCtx = this.authService.getTicketOrKey(req);
            this.permissionsService.checkProjectPrivileges(authCtx, projectKey, new Privileges.ProjectLevelPrivilegeType[]{Privileges.ProjectLevelPrivilegeType.EDIT_PERMISSIONS});
            SerializedProject project = this.projectsService.getMandatory(projectKey);
            ProjectPermissions pp = new ProjectPermissions();
            pp.permissions = project.permissions;
            pp.owner = project.owner;
            if (this.permissionsService.hasProjectPrivilege(authCtx, project, Privileges.ProjectLevelPrivilegeType.ADMIN)) {
                pp.additionalDashboardUsers = project.additionalDashboardUsers;
                pp.dashboardAuthorizations = project.dashboardAuthorizations;
            } else if (this.permissionsService.hasProjectPrivilege(authCtx, project, Privileges.ProjectLevelPrivilegeType.MANAGE_DASHBOARD_AUTHORIZATIONS)) {
                pp.dashboardAuthorizations = project.dashboardAuthorizations;
            }
            PublicAPIProjectsController.writeJSON((HttpServletResponse)resp, (Object)pp);
        }
    }

    @AuditInline
    @RequestMapping(value={"/{projectKey}/permissions"}, method={RequestMethod.PUT})
    public void setPermissions(HttpServletRequest req, HttpServletResponse resp, @PathVariable String projectKey) throws Exception {
        ProjectPermissions projectPerms = (ProjectPermissions)this.getRequestBodyAs(req, ProjectPermissions.class);
        this.checkPermissionsAreValid(projectPerms.permissions);
        AuthCtx authCtx = this.authService.getTicketOrKey_NT(req);
        try (RWTransaction t = this.transactionService.beginWriteAsLoggedInUser(authCtx);){
            this.permissionsService.checkProjectPrivileges(authCtx, projectKey, new Privileges.ProjectLevelPrivilegeType[]{Privileges.ProjectLevelPrivilegeType.EDIT_PERMISSIONS});
            SerializedProject project = this.projectsService.getMandatory(projectKey);
            PermissionsWatcher pw = this.permissionsWatchersService.startProjectWatch(projectKey);
            if (this.permissionsService.hasProjectPrivilege(authCtx, project, Privileges.ProjectLevelPrivilegeType.ADMIN)) {
                project.owner = projectPerms.owner;
                project.additionalDashboardUsers = projectPerms.additionalDashboardUsers;
                project.dashboardAuthorizations = projectPerms.dashboardAuthorizations;
            } else {
                this.require(projectPerms.owner == null || Objects.equals(projectPerms.owner, project.owner), "You don't have the permission to modify the project owner");
                this.require(projectPerms.additionalDashboardUsers == null, "You don't have the permission to manage additional dashboard users, 'additionalDashboardUsers' field must be null");
                if (projectPerms.dashboardAuthorizations != null) {
                    this.require(this.permissionsService.hasProjectPrivilege(authCtx, project, Privileges.ProjectLevelPrivilegeType.MANAGE_DASHBOARD_AUTHORIZATIONS), "You don't have the permission to manage dashboard authorizations, 'dashboardAuthorizations' field must be null");
                    project.dashboardAuthorizations = projectPerms.dashboardAuthorizations;
                }
                this.projectsService.checkNonAdminCanSavePermissions(authCtx, project, projectPerms.permissions);
            }
            project.permissions = projectPerms.permissions;
            this.projectsService.save(project, TaggableObjectChangedEvent.ProjectEditSubtype.PERMISSIONS_ONLY);
            pw.stop();
            t.commit("Modified project permissions for " + projectKey);
            this.auditTrailService.generic("project-save-permissions").with("projectKey", projectKey).with("newPermissions", JSON.toJsonObject((Object)projectPerms)).emit();
        }
    }

    @AuditedCall(value={"msgType", "project-get-variables", "projectKey", "${projectKey}"})
    @RequestMapping(value={"/{projectKey}/variables"}, method={RequestMethod.GET})
    public void getProjectVariables(HttpServletRequest req, HttpServletResponse resp, @PathVariable String projectKey) throws Exception {
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx authCtx = this.authService.getTicketOrKey(req);
            this.permissionsService.checkProjectPrivileges(authCtx, projectKey, new Privileges.ProjectLevelPrivilegeType[]{Privileges.ProjectLevelPrivilegeType.READ_CONF});
            VariablesService.ProjectVariables pv = VariablesService.readLocalUnresolvedProjectVariables((String)projectKey, (Transaction)t);
            PublicAPIProjectsController.writeJSON((HttpServletResponse)resp, (Object)pv);
        }
    }

    @AuditedCall(value={"msgType", "project-get-variables", "projectKey", "${projectKey}"})
    @RequestMapping(value={"/{projectKey}/variables-resolved"}, method={RequestMethod.GET})
    public void getProjectVariablesResolved(HttpServletRequest req, HttpServletResponse resp, @PathVariable String projectKey, @RequestParam(required=false, defaultValue="true") boolean typed) throws Exception {
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx authCtx = this.authService.getTicketOrKey(req);
            this.permissionsService.checkProjectPrivileges(authCtx, projectKey, new Privileges.ProjectLevelPrivilegeType[]{Privileges.ProjectLevelPrivilegeType.READ_CONF});
            VariablesContext context = this.variablesService.getForProject(projectKey);
            PublicAPIProjectsController.writeJSON((HttpServletResponse)resp, (Object)(typed ? context.getAllVariablesTyped() : context.getAllVariables()));
        }
    }

    @AuditedCall(value={"msgType", "project-save-variables", "projectKey", "${projectKey}"})
    @RequestMapping(value={"/{projectKey}/variables"}, method={RequestMethod.PUT})
    public void setGlobalVariables(HttpServletRequest req, HttpServletResponse resp, @PathVariable String projectKey) throws Exception {
        VariablesService.ProjectVariables pv = (VariablesService.ProjectVariables)this.getRequestBodyAs(req, VariablesService.ProjectVariables.class);
        AuthCtx authCtx = this.authService.getTicketOrKey_NT(req);
        try (RWTransaction t = this.transactionService.beginWriteAsLoggedInUser(authCtx);){
            this.permissionsService.checkProjectPrivileges(authCtx, projectKey, new Privileges.ProjectLevelPrivilegeType[]{Privileges.ProjectLevelPrivilegeType.WRITE_CONF});
            VariablesService.writeLocalProjectVariables((String)projectKey, (RWTransaction)t, (VariablesService.ProjectVariables)pv, (boolean)true);
        }
    }

    @AuditedCall(value={"msgType", "project-manifest-get", "projectKey", "${projectKey}"})
    @RequestMapping(value={"/{projectKey}/app-manifest"}, method={RequestMethod.GET})
    @ResponseBody
    public AppManifest getAppManifest(HttpServletRequest req, HttpServletResponse resp, @PathVariable String projectKey) throws Exception {
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx authCtx = this.authService.getTicketOrKey(req);
            this.permissionsService.checkProjectPrivileges(authCtx, projectKey, new Privileges.ProjectLevelPrivilegeType[]{AppsService.minimumPermissionForEditingAppDesigner()});
            SerializedProject sp = this.projectsService.getMandatoryUnsafe(projectKey);
            if (sp.projectAppType == SerializedProject.ProjectAppType.APP_INSTANCE) {
                AppManifest appManifest = this.appsService.getAppInstanceManifestForProject_T(authCtx, projectKey);
                return appManifest;
            }
            if (sp.projectAppType == SerializedProject.ProjectAppType.APP_TEMPLATE) {
                AppManifest appManifest = this.appsService.getAppTemplateManifestForProject_T(projectKey);
                return appManifest;
            }
            throw new IllegalArgumentException("Project " + projectKey + " is neither an app template nor an app instance");
        }
    }

    @AuditedCall(value={"msgType", "project-manifest-save", "projectKey", "${projectKey}"})
    @RequestMapping(value={"/{projectKey}/app-manifest"}, method={RequestMethod.PUT})
    public void saveAppManifest(HttpServletRequest req, HttpServletResponse resp, @PathVariable String projectKey, @RequestBody AppManifest appManifest) throws Exception {
        AuthCtx authCtx = this.authService.getTicketOrKey_NT(req);
        try (RWTransaction t = this.transactionService.beginWriteAsLoggedInUser(authCtx);){
            boolean isSwitchingAppType;
            AppManifest currentManifest = this.appsService.getAppTemplateManifestForProject_T(projectKey);
            boolean bl = isSwitchingAppType = currentManifest.useAsRecipeSettings == null && appManifest.useAsRecipeSettings != null || currentManifest.useAsRecipeSettings != null && appManifest.useAsRecipeSettings == null;
            if (isSwitchingAppType) {
                this.permissionsService.checkProjectPrivileges(authCtx, projectKey, new Privileges.ProjectLevelPrivilegeType[]{AppsService.minimumPermissionForSwitchingAppDesignerType()});
            } else {
                this.permissionsService.checkProjectPrivileges(authCtx, projectKey, new Privileges.ProjectLevelPrivilegeType[]{AppsService.minimumPermissionForEditingAppDesigner()});
            }
            this.appsService.saveAppTemplateManifestForProject(projectKey, appManifest);
            t.commit("Saved app manifest for project " + projectKey);
        }
    }

    @AuditedCall(value={"msgType", "project-delete", "projectKey", "${projectKey}"})
    @RequestMapping(value={"/{projectKey:.+}"}, method={RequestMethod.DELETE})
    @ResponseBody
    public FutureResponse<InfoMessage.InfoMessages> deleteProject(HttpServletRequest req, HttpServletResponse resp, @PathVariable String projectKey, @RequestParam(defaultValue="false") boolean clearManagedDatasets, @RequestParam(defaultValue="false") boolean clearOutputManagedFolders, @RequestParam(defaultValue="true") boolean clearJobAndScenarioLogs, @RequestParam(defaultValue="true") boolean wait) throws Exception {
        if (ServletRequestUtils.getBooleanParameter((ServletRequest)req, (String)"dropData", (boolean)false)) {
            clearManagedDatasets = true;
        }
        if (ServletRequestUtils.getBooleanParameter((ServletRequest)req, (String)"dropManagedFoldersOutputOfRecipe", (boolean)false)) {
            clearOutputManagedFolders = true;
        }
        AuthCtx authCtx = this.authService.getTicketOrKey_NT(req);
        FutureResponse fr = this.projectsService.projectDeletionAttempt_NonAbortable(authCtx, projectKey, clearManagedDatasets, clearOutputManagedFolders, clearJobAndScenarioLogs);
        if (wait && !fr.hasResult) {
            return this.futureService.waitForFinalResponse(fr.jobId);
        }
        return fr;
    }

    @AuditedCall(value={"msgType", "project-export", "projectKey", "${projectKey}"})
    @RequestMapping(value={"/{projectKey}/export"}, method={RequestMethod.GET})
    public void exportProject(HttpServletRequest req, HttpServletResponse resp, @PathVariable String projectKey, @RequestParam(defaultValue="true") boolean exportUploads, @RequestParam(defaultValue="false") boolean exportManagedFS, @RequestParam(defaultValue="false") boolean exportAnalysisModels, @RequestParam(defaultValue="true") boolean exportSavedModels, @RequestParam(defaultValue="false") boolean exportProjectResources, @RequestParam(defaultValue="false") boolean exportAllInputDatasets, @RequestParam(defaultValue="false") boolean exportAllDatasets, @RequestParam(defaultValue="false") boolean exportAllInputManagedFolders, @RequestParam(defaultValue="false") boolean exportAllManagedFolders, @RequestParam(defaultValue="false") boolean exportAllRetrievableKnowledge, @RequestParam(defaultValue="false") boolean exportPromptStudioHistories, @RequestParam(defaultValue="false") boolean exportGitRepository) throws Exception {
        AuthCtx authCtx = null;
        try (Transaction t = this.transactionService.beginRead();){
            authCtx = this.authService.getTicketOrKey(req);
            this.permissionsService.checkCanExportAndManageBundles(authCtx, projectKey);
            if (exportGitRepository) {
                this.internalController.checkExportGitOption(authCtx, projectKey);
            }
        }
        String exportId = SecretKeyGenerator.generate((int)16);
        ProjectExportOptions options = new ProjectExportOptions();
        options.exportUploads = exportUploads;
        options.exportManagedFS = exportManagedFS;
        options.exportAllInputDatasets = exportAllInputDatasets;
        options.exportAllDatasets = exportAllDatasets;
        options.exportAllInputManagedFolders = exportAllInputManagedFolders;
        options.exportManagedFolders = exportAllManagedFolders;
        options.exportAnalysisModels = exportAnalysisModels;
        options.exportSavedModels = exportSavedModels;
        options.exportProjectResources = exportProjectResources;
        options.exportKnowledgeBanks = exportAllRetrievableKnowledge;
        options.exportPromptStudioHistories = exportPromptStudioHistories;
        options.exportGitRepository = exportGitRepository;
        File tmpFile = ProjectImportExportController.exportFile((String)projectKey, (String)exportId);
        DKUFileUtils.mkdirsParent((File)tmpFile);
        ProjectExporter peo = new ProjectExporter(authCtx, options, projectKey, tmpFile);
        peo.export(PublicAPIProjectsController.shouldApplyDataExportRestrictions(authCtx));
        ProjectImportExportController.sendExportDataAndDelete((HttpServletResponse)resp, (String)projectKey, (String)exportId);
    }

    @AuditedCall(value={"msgType", "project-export", "projectKey", "${projectKey}"})
    @RequestMapping(value={"/{projectKey}/export"}, method={RequestMethod.POST})
    public void exportProject2(HttpServletRequest req, HttpServletResponse resp, @PathVariable String projectKey) throws Exception {
        ProjectExportOptions options = (ProjectExportOptions)this.getRequestBodyAs(req, ProjectExportOptions.class);
        AuthCtx authCtx = null;
        try (Transaction t = this.transactionService.beginRead();){
            authCtx = this.authService.getTicketOrKey(req);
            this.permissionsService.checkCanExportAndManageBundles(authCtx, projectKey);
            if (options.exportGitRepository) {
                this.internalController.checkExportGitOption(authCtx, projectKey);
            }
        }
        String exportId = SecretKeyGenerator.generate((int)16);
        File tmpFile = ProjectImportExportController.exportFile((String)projectKey, (String)exportId);
        DKUFileUtils.mkdirsParent((File)tmpFile);
        FutureProgress.init();
        try (FutureProgress.AutocloseableFutureProgressState fut = FutureProgress.pushAutoCloseableState((String)"Building export", (double)18.0, (FutureProgressState.StateUnit)FutureProgressState.StateUnit.NONE);){
            ProjectExporter peo = new ProjectExporter(authCtx, options, projectKey, tmpFile);
            peo.export(PublicAPIProjectsController.shouldApplyDataExportRestrictions(authCtx));
        }
        ProjectImportExportController.sendExportDataAndDelete((HttpServletResponse)resp, (String)projectKey, (String)exportId);
    }

    @AuditedCall(value={"msgType", "project-duplicate", "projectKey", "${projectKey}"})
    @RequestMapping(value={"/{projectKey}/duplicate"}, method={RequestMethod.POST})
    public void duplicateProject(HttpServletRequest req, HttpServletResponse resp, @PathVariable String projectKey) throws Exception {
        String duplicationId = SecretKeyGenerator.generate((int)16);
        ProjectDuplicateOptions duplicateOptions = (ProjectDuplicateOptions)this.getRequestBodyAs(req, ProjectDuplicateOptions.class);
        DSSAuthCtx authCtx = (DSSAuthCtx)this.authService.getTicketOrKey_NT(req);
        try (RWTransaction t = this.transactionService.beginWriteAsLoggedInUser((AuthCtx)authCtx);){
            this.permissionsService.checkCanExportAndManageBundles((AuthCtx)authCtx, projectKey);
            if (authCtx.getAuthSource() == AuthCtx.AuthSource.CONFIGURABLE_API_KEY_PROJECT || !authCtx.getPermissions().mayCreateProjects()) {
                throw new SecurityException("You may not create new projects");
            }
            if (this.projectsService.getOrNullUnsafe(duplicateOptions.targetProjectKey) != null) {
                throw new DKUControllerBase.MalformedRequestException("Project " + duplicateOptions.targetProjectKey + " already exists");
            }
            String targetProjectFolderId = this.projectFoldersService.getProjectFolderIdOrRoot(duplicateOptions.targetProjectFolderId);
            this.permissionsService.checkProjectFolderPrivilege((AuthCtx)authCtx, targetProjectFolderId, new Privileges.ProjectFolderLevelPrivilegeType[]{Privileges.ProjectFolderLevelPrivilegeType.WRITE_CONTENTS});
            this.internalController.checkAndSetExportGitOption((AuthCtx)authCtx, projectKey, duplicateOptions);
        }
        this.internalController.duplicationOptionsChecks(duplicateOptions);
        FutureProgress.init();
        try (FutureProgress.AutocloseableFutureProgressState fps = FutureProgress.pushAutoCloseableState((String)"Duplicating");){
            ProjectImportExportController.ProjectDuplicateResult pdr = this.internalController.processDuplicate(projectKey, (AuthCtx)authCtx, duplicationId, duplicateOptions);
            this.auditTrailService.generic("project-duplicate").with("projectKey", projectKey).with("targetProjectKey", duplicateOptions.targetProjectKey).emit();
            PublicAPIProjectsController.writeJSON((HttpServletResponse)resp, (Object)pdr);
        }
    }

    @AuditInline
    @RequestMapping(value={"/import/upload"}, method={RequestMethod.POST})
    public void uploadForImport(HttpServletRequest req, HttpServletResponse resp, @RequestParam(value="file") MultipartFile filePart) throws Exception {
        try (Transaction t = this.transactionService.beginRead();){
            DSSAuthCtx authCtx = (DSSAuthCtx)this.authService.getTicketOrKey(req);
            if (!authCtx.getPermissions().mayCreateProjects()) {
                throw new SecurityException("You may not create new projects");
            }
        }
        String importId = SecretKeyGenerator.generate((int)16);
        logger.info((Object)("Uploading archive " + filePart.getOriginalFilename()));
        this.auditTrailService.generic("project-import-prepare").with("importId", importId).emit();
        ProjectImportExportController.unzipImportUploadStream((String)importId, (InputStream)filePart.getInputStream());
        PublicAPIProjectsController.writeJSON((HttpServletResponse)resp, (Object)new Id(importId));
    }

    @AuditInline
    @RequestMapping(value={"/import/{importId}/process"}, method={RequestMethod.POST})
    public void processImport(HttpServletRequest req, HttpServletResponse resp, @PathVariable String importId) throws Exception {
        ProjectImporter.ProjectImportSettings pis = (ProjectImporter.ProjectImportSettings)this.getRequestBodyAs(req, ProjectImporter.ProjectImportSettings.class);
        DSSAuthCtx authCtx = null;
        try (Transaction t = this.transactionService.beginRead();){
            authCtx = (DSSAuthCtx)this.authService.getTicketOrKey(req);
            if (!authCtx.getPermissions().mayCreateProjects()) {
                throw new SecurityException("You may not create new projects");
            }
        }
        FutureProgress.init();
        try (FutureProgress.AutocloseableFutureProgressState fps = FutureProgress.pushAutoCloseableState((String)"Importing");){
            ProjectImporter.ProjectImportResult result = this.internalController.processImport((AuthCtx)authCtx, importId, pis);
            this.auditTrailService.generic("project-import").with("importId", importId).with("projectKey", result.usedProjectKey).emit();
            PublicAPIProjectsController.writeJSON((HttpServletResponse)resp, (Object)result);
        }
    }

    @Deprecated
    @AuditedCall(value={"msgType", "project-push-remote", "projectKey", "${projectKey}"})
    @RequestMapping(value={"/{projectKey}/actions/push-to-git-remote"}, method={RequestMethod.POST})
    public void pushToGitRemote(HttpServletRequest req, HttpServletResponse resp, @PathVariable String projectKey, @RequestParam String remote) throws Exception {
        AuthCtx authCtx;
        try (Transaction t = this.transactionService.beginRead();){
            authCtx = this.authService.getTicketOrKey(req);
            this.permissionsService.checkProjectPrivileges(authCtx, projectKey, new Privileges.ProjectLevelPrivilegeType[]{Privileges.ProjectLevelPrivilegeType.ADMIN});
            Validate.notEmpty((String)remote);
        }
        this.projectsGitService.pushToRemote(authCtx, projectKey, remote);
    }

    @AuditedCall(value={"msgType", "project-sync-acls", "projectKey", "${projectKey}"})
    @RequestMapping(value={"/{projectKey}/actions/sync"}, method={RequestMethod.POST})
    public void syncAcls(HttpServletRequest req, HttpServletResponse resp, @PathVariable String projectKey) throws Exception {
        AuthCtx authCtx;
        try (Transaction t = this.transactionService.beginRead();){
            authCtx = this.authService.getTicketOrKey(req);
            this.permissionsService.checkProjectPrivileges(authCtx, projectKey, new Privileges.ProjectLevelPrivilegeType[]{Privileges.ProjectLevelPrivilegeType.ADMIN});
            SerializedProject project = this.projectsService.getOrNull(projectKey);
            if (project == null) {
                throw new DKUControllerBase.MalformedRequestException("Project " + projectKey + " does not exist");
            }
        }
        HDFSPermissionsSynchronizer sync = new HDFSPermissionsSynchronizer();
        PublicAPIProjectsController.writeJSON((HttpServletResponse)resp, (Object)sync.startSetPermissionsOnProjectDatasets_NT(authCtx, projectKey));
    }

    @AuditedCall(value={"msgType", "project-get-tags", "projectKey", "${projectKey}"})
    @RequestMapping(value={"/{projectKey}/tags"}, method={RequestMethod.GET})
    public void listTags(HttpServletRequest req, HttpServletResponse resp, @PathVariable String projectKey) throws Exception {
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx authCtx = this.authService.getTicketOrKey(req);
            this.permissionsService.checkProjectPrivileges(authCtx, projectKey, new Privileges.ProjectLevelPrivilegeType[]{Privileges.ProjectLevelPrivilegeType.READ_CONF});
            PublicAPIProjectsController.writeJSON((HttpServletResponse)resp, (Object)this.taggingService.listTags(projectKey));
        }
    }

    @AuditedCall(value={"msgType", "project-set-tags", "projectKey", "${projectKey}"})
    @RequestMapping(value={"/{projectKey}/tags"}, method={RequestMethod.PUT})
    public void setTags(HttpServletRequest req, HttpServletResponse resp, @PathVariable String projectKey) throws Exception {
        TaggingService.TagsFile tagFile = (TaggingService.TagsFile)this.getRequestBodyAs(req, TaggingService.TagsFile.class);
        this.require(tagFile.tags != null, "Required field 'tags' is missing.");
        this.require(tagFile.tags.keySet().stream().noneMatch(StringUtils::isBlank), "Cannot set empty tags to the project tag list");
        AuthCtx authCtx = this.authService.getTicketOrKey_NT(req);
        try (RWTransaction t = this.transactionService.beginWriteAsLoggedInUser(authCtx);){
            this.permissionsService.checkProjectPrivileges(authCtx, projectKey, new Privileges.ProjectLevelPrivilegeType[]{Privileges.ProjectLevelPrivilegeType.WRITE_CONF});
            this.taggingService.setTags(projectKey, tagFile, null);
            t.commit("Edited tags list for project " + projectKey);
        }
    }

    @AuditedCall(value={"msgType", "project-get-timeline-description", "projectKey", "${projectKey}"})
    @RequestMapping(value={"/{projectKey}/timeline"}, method={RequestMethod.GET})
    @ResponseBody
    public TimelinesService.TimelineWithVersioning getTimeline(HttpServletRequest req, HttpServletResponse resp, @PathVariable String projectKey, @RequestParam(defaultValue="100") int itemCount) throws Exception {
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx authCtx = this.authService.getTicketOrKey(req);
            this.permissionsService.checkProjectPrivileges(authCtx, projectKey, new Privileges.ProjectLevelPrivilegeType[]{Privileges.ProjectLevelPrivilegeType.READ_CONF});
        }
        return this.timelinesService.getProjectTimeline_NT(projectKey, 0, itemCount);
    }

    @AuditedCall(value={"msgType", "project-get-interest", "projectKey", "${projectKey}"})
    @RequestMapping(value={"/{projectKey}/interest"}, method={RequestMethod.GET})
    public void getInterest(HttpServletRequest req, HttpServletResponse resp, @PathVariable String projectKey) throws Exception {
        AuthCtx authCtx = null;
        InterestsInternalDB.Interest summary = null;
        try (Transaction t = this.transactionService.beginRead();){
            authCtx = this.authService.getTicketOrKey(req);
            assert (authCtx != null);
            this.permissionsService.checkAnyProjectAccess(authCtx, projectKey);
        }
        summary = this.interestsService.getObjectAndUserInterest_noFail(authCtx, ITaggingService.TaggableType.PROJECT, projectKey, projectKey);
        int starCount = summary.nbStarred;
        int watchCount = summary.nbWatching;
        JsonObject interest = new JsonObject();
        interest.addProperty("starCount", (Number)starCount);
        interest.addProperty("watchCount", (Number)watchCount);
        PublicAPIProjectsController.writeJSON((HttpServletResponse)resp, (Object)interest);
    }

    @AuditedCall(value={"msgType", "project-data-quality-current-status", "projectKey", "${projectKey}"})
    @RequestMapping(value={"/{projectKey}/data-quality/status"}, method={RequestMethod.GET})
    @ResponseBody
    public Map<String, AbstractCheckContext.CheckOutcome> getProjectDataQualityDatasetSummary(HttpServletRequest req, @PathVariable String projectKey, @RequestParam(defaultValue="false") boolean onlyMonitored) throws Exception {
        ArrayList datasetsWithValidRuleset;
        HashMap<String, AbstractCheckContext.CheckOutcome> result = new HashMap<String, AbstractCheckContext.CheckOutcome>();
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx authCtx = this.authService.getTicketOrKey(req);
            this.permissionsService.checkProjectPrivileges(authCtx, projectKey, new Privileges.ProjectLevelPrivilegeType[]{Privileges.ProjectLevelPrivilegeType.READ_CONF});
            List sds = this.datasetsDAO.listUnsafe(projectKey);
            datasetsWithValidRuleset = new ArrayList(this.dataQualitySummaryService.filterDatasetsWithValidRuleset(sds).values());
        }
        Map mapDBObjectIdToLastObjectPoint = this.readOnlyJobsInternalDB.getLastDataQualityObjectStatusesForProject(projectKey);
        for (SerializedDataset sd : datasetsWithValidRuleset) {
            if (onlyMonitored && !sd.getDataQualityRuleSet().monitor || !mapDBObjectIdToLastObjectPoint.containsKey(sd.getId())) continue;
            result.put(sd.getId(), ((ReadOnlyJobsInternalDB.DataQualityLastObjectPoint)mapDBObjectIdToLastObjectPoint.get((Object)sd.getId())).last.getOutcome());
        }
        return result;
    }

    @AuditedCall(value={"msgType", "projet-data-quality-timeline", "projectKey", "${projectKey}"})
    @RequestMapping(value={"/{projectKey}/data-quality/timeline"}, method={RequestMethod.GET})
    @ResponseBody
    public List<DataQualitySummaryService.DataQualityDailyProjectStatusAPI> getProjectDataQualityTimeline(HttpServletRequest req, @PathVariable String projectKey, @RequestParam(required=false, defaultValue="-1") long minTimestamp, @RequestParam(required=false, defaultValue="-1") long maxTimestamp) throws Exception {
        List sds;
        long endDay = maxTimestamp != -1L ? maxTimestamp : System.currentTimeMillis();
        long startDay = minTimestamp != -1L ? minTimestamp : new DateTime(endDay).minusDays(14).getMillis();
        Preconditions.checkArgument((startDay <= endDay ? 1 : 0) != 0, (Object)"minTimestamp should be less than maxTimestamp");
        Preconditions.checkArgument((startDay >= 0L ? 1 : 0) != 0, (Object)"minTimestamp cannot be negative");
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx authCtx = this.authService.getTicketOrKey(req);
            this.permissionsService.checkProjectPrivileges(authCtx, projectKey, new Privileges.ProjectLevelPrivilegeType[]{Privileges.ProjectLevelPrivilegeType.READ_CONF});
            sds = this.datasetsDAO.listUnsafe(projectKey);
        }
        return this.dataQualitySummaryService.getPublicAPIProjectHistoryBetweenDays(projectKey, startDay, endDay, sds);
    }

    @AuditedCall(value={"msgType", "list-heavy-status"})
    @RequestMapping(value={"/heavy-status/list"}, method={RequestMethod.POST})
    public void listHeavyStatus(HttpServletRequest req, HttpServletResponse resp, @RequestBody HeavyStatusRequest heavyStatusRequest) throws Exception {
        AuthCtx authCtx;
        AbstractProjectDeploymentHeavyStatus.InfoMap infoMap = new AbstractProjectDeploymentHeavyStatus.InfoMap();
        try (Transaction t = this.transactionService.beginRead();){
            authCtx = this.authService.getTicketOrKey(req);
        }
        int poolSize = DKUApp.getParams().getIntParam("dku.webapp.backendReadiness.threadPoolSize", Integer.valueOf(5));
        int totalTimeout = DKUApp.getParams().getIntParam("dku.webapp.backendReadiness.totalTimeoutMS", Integer.valueOf(30000));
        try (DKUExecutors.DKUExecutor webappBackendStatusExecutor = new DKUExecutors.DKUExecutor(poolSize, "listHeavyStatus-%d", totalTimeout);){
            for (String projectKey : heavyStatusRequest.projectKeys) {
                AbstractProjectDeploymentHeavyStatus.Info info = new AbstractProjectDeploymentHeavyStatus.Info();
                infoMap.putHeavyStatusInfo(projectKey, info);
                try {
                    List scenarios;
                    Transaction t;
                    ProjectsService.UIProject project;
                    Transaction t2 = this.transactionService.beginRead();
                    try {
                        project = this.projectsService.getSummaryOrNull(authCtx, projectKey, false);
                        if (project == null || !this.permissionsService.hasAnyProjectAccess(authCtx, projectKey)) {
                            continue;
                        }
                    }
                    finally {
                        if (t2 == null) continue;
                        t2.close();
                        continue;
                    }
                    info.projectExists = true;
                    info.activeBundleId = project.activeBundleState == null ? null : project.activeBundleState.bundleId;
                    info.disabledAutomaticTriggers = project.disableAutomaticTriggers;
                    info.name = project.getDisplayName();
                    if (project.isProjectAdmin) {
                        SerializedProject sp;
                        info.isProjectAdmin = true;
                        t = this.transactionService.beginRead();
                        try {
                            sp = this.projectsService.getMandatory(projectKey);
                        }
                        finally {
                            if (t != null) {
                                t.close();
                            }
                        }
                        if (sp.bundleContainerSettings != null) {
                            info.codeEnvsBehavior = sp.bundleContainerSettings.codeEnvsBehavior;
                            info.connectionRemappings = sp.bundleContainerSettings.remapping.connections;
                            info.containerExecRemappings = sp.bundleContainerSettings.remapping.containerExecs;
                        }
                    }
                    t = this.transactionService.beginRead();
                    try {
                        info.localVariables = VariablesService.readLocalUnresolvedProjectVariables((String)projectKey, (Transaction)t).local;
                        scenarios = this.scenariosService.listUnsafe(projectKey);
                    }
                    finally {
                        if (t != null) {
                            t.close();
                        }
                    }
                    info.monitoring = new AbstractProjectDeploymentHeavyStatus.ProjectDeployerScenarioMonitoring();
                    for (Scenario scenario : scenarios) {
                        info.monitoring.hasScenarios = true;
                        if (scenario.active) {
                            info.monitoring.hasActiveScenarios = true;
                            List scenarioRuns = this.scenariosService.getLastRuns(scenario, 2, false, true);
                            scenarioRuns.stream().filter(scenarioRun -> scenarioRun.getEnd() != 0L).findFirst().ifPresent(scenarioRun -> info.monitoring.addScenarioOutcome(scenarioRun));
                        }
                        info.scenarioActiveState.put(scenario.id, scenario.active);
                    }
                    info.webappBackendInfoList = this.webAppsService.getBackendInfoListForProject_NT(webappBackendStatusExecutor, projectKey, heavyStatusRequest.autoStartedWebappsOnly, heavyStatusRequest.includeWebappsWithNoBackend);
                }
                catch (Exception e) {
                    info.errorMessage = ExceptionUtils.getMessageWithCauses((Throwable)e);
                }
            }
        }
        PublicAPIProjectsController.writeJSON((HttpServletResponse)resp, (Object)infoMap);
    }

    @AuditedCall(value={"msgType", "generate-ai-description", "projectKey", "${projectKey}"})
    @RequestMapping(value={"/{projectKey}/generate-ai-description"}, method={RequestMethod.POST})
    public void generateAiDescription(HttpServletRequest req, HttpServletResponse resp, @PathVariable String projectKey, @RequestParam(defaultValue="english") String language, @RequestParam(defaultValue="generic") String purpose, @RequestParam(defaultValue="medium") String length, @RequestParam(defaultValue="false") boolean saveDescription) throws Exception {
        AuthCtx authCtx;
        try (Transaction t = this.transactionService.beginRead();){
            authCtx = this.authService.getTicketOrKey(req);
            this.projectsService.checkPerm(authCtx, projectKey, new Privileges.ProjectLevelPrivilegeType[]{saveDescription ? Privileges.ProjectLevelPrivilegeType.WRITE_CONF : Privileges.ProjectLevelPrivilegeType.READ_CONF});
        }
        JsonObject explanationOptions = new JsonObject();
        explanationOptions.addProperty("language", language.toLowerCase());
        explanationOptions.addProperty("purpose", purpose.toUpperCase());
        explanationOptions.addProperty("verbosity", length.toUpperCase());
        FutureResponse fr = this.aiFlowExplanationService.startExplainingProject(authCtx, projectKey, explanationOptions.toString(), false);
        fr = this.futureService.waitForFinalResponse(fr);
        if (!((ExplainStuffFrontendResponse)fr.result).ok) {
            throw new ApplicativeException("Exception while getting AI explanation", ((ExplainStuffFrontendResponse)fr.result).reason);
        }
        String aiExplanation = ((ExplainStuffFrontendResponse)fr.result).explanation;
        if (saveDescription) {
            try (RWTransaction t = this.transactionService.beginWriteAsLoggedInUser(authCtx);){
                SerializedProject sp = this.projectsService.getMandatory(projectKey);
                sp.description = aiExplanation;
                this.projectsService.save(sp, TaggableObjectChangedEvent.ProjectEditSubtype.SUMMARY_ONLY);
                t.commit("Updated description of project " + projectKey);
            }
        }
        PublicAPIProjectsController.writeJSON((HttpServletResponse)resp, (Object)aiExplanation);
    }

    private void checkPermissionsAreValid(Iterable<SerializedProject.PermissionItem> permissions) {
        if (permissions == null) {
            throw new DKUControllerBase.MalformedRequestException("Required field 'permissions' is empty.");
        }
        for (SerializedProject.PermissionItem permissionItem : permissions) {
            if (permissionItem == null) continue;
            String msg = "Need exactly one of these fields: 'group', 'user', 'pendingUserEmail'.";
            this.require(permissionItem.group != null ^ permissionItem.user != null ^ permissionItem.pendingUserEmail != null && (permissionItem.group == null || permissionItem.user == null), msg);
            if (permissionItem.group != null) {
                this.require(!permissionItem.group.isEmpty(), "Required field 'group' is empty.");
                continue;
            }
            if (permissionItem.user != null) {
                this.require(!permissionItem.user.isEmpty(), "Required field 'user' is empty.");
                continue;
            }
            this.require(permissionItem.pendingUserEmail.indexOf(64) > 0, "Permission field 'pendingUserEmail' must be a valid email");
        }
    }

    private static boolean shouldApplyDataExportRestrictions(AuthCtx authCtx) {
        DSSAuthCtx dssAuthCtx;
        if (authCtx instanceof DSSAuthCtx && (dssAuthCtx = (DSSAuthCtx)authCtx).isConfigurableAPIKey()) {
            return !"cli-dsscli".equals(dssAuthCtx.getAsConfigurableAPIKey().createdBy);
        }
        return true;
    }

    public static class APIProjectSettings {
        public String projectStatus;
        public String imgColor;
        public Integer imgPattern;
        public Boolean showInitials;
        public SerializedProject.ProjectSettings settings;
        public SerializedProject.ProjectExposedObjects exposedObjects;
        public ProbesSet metrics;
        public ChecksSet metricsChecks;
        public BundleContainerSettings bundleContainerSettings;
        public BundleExporterSettings bundleExporterSettings;
        public SerializedProject.ProjectAppType projectAppType;
    }

    public static class RenameObjectAction {
        public String oldName;
        public String newName;
    }

    public static class RenameWithIdObjectAction {
        public String id;
        public String newName;
    }

    public static class HeavyStatusRequest {
        List<String> projectKeys;
        boolean autoStartedWebappsOnly = true;
        boolean includeWebappsWithNoBackend = false;
    }
}

