/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.server.services.catalog.opensearch;

import com.dataiku.dip.server.services.catalog.opensearch.CombineFunction;
import com.dataiku.dip.server.services.catalog.opensearch.LeafScoreFunction;
import com.dataiku.dip.server.services.catalog.opensearch.OpensearchUtils;
import com.dataiku.dip.server.services.catalog.opensearch.ScoreFunction;
import com.dataiku.dss.shadelib.org.apache.lucene.index.DocValues;
import com.dataiku.dss.shadelib.org.apache.lucene.index.LeafReader;
import com.dataiku.dss.shadelib.org.apache.lucene.index.LeafReaderContext;
import com.dataiku.dss.shadelib.org.apache.lucene.index.SortedNumericDocValues;
import com.dataiku.dss.shadelib.org.apache.lucene.search.Explanation;
import java.io.IOException;
import java.util.Locale;
import java.util.Objects;
import javax.annotation.Nullable;

public class FieldValueFactorFunction
extends ScoreFunction {
    private final String field;
    private final float boostFactor;
    private final Modifier modifier;
    private final String functionName;
    private final Double missing;

    public FieldValueFactorFunction(String field, float boostFactor, Modifier modifierType, Double missing) {
        this(field, boostFactor, modifierType, missing, null);
    }

    public FieldValueFactorFunction(String field, float boostFactor, Modifier modifierType, Double missing, @Nullable String functionName) {
        super(CombineFunction.MULTIPLY);
        this.field = field;
        this.boostFactor = boostFactor;
        this.modifier = modifierType;
        this.missing = missing;
        this.functionName = functionName;
    }

    @Override
    public LeafScoreFunction getLeafScoreFunction(LeafReaderContext ctx) throws IOException {
        final SortedNumericDocValues values = ctx.reader().getFieldInfos().fieldInfo(this.field) == null ? DocValues.emptySortedNumeric() : DocValues.getSortedNumeric((LeafReader)ctx.reader(), (String)this.field);
        return new LeafScoreFunction(){

            @Override
            public double score(int docId, float subQueryScore) throws IOException {
                double value;
                if (values.advanceExact(docId)) {
                    value = values.nextValue();
                } else if (FieldValueFactorFunction.this.missing != null) {
                    value = FieldValueFactorFunction.this.missing;
                } else {
                    throw new IllegalStateException("Missing value for field [" + FieldValueFactorFunction.this.field + "]");
                }
                double val = value * (double)FieldValueFactorFunction.this.boostFactor;
                double result = FieldValueFactorFunction.this.modifier.apply(val);
                if (result < 0.0) {
                    String message = "field value function must not produce negative scores, but got: [" + result + "] for field value: [" + value + "]";
                    if (FieldValueFactorFunction.this.modifier == Modifier.LN) {
                        message = message + "; consider using ln1p or ln2p instead of ln to avoid negative scores";
                    } else if (FieldValueFactorFunction.this.modifier == Modifier.LOG) {
                        message = message + "; consider using log1p or log2p instead of log to avoid negative scores";
                    }
                    throw new IllegalArgumentException(message);
                }
                return result;
            }

            @Override
            public Explanation explainScore(int docId, Explanation subQueryScore) throws IOException {
                String modifierStr = FieldValueFactorFunction.this.modifier != null ? FieldValueFactorFunction.this.modifier.toString() : "";
                String defaultStr = FieldValueFactorFunction.this.missing != null ? "?:" + FieldValueFactorFunction.this.missing : "";
                double score = this.score(docId, subQueryScore.getValue().floatValue());
                return Explanation.match((Number)Float.valueOf((float)score), (String)String.format(Locale.ROOT, "field value function" + OpensearchUtils.nameOrEmptyFunc(FieldValueFactorFunction.this.functionName) + ": %s(doc['%s'].value%s * factor=%s)", modifierStr, FieldValueFactorFunction.this.field, defaultStr, Float.valueOf(FieldValueFactorFunction.this.boostFactor)), (Explanation[])new Explanation[0]);
            }
        };
    }

    @Override
    public boolean needsScores() {
        return false;
    }

    @Override
    protected boolean doEquals(ScoreFunction other) {
        FieldValueFactorFunction fieldValueFactorFunction = (FieldValueFactorFunction)other;
        return this.boostFactor == fieldValueFactorFunction.boostFactor && Objects.equals(this.field, fieldValueFactorFunction.field) && Objects.equals((Object)this.modifier, (Object)fieldValueFactorFunction.modifier);
    }

    @Override
    protected int doHashCode() {
        return Objects.hash(new Object[]{Float.valueOf(this.boostFactor), this.field, this.modifier});
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static enum Modifier {
        NONE{

            @Override
            public double apply(double n) {
                return n;
            }
        }
        ,
        LOG{

            @Override
            public double apply(double n) {
                return Math.log10(n);
            }
        }
        ,
        LOG1P{

            @Override
            public double apply(double n) {
                return Math.log10(n + 1.0);
            }
        }
        ,
        LOG2P{

            @Override
            public double apply(double n) {
                return Math.log10(n + 2.0);
            }
        }
        ,
        LN{

            @Override
            public double apply(double n) {
                return Math.log(n);
            }
        }
        ,
        LN1P{

            @Override
            public double apply(double n) {
                return Math.log1p(n);
            }
        }
        ,
        LN2P{

            @Override
            public double apply(double n) {
                return Math.log1p(n + 1.0);
            }
        }
        ,
        SQUARE{

            @Override
            public double apply(double n) {
                return Math.pow(n, 2.0);
            }
        }
        ,
        SQRT{

            @Override
            public double apply(double n) {
                return Math.sqrt(n);
            }
        }
        ,
        RECIPROCAL{

            @Override
            public double apply(double n) {
                return 1.0 / n;
            }
        };


        public abstract double apply(double var1);

        public String toString() {
            return super.toString().toLowerCase(Locale.ROOT);
        }

        public static Modifier fromString(String modifier) {
            return Modifier.valueOf(modifier.toUpperCase(Locale.ROOT));
        }
    }
}

