/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.shaker.processors.cleansing;

import com.dataiku.dip.data.geo.CountriesGeoDataLoader;
import com.dataiku.dip.shaker.processors.SnowflakeUDF;
import com.dataiku.dip.shaker.types.MeaningDetector;
import java.io.File;

public class IsInvalidMeaningUDF
extends SnowflakeUDF {
    private boolean initialized;
    private MeaningDetector meaningDetector;

    private void initialize(String meaning) throws Exception {
        String importDirectory = System.getProperty("com.snowflake.import_directory");
        if ("CountryMeaning".equals(meaning)) {
            CountriesGeoDataLoader.load(new File(importDirectory, "countries.csv.gz"));
        }
        String dataTypeName = "com.dataiku.dip.shaker.types." + meaning;
        this.meaningDetector = (MeaningDetector)Class.forName(dataTypeName).newInstance();
        this.initialized = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean check(String v, String meaning) throws Exception {
        IsInvalidMeaningUDF isInvalidMeaningUDF = this;
        synchronized (isInvalidMeaningUDF) {
            if (!this.initialized) {
                this.initialize(meaning);
            }
        }
        return v != null && !this.meaningDetector.validates(v);
    }
}

