/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.shaker.processors.time.ical;

import com.dataiku.dip.shaker.processors.time.ical.HolidayOccurrence;
import com.dataiku.dip.shaker.processors.time.ical.HolidaysDatabase;
import com.dataiku.dip.shaker.processors.time.ical.HolidaysFinder;
import com.dataiku.dip.shaker.processors.time.ical.HolidaysFinderCombiner;
import com.dataiku.dip.shaker.processors.time.ical.WeekendDatabase;
import com.google.common.base.Preconditions;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.json.JSONArray;

public class HolidaysExtractionHelper {
    private static HolidaysFinder cachedDB;
    public static HolidaysDatabase holidaysDatabase;
    public static WeekendDatabase weekendDatabase;
    private static Logger logger;

    static synchronized void loadSharedDatabase(File weekendsDBFile, File holidaysDBFile) {
        if (HolidaysExtractionHelper.getCachedDB() == null) {
            Preconditions.checkNotNull((Object)weekendsDBFile);
            Preconditions.checkNotNull((Object)holidaysDBFile);
            ArrayList<HolidaysFinder> finders = new ArrayList<HolidaysFinder>();
            try {
                logger.info((Object)("Loading holidays db from " + holidaysDBFile.getAbsolutePath()));
                holidaysDatabase = HolidaysDatabase.loadFromFile(holidaysDBFile);
                finders.add(holidaysDatabase);
            }
            catch (Exception e) {
                logger.error((Object)"Unable to load holidays database", (Throwable)e);
            }
            try {
                logger.info((Object)("Loading weekends db from " + weekendsDBFile.getAbsolutePath()));
                weekendDatabase = WeekendDatabase.loadFromFile(weekendsDBFile);
                finders.add(weekendDatabase);
            }
            catch (Exception e) {
                logger.error((Object)"Unable to load weekends database", (Throwable)e);
            }
            cachedDB = new HolidaysFinderCombiner(finders.toArray(new HolidaysFinder[0]));
        }
    }

    public static SearchResult handleOccurences(List<HolidayOccurrence> occurrences, boolean flagSchoolHolidays, boolean flagBankHolidays, boolean flagWeekends, boolean extractReasons, boolean extractZones) {
        SearchResult ret = new SearchResult();
        if (extractReasons) {
            ret.schoolHolidayReasons = new HashSet<String>();
            ret.bankHolidayReasons = new HashSet<String>();
        }
        if (extractZones) {
            ret.zones = new HashSet<String>();
        }
        for (HolidayOccurrence occurrence : occurrences) {
            boolean flag = false;
            switch (occurrence.type) {
                case SCHOOL: {
                    ret.isSchoolHoliday = true;
                    flag = flagSchoolHolidays;
                    if (ret.schoolHolidayReasons == null) break;
                    ret.schoolHolidayReasons.add(occurrence.eventName);
                    break;
                }
                case BANK: {
                    ret.isBankHoliday = true;
                    flag = flagBankHolidays;
                    if (ret.bankHolidayReasons == null) break;
                    ret.bankHolidayReasons.add(occurrence.eventName);
                    break;
                }
                case WEEKEND: {
                    ret.isWeekend = true;
                    flag = flagWeekends;
                }
            }
            if (!flag || ret.zones == null || !StringUtils.isNotBlank((String)occurrence.zone)) continue;
            ret.zones.add(occurrence.zone);
        }
        return ret;
    }

    public static HolidaysFinder getCachedDB() {
        return cachedDB;
    }

    public static String jsonify(Collection<String> strs) {
        if (strs.size() == 0) {
            return "[]";
        }
        JSONArray out = new JSONArray();
        for (String str : strs) {
            out.put((Object)str);
        }
        return out.toString();
    }

    static {
        logger = Logger.getLogger((String)"dku.dates");
    }

    public static class SearchResult {
        boolean isWeekend = false;
        boolean isBankHoliday = false;
        boolean isSchoolHoliday = false;
        Set<String> schoolHolidayReasons = null;
        Set<String> bankHolidayReasons = null;
        Set<String> zones = null;
    }
}

