/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.shaker.processors.typespecific;

import java.net.MalformedURLException;
import java.net.URL;

public class URLSplitterAlgorithm {
    public static URLSplitterResult process(String v) {
        if (v == null || v.isEmpty()) {
            return null;
        }
        try {
            URL u;
            boolean fakeProtocol = false;
            try {
                u = new URL(v);
            }
            catch (MalformedURLException e) {
                u = new URL("http://" + v);
                fakeProtocol = true;
            }
            return new URLSplitterResult(u, fakeProtocol);
        }
        catch (MalformedURLException e) {
            return null;
        }
    }

    public static class URLSplitterResult {
        public final String anchor;
        public final String queryString;
        public final String path;
        public final int port;
        public final String host;
        public final String protocol;

        public URLSplitterResult(URL url, boolean fakeProtocol) {
            this.anchor = url.getRef();
            this.queryString = url.getQuery();
            this.path = url.getPath();
            this.port = url.getPort();
            this.host = url.getHost();
            this.protocol = fakeProtocol ? null : url.getProtocol();
        }
    }
}

