/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibpoi.org.apache.poi.hssf.record;

import com.dataiku.dss.shadelibpoi.org.apache.commons.io.output.UnsynchronizedByteArrayOutputStream;
import com.dataiku.dss.shadelibpoi.org.apache.poi.common.Duplicatable;
import com.dataiku.dss.shadelibpoi.org.apache.poi.common.usermodel.GenericRecord;
import com.dataiku.dss.shadelibpoi.org.apache.poi.hssf.record.CommonObjectDataSubRecord;
import com.dataiku.dss.shadelibpoi.org.apache.poi.hssf.record.EmbeddedObjectRefSubRecord;
import com.dataiku.dss.shadelibpoi.org.apache.poi.hssf.record.EndSubRecord;
import com.dataiku.dss.shadelibpoi.org.apache.poi.hssf.record.FtCblsSubRecord;
import com.dataiku.dss.shadelibpoi.org.apache.poi.hssf.record.FtCfSubRecord;
import com.dataiku.dss.shadelibpoi.org.apache.poi.hssf.record.FtPioGrbitSubRecord;
import com.dataiku.dss.shadelibpoi.org.apache.poi.hssf.record.GroupMarkerSubRecord;
import com.dataiku.dss.shadelibpoi.org.apache.poi.hssf.record.LbsDataSubRecord;
import com.dataiku.dss.shadelibpoi.org.apache.poi.hssf.record.NoteStructureSubRecord;
import com.dataiku.dss.shadelibpoi.org.apache.poi.util.GenericRecordJsonWriter;
import com.dataiku.dss.shadelibpoi.org.apache.poi.util.GenericRecordUtil;
import com.dataiku.dss.shadelibpoi.org.apache.poi.util.IOUtils;
import com.dataiku.dss.shadelibpoi.org.apache.poi.util.LittleEndianInput;
import com.dataiku.dss.shadelibpoi.org.apache.poi.util.LittleEndianOutput;
import com.dataiku.dss.shadelibpoi.org.apache.poi.util.LittleEndianOutputStream;
import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;

public abstract class SubRecord
implements Duplicatable,
GenericRecord {
    private static final int DEFAULT_MAX_RECORD_LENGTH = 1000000;
    private static int MAX_RECORD_LENGTH = 1000000;

    public static void setMaxRecordLength(int length) {
        MAX_RECORD_LENGTH = length;
    }

    public static int getMaxRecordLength() {
        return MAX_RECORD_LENGTH;
    }

    protected SubRecord() {
    }

    protected SubRecord(SubRecord other) {
    }

    public static SubRecord createSubRecord(LittleEndianInput in, int cmoOt) {
        int sid = in.readUShort();
        int size = in.readUShort();
        SubRecordTypes srt = SubRecordTypes.forSID(sid);
        return srt.recordConstructor.apply(in, size, srt == SubRecordTypes.UNKNOWN ? sid : cmoOt);
    }

    public final String toString() {
        return GenericRecordJsonWriter.marshal(this);
    }

    protected abstract int getDataSize();

    public byte[] serialize() {
        int size = this.getDataSize() + 4;
        UnsynchronizedByteArrayOutputStream baos = ((UnsynchronizedByteArrayOutputStream.Builder)UnsynchronizedByteArrayOutputStream.builder().setBufferSize(size)).get();
        this.serialize(new LittleEndianOutputStream(baos));
        if (baos.size() != size) {
            throw new IllegalStateException("write size mismatch");
        }
        return baos.toByteArray();
    }

    public abstract void serialize(LittleEndianOutput var1);

    public boolean isTerminating() {
        return false;
    }

    @Override
    public abstract SubRecord copy();

    public abstract SubRecordTypes getGenericRecordType();

    private static final class UnknownSubRecord
    extends SubRecord {
        private final int _sid;
        private final byte[] _data;

        public UnknownSubRecord(LittleEndianInput in, int size, int sid) {
            this._sid = sid;
            byte[] buf = IOUtils.safelyAllocate(size, MAX_RECORD_LENGTH);
            in.readFully(buf);
            this._data = buf;
        }

        @Override
        protected int getDataSize() {
            return this._data.length;
        }

        @Override
        public void serialize(LittleEndianOutput out) {
            out.writeShort(this._sid);
            out.writeShort(this._data.length);
            out.write(this._data);
        }

        @Override
        public UnknownSubRecord copy() {
            return this;
        }

        @Override
        public SubRecordTypes getGenericRecordType() {
            return SubRecordTypes.UNKNOWN;
        }

        @Override
        public Map<String, Supplier<?>> getGenericProperties() {
            return GenericRecordUtil.getGenericProperties("sid", () -> this._sid, "data", () -> this._data);
        }
    }

    public static enum SubRecordTypes {
        UNKNOWN(-1, UnknownSubRecord::new),
        END(0, EndSubRecord::new),
        GROUP_MARKER(6, GroupMarkerSubRecord::new),
        FT_CF(7, FtCfSubRecord::new),
        FT_PIO_GRBIT(8, FtPioGrbitSubRecord::new),
        EMBEDDED_OBJECT_REF(9, EmbeddedObjectRefSubRecord::new),
        FT_CBLS(12, FtCblsSubRecord::new),
        NOTE_STRUCTURE(13, NoteStructureSubRecord::new),
        LBS_DATA(19, LbsDataSubRecord::new),
        COMMON_OBJECT_DATA(21, CommonObjectDataSubRecord::new);

        private static final Map<Short, SubRecordTypes> LOOKUP;
        public final short sid;
        public final RecordConstructor<?> recordConstructor;

        private SubRecordTypes(int sid, RecordConstructor<?> recordConstructor) {
            this.sid = (short)sid;
            this.recordConstructor = recordConstructor;
        }

        public static SubRecordTypes forSID(int sid) {
            return LOOKUP.getOrDefault((short)sid, UNKNOWN);
        }

        public short getSid() {
            return this.sid;
        }

        static {
            LOOKUP = Collections.unmodifiableMap(Arrays.stream(SubRecordTypes.values()).collect(Collectors.toMap(SubRecordTypes::getSid, Function.identity())));
        }

        @FunctionalInterface
        public static interface RecordConstructor<T extends SubRecord> {
            public T apply(LittleEndianInput var1, int var2, int var3);
        }
    }
}

