/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibpoi.org.apache.poi.poifs.filesystem;

import com.dataiku.dss.shadelibpoi.org.apache.poi.EncryptedDocumentException;
import com.dataiku.dss.shadelibpoi.org.apache.poi.poifs.crypt.Decryptor;
import com.dataiku.dss.shadelibpoi.org.apache.poi.poifs.crypt.EncryptionInfo;
import com.dataiku.dss.shadelibpoi.org.apache.poi.poifs.filesystem.DirectoryNode;
import com.dataiku.dss.shadelibpoi.org.apache.poi.poifs.filesystem.FileMagic;
import com.dataiku.dss.shadelibpoi.org.apache.poi.poifs.filesystem.POIFSFileSystem;
import com.dataiku.dss.shadelibpoi.org.apache.poi.util.Internal;
import com.dataiku.dss.shadelibpoi.org.apache.poi.util.Removal;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.GeneralSecurityException;

@Internal
public final class DocumentFactoryHelper {
    private DocumentFactoryHelper() {
    }

    public static InputStream getDecryptedStream(final POIFSFileSystem fs, String password) throws IOException {
        return new FilterInputStream(DocumentFactoryHelper.getDecryptedStream(fs.getRoot(), password)){

            @Override
            public void close() throws IOException {
                fs.close();
                super.close();
            }
        };
    }

    public static InputStream getDecryptedStream(DirectoryNode root, String password) throws IOException {
        if (root.hasEntryCaseInsensitive("Package")) {
            return root.createDocumentInputStream("Package");
        }
        EncryptionInfo info = new EncryptionInfo(root);
        Decryptor d = Decryptor.getInstance(info);
        try {
            boolean passwordCorrect = false;
            if (password != null && d.verifyPassword(password)) {
                passwordCorrect = true;
            }
            if (!passwordCorrect && d.verifyPassword("VelvetSweatshop")) {
                passwordCorrect = true;
            }
            if (passwordCorrect) {
                return d.getDataStream(root);
            }
            if (password != null) {
                throw new EncryptedDocumentException("Password incorrect");
            }
            throw new EncryptedDocumentException("The supplied spreadsheet is protected, but no password was supplied");
        }
        catch (GeneralSecurityException e) {
            throw new IOException(e);
        }
    }

    @Deprecated
    @Removal(version="4.0")
    public static boolean hasOOXMLHeader(InputStream inp) throws IOException {
        return FileMagic.valueOf(inp) == FileMagic.OOXML;
    }
}

