/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibpoi.org.apache.poi.ss.formula.functions;

import com.dataiku.dss.shadelibpoi.org.apache.poi.ss.formula.TwoDEval;
import com.dataiku.dss.shadelibpoi.org.apache.poi.ss.formula.eval.ErrorEval;
import com.dataiku.dss.shadelibpoi.org.apache.poi.ss.formula.eval.MissingArgEval;
import com.dataiku.dss.shadelibpoi.org.apache.poi.ss.formula.eval.NumberEval;
import com.dataiku.dss.shadelibpoi.org.apache.poi.ss.formula.eval.ValueEval;
import com.dataiku.dss.shadelibpoi.org.apache.poi.ss.formula.functions.CountUtils;
import com.dataiku.dss.shadelibpoi.org.apache.poi.ss.formula.functions.Function;

public final class Count
implements Function {
    private final CountUtils.I_MatchPredicate _predicate;
    private static final CountUtils.I_MatchPredicate defaultPredicate = valueEval -> {
        if (valueEval instanceof NumberEval) {
            return true;
        }
        return valueEval == MissingArgEval.instance;
    };
    private static final CountUtils.I_MatchPredicate subtotalPredicate = new CountUtils.I_MatchAreaPredicate(){

        @Override
        public boolean matches(ValueEval valueEval) {
            return defaultPredicate.matches(valueEval);
        }

        @Override
        public boolean matches(TwoDEval areEval, int rowIndex, int columnIndex) {
            return !areEval.isSubTotal(rowIndex, columnIndex);
        }
    };
    private static final CountUtils.I_MatchPredicate subtotalVisibleOnlyPredicate = new CountUtils.I_MatchAreaPredicate(){

        @Override
        public boolean matches(ValueEval valueEval) {
            return defaultPredicate.matches(valueEval);
        }

        @Override
        public boolean matches(TwoDEval areEval, int rowIndex, int columnIndex) {
            return !areEval.isSubTotal(rowIndex, columnIndex) && !areEval.isRowHidden(rowIndex);
        }
    };

    public Count() {
        this._predicate = defaultPredicate;
    }

    private Count(CountUtils.I_MatchPredicate criteriaPredicate) {
        this._predicate = criteriaPredicate;
    }

    @Override
    public ValueEval evaluate(ValueEval[] args, int srcCellRow, int srcCellCol) {
        int nArgs = args.length;
        if (nArgs < 1) {
            return ErrorEval.VALUE_INVALID;
        }
        if (nArgs > 30) {
            return ErrorEval.VALUE_INVALID;
        }
        int temp = 0;
        for (ValueEval arg : args) {
            temp += CountUtils.countArg(arg, this._predicate);
        }
        return new NumberEval(temp);
    }

    public static Count subtotalInstance(boolean includeHiddenRows) {
        return new Count(includeHiddenRows ? subtotalPredicate : subtotalVisibleOnlyPredicate);
    }
}

